---
name: mimeng-writing
description: 咪蒙爆款文章写作技巧。适用于需要创作10万+阅读量爆款文章、情感共鸣类内容、故事叙事或社会议题评论时使用。掌握标题制造、开篇设计、情绪调动、金句提炼、故事叙事等核心技巧。
metadata:
  author: Qianru Tian
  email: fleurytian@gmail.com
  social: 小红书@如宝｜AI&Analytics
  GitHub:fleurytian
---

# 咪蒙写作技巧 - 10万+爆款文章创作指南

## 一、标题制造技巧(决定80%点击率)

### 0. 标题底层认知(先建立心法)

#### 标题的本质
标题不是文章的概括,**标题是诱饵**。它的唯一目的是让人点进来。

#### 咪蒙标题的核心特征
通过分析大量标题发现,咪蒙的标题有5大共性:

**特征1: 强烈的情绪冲击**
- 不是冷静叙述,而是情绪爆发
- 常用情绪词: 怎么好意思/算老几/不如/给不了/熬过
- 让读者第一眼就感受到愤怒/委屈/无奈/反抗

**特征2: 违背常识的观点**
- "有钱男人喜欢丑女人" ← 打破认知
- "熬过难熬的日子,是更难熬的日子" ← 反鸡汤
- "七夕排队离婚" ← 反向节日
- 核心: 说出反直觉的话,制造认知失调

**特征3: 口语化和对话感**
- 不是"论借钱不还的道德困境"
- 而是"你这么有钱,怎么好意思催我还钱?"
- 像朋友在跟你抱怨,不是在写论文

**特征4: 具体场景而非抽象概念**
- 不是"婚姻的困境"
- 而是"七夕,我在民政局排队离婚"
- 让读者脑海中立即浮现画面

**特征5: 替弱者发声的姿态**
- "欺负我的人很多,你算老几" ← 为被欺负的人出气
- "对渣男掏心掏肺,不如和闺蜜睡一睡" ← 为受伤的女生撑腰
- 读者会觉得"这是在替我说话"

#### 标题创作的三个底层逻辑

**逻辑1: 痛点>甜点**
- 写爽不如写痛
- "七夕秀恩爱"的文章不如"七夕排队离婚"吸引人
- 因为痛才需要被看见,被治愈

**逻辑2: 冲突>和谐**
- 必须有对立面
- "你这么有钱"vs"催我还钱"
- "对渣男掏心掏肺"vs"和闺蜜睡一睡"
- 没有冲突=没有点击

**逻辑3: 情绪>信息**
- 标题不是传递信息,是传递情绪
- "如何处理借钱不还的问题" ← 信息型,冷静,不吸引人
- "你这么有钱,怎么好意思催我还钱?" ← 情绪型,愤怒,想点进去

#### 标题测试标准(自检清单)

看到这个标题,读者会:
- [ ] **情绪反应**: 生气/共鸣/好奇/震惊
- [ ] **认知冲突**: "怎么可能?""不会吧?"
- [ ] **对号入座**: "说的就是我!""我也遇到过!"
- [ ] **传播冲动**: "必须转给XX看"

如果4个都没有,标题失败。有2个以上,合格。全中,爆款。

---

### 1. 七大标题公式

#### 公式1: 反常识冲击型
**结构**: 说出来你可能不信 + 颠覆认知的观点
**案例**:
- "说出来你可能不信，有钱男人喜欢丑女人"
- "女博士比网红更容易嫁豪门"

**要点**: 
- 打破大众固有认知
- 制造认知失调感
- 引发"怎么可能"的质疑

#### 公式2: 对话式质问型
**结构**: 你这么X + 怎么好意思 + Y
**案例**:
- "你这么有钱，怎么好意思催我还钱?"
- "你这么优秀，怎么好意思让女朋友受委屈?"

**要点**:
- 第二人称直接质问
- 制造道德压力
- 暗含价值判断

#### 公式3: 反向节日营销型
**结构**: 节日名 + 相反行为
**案例**:
- "七夕，我在民政局排队离婚"
- "情人节，我删了他的微信"

**要点**:
- 利用节日热点
- 制造反差冲突
- 激发猎奇心理

#### 公式4: 硬气宣言型
**结构**: XXX的人很多 + 你算老几
**案例**:
- "欺负我的人很多，你算老几"
- "看不起我的人很多，你算哪根葱"

**要点**:
- 展现强硬态度
- 满足读者爽感
- 代言弱势群体

#### 公式5: 反鸡汤+丧文化型
**结构**: 熬过X + 是更X的X
**案例**:
- "熬过难熬的日子，是更难熬的日子"
- "挺过最难的时刻，是更难的时刻"

**要点**:
- 打破励志鸡汤
- 贴近真实生活
- 引发丧文化共鸣

#### 公式6: 对比替换型
**结构**: 对A掏心掏肺 + 不如对B做X
**案例**:
- "对渣男掏心掏肺，不如和闺蜜睡一睡"
- "为老板卖命，不如为自己拼命"

**要点**:
- AB对比强烈
- 价值观重排
- 行动建议明确

#### 公式7: 条件补偿型
**结构**: 给不了你A + 那就给你B吧
**案例**:
- "给不了你结婚证，那就给你房产证吧!"
- "给不了你爱情，那就给你面包吧"

**要点**:
- 承认缺陷
- 提供替代
- 制造悬念

### 2. 标题创作原则

**必备元素**:
- ✅ 冲突感(制造矛盾)
- ✅ 共鸣点(戳中痛点)
- ✅ 话题性(可讨论)
- ✅ 情绪值(引发情绪)

**禁忌**:
- ❌ 平铺直叙
- ❌ 含糊其辞
- ❌ 过于文艺
- ❌ 标题党(内容不符)

### 3. 标题创作进阶技巧

#### 技巧1: 关键词前置法
把最有冲击力的词放在前面
- ❌ "我在民政局排队离婚的那个七夕"
- ✅ "七夕,我在民政局排队离婚"

#### 技巧2: 制造悬念缺口
留一个"为什么"让读者好奇
- "熬过难熬的日子,是更难熬的日子" ← 为什么会更难熬?
- "有钱男人喜欢丑女人" ← 为什么会喜欢?

#### 技巧3: 利用对比反差
把两个不该在一起的东西放在一起
- "七夕"(浪漫) vs "离婚"(破裂)
- "有钱男人"(高标准) vs "丑女人"(低价值观)
- "掏心掏肺"(深情) vs "睡一睡"(轻松)

#### 技巧4: 第二人称质问
用"你"直接对话,制造代入感
- "你这么有钱,怎么好意思催我还钱?"
- "你算老几"

#### 技巧5: 数字增强可信度
在标题中适度使用数字(但不要太多)
- "7个让有钱男人心动的特质" ← 不要这样,太像标题党
- 咪蒙很少用数字,更多用情绪词

#### 技巧6: 热点嫁接法
把时事热点和痛点结合
- "七夕"这个节日 + 离婚这个痛点
- "贝佐斯离婚" + 审美观念痛点

### 4. 标题创作的五个维度

#### 维度1: 冲突强度(1-10分)
- 1-3分: 太平淡,没人看
- 4-6分: 有点意思,可能点
- 7-8分: 冲突明显,大多会点
- 9-10分: 极端冲突,必点但可能过度

**案例打分**:
- "如何处理借钱的问题" - 2分
- "朋友借钱不还怎么办" - 5分  
- "你这么有钱,怎么好意思催我还钱?" - 9分

#### 维度2: 情绪浓度(1-10分)
标题带来的情绪有多强烈?
- "欺负我的人很多,你算老几" - 9分(愤怒)
- "七夕,我在民政局排队离婚" - 8分(悲凉)
- "对渣男掏心掏肺,不如和闺蜜睡一睡" - 7分(醒悟)

#### 维度3: 痛点精准度(1-10分)
能戳中多少人的痛点?
- "熬过难熬的日子,是更难熬的日子" - 9分(人人都有)
- "你这么有钱,怎么好意思催我还钱?" - 8分(很多人遇过)

#### 维度4: 话题争议度(1-10分)
能引发多大讨论?
- "有钱男人喜欢丑女人" - 10分(绝对有争议)
- "给不了你结婚证,那就给你房产证吧" - 8分(价值观争议)

#### 维度5: 传播欲望(1-10分)
看到后想不想转发?
- 会让人想要转给特定的人看
- "你这么有钱..."→ 转给借钱不还的人
- "对渣男掏心..."→ 转给失恋的闺蜜

### 5. 标题的A/B测试思维

咪蒙团队会准备多个标题备选,内部测试后选最优的。

**同一主题的不同标题版本**:

主题: 借钱不还
- 版本A: "朋友借钱不还怎么办" ← 太平淡
- 版本B: "借钱容易,还钱难" ← 太平庸  
- 版本C: "你这么有钱,怎么好意思催我还钱?" ← ✅最优

主题: 婚姻困境
- 版本A: "婚姻中的冷暴力" ← 太严肃
- 版本B: "结婚容易,相处难" ← 太鸡汤
- 版本C: "七夕,我在民政局排队离婚" ← ✅最优

**测试方法**:
1. 给3-5个朋友看标题(不看内容)
2. 问: 你会点开吗?
3. 问: 看完会转发吗?
4. 选得分最高的

### 6. 标题与内容的匹配度

**重要原则**: 标题可以夸张,但不能欺骗

**好的匹配**:
- 标题: "你这么有钱,怎么好意思催我还钱?"
- 内容: 真的讲了借钱不还的各种极品案例 ✅

**坏的匹配**(标题党):
- 标题: "你这么有钱,怎么好意思催我还钱?"  
- 内容: 讲如何理财... ❌

**咪蒙的平衡术**:
- 标题带情绪,但内容有故事支撑
- 标题有冲突,但内容有逻辑论证
- 标题看起来过分,但看完觉得"说得对"

---

## 二、开篇设计技巧(前3段决定跳出率)

### 1. 五种黄金开头

#### 类型1: 问题爆炸式
**结构**: 一个生活小问题 → 引爆情绪
**案例**:
```
问大家一个生活小常识啊。
AK47去哪里买?
今天下午，我本来正在写今天要发的文章，
中途一个同事在群里发了几张截图，我一看就炸了。
```

**技巧**:
- 用荒诞问题吸引注意
- 快速进入主题
- 展示真实情绪

#### 类型2: 场景代入式
**结构**: 普遍经历 + 我也一样
**案例**:
```
应该大部分女生都跟闺蜜睡过吧。
我说的是，睡一张床，盖着被子聊天，那种睡。
从小到大，我都喜欢去闺蜜家睡觉...
```

**技巧**:
- 从共同体验切入
- 制造亲近感
- 引出个人故事

#### 类型3: 悬念钩子式
**结构**: 反常场景 + 为什么
**案例**:
```
这样好的天气里，我要参加一个初中同学的葬礼。
人回忆最丰盛的时刻除了分手、结婚和临终，
还有一个，就是在熟人的葬礼上。
```

**技巧**:
- 制造悬念
- 引发好奇
- 情绪铺垫

#### 类型4: 直击痛点式
**结构**: 点名问题 + 展示证据
**案例**:
```
今天七夕。
很多人会在今天结婚，这毋庸置疑。
然而，有人会在七夕这天离婚吗?
带着这个疑问，今天我和我的同事分成三组，
分别到北京三个婚姻登记处实地采访。
```

**技巧**:
- 抛出争议话题
- 用实地调查增强真实感
- 制造反差

#### 类型5: 颠覆认知式
**结构**: 常识 → 但事实是...
**案例**:
```
来吧，今天我们来讨论一个永恒的话题:
到底要怎样才能嫁给有钱人?
要腿长两米、胸围36E，还是长得像范冰冰?
正确答案是: 都!不!是!
```

**技巧**:
- 设置常规预期
- 强力推翻
- 制造惊喜

### 2. 开篇三段黄金结构

**第1段**: 抛钩子(问题/场景/悬念)
**第2段**: 制造冲突(但是/然而/结果)
**第3段**: 情绪爆发(我一看就炸了/靠/妈耶)

---

## 三、情绪调动技巧(让读者骂骂咧咧看完)

### 1. 情绪阶梯设计

**完整情绪曲线**:
```
平静铺垫 → 小冲突 → 愤怒爆发 → 极度绝望 → 反转惊喜 → 温情治愈
```

**案例分析**("欺负我的人很多,你算老几"):
- **平静**: 参加葬礼回忆过去
- **小冲突**: 被猴子欺负吃粉笔
- **愤怒**: 何畏背叛打我一棍
- **绝望**: 朋友变成最恨的人
- **反转**: 原来是为了保护我
- **治愈**: 理解他的苦心

### 2. 情绪爆发点制造

#### 技巧1: 聊天记录截图
**用法**: 展示真实对话,让读者亲眼看到"极品"
**案例**: 借钱不还的聊天记录
- "你这么说就有点咄咄逼人了"
- "我当时我你借钱的时候你说不着急"
- "不是我不想还,是我真的还不出来"

**效果**: 比叙述更有冲击力,读者会气炸

#### 技巧2: 细节描写制造画面感
**案例**:
```
"他一手捏开我的嘴，一手抓起讲台上的粉笔塞进我嘴里。
我的舌尖刚碰到粉笔就被吸走了水分，
粗粒的质感剐蹭着我的喉咙。"
```

**要点**:
- 调动五感(触觉/味觉)
- 慢镜头描写
- 让读者感同身受

#### 技巧3: 金句爆发
**结构**: 短句 + 排比 + 反转
**案例**:
```
"我和你，已经无架可吵。
我和你，已经无话可说。"

"在坏人面前，我们不能示弱。
在父母面前，我们忙着逞强。
只有在闺蜜面前，我们才能暴露脆弱。"
```

**技巧**:
- 用短句增强节奏
- 排比制造气势
- 最后一句反转或升华

### 3. 情绪强化词库

**愤怒系**:
- 妈蛋 / 靠 / 我擦 / 气炸了 / 吐血 / 想掏枪崩了对方
- 傻逼 / 极品 / 贱人 / 渣男 / 垃圾

**绝望系**:
- 崩溃 / 窒息 / 心死 / 无力 / 黑暗 / 隐形的

**惊喜系**:
- 妈耶 / 我靠 / 心动了 / 爱上了 / 扎心了

**使用原则**:
- 真实口语化
- 不矫揉造作
- 符合人物身份

---

## 四、故事叙事技巧(让人看哭)

### 1. 叙事视角选择

#### 视角1: 第一人称旁观者(最常用)
**结构**: "我的同事/朋友/读者..."
**优势**:
- 保持客观性
- 增强真实感
- 便于多角度评论

**案例**:
```
"我同事楚楚也讲了她和闺蜜的事。
她从山东来北京，第一次来大城市，心里挺没底的。
3个月实习期结束那天，发生了一件好事，和一件坏事..."
```

#### 视角2: 全知视角(用于深度故事)
**用法**: 直接讲述主角故事
**案例**: "张伟和李芳的故事"

### 2. 悬念设置技巧

#### 层层递进法
**结构**: 
- 表层悬念: 何畏为什么打我?
- 深层悬念: 他做了什么让我免受欺负?
- 终极反转: 原来成为校霸是为了保护我

**要点**:
- 每个悬念解开后立即设置新悬念
- 最后反转必须合理且动人
- 伏笔要埋得自然

#### 信息差制造法
**技巧**: 读者知道的 ≠ 主角知道的
**案例**:
```
"何畏说，我不要再哭了，我不要再过这样的日子。"
(读者以为何畏要逃避)
后来发现: 他是要变强大来保护"我"
```

### 3. 细节描写原则

#### 关键细节放大
**案例**:
```
"何畏指着手心的黑色烟疤，说，
你看，像不像一颗按钮?
只要按一下，就可以重启你的人生了。"
```

**要点**:
- 选择有象征意义的细节
- 重复出现强化印象
- 最后升华

#### 五感调动
- **视觉**: 红墨水顺着眉毛往下流
- **触觉**: 粗粒的粉笔剐蹭喉咙
- **听觉**: 门"啪"地一下被反锁
- **嗅觉**: 烟头烫皮肤的焦糊味
- **味觉**: 粉笔吸走舌尖水分

### 4. 对话设计技巧

#### 黄金对话三原则
1. **短**: 每句不超过15字
2. **冲突**: 必有交锋
3. **信息量**: 推动情节

**好的对话**:
```
"你不相信我?"
"如果你不信任我，我还如何坚持下去。"
```

**差的对话**(避免):
```
"我觉得你好像不太相信我的样子..."
"我只是有点担心..."
```

---

## 五、金句提炼技巧

### 1. 金句创作公式

#### 公式1: 对比反转式
**结构**: 我们以为A，其实B
**案例**:
- "借的是钱，付出的利息却是友情"
- "对于相爱的人来说，今天是七夕。对于不爱的人来说，今天只是周一"

#### 公式2: 排比升华式
**结构**: A是X，B是Y，C才是Z
**案例**:
```
"我和你，会渐行渐远;
而闺蜜，我们会一睡如故。"
```

#### 公式3: 悖论制造式
**结构**: 越X，越Y(违背常识)
**案例**:
- "熬过难熬的日子，是更难熬的日子"
- "离婚的人来得特别早，因为一刻都不想再多待"

#### 公式4: 结论宣言式
**结构**: 所有的X，都Y
**案例**:
- "所有的背叛，都是蓄谋已久"
- "有些人，一直伪装自己，只是想让一个人不受伤害"

### 2. 金句使用位置

**位置1**: 段落结尾(强化记忆)
**位置2**: 情绪高潮后(画龙点睛)
**位置3**: 全文结尾(升华主题)

**密度**: 每300字出现1个金句

---

## 六、结尾设计技巧

### 1. 四种经典结尾

#### 类型1: 反转升华式
**结构**: 故事主线结束 + 意外反转 + 价值升华
**案例**:
```
"也许，有些人，一直伪装自己，
只是想让一个人，不受伤害，不再哭。"
```

#### 类型2: 金句点睛式
**结构**: 概括主题 + 金句收尾
**案例**:
```
"我们最怕的，不是钱没了，
而是朋友也没了。"
```

#### 类型3: 行动召唤式
**结构**: 给出建议 + 鼓励行动
**案例**(借钱不还文章):
```
"对付不还钱的人，只有几种办法:
1. 不借
2. 以牙还牙
3. 只给一次机会
4. 让对方填借钱申请表"
```

#### 类型4: 留白思考式
**结构**: 抛出问题 + 不给答案
**案例**:
```
"钱与尊严，挣脱与代价。
哪个更重要，你想好没有?"
```

### 2. 结尾禁忌

❌ **说教式结尾**: "所以我们要..."
❌ **废话重复**: 复述全文观点
❌ **突然鸡汤**: 前面丧后面突然励志
❌ **虎头蛇尾**: 草草收场

---

## 七、情感共鸣点挖掘

### 1. 十大痛点主题

#### 主题1: 被欺负/被欺骗
**痛点**: 弱者的无力感
**共鸣**: "我也被这样对待过"
**案例**: 校园霸凌故事

#### 主题2: 友情背叛
**痛点**: 信任崩塌
**共鸣**: "最痛的是被朋友伤害"
**案例**: 借钱不还、商业背叛

#### 主题3: 婚姻困境
**痛点**: 对婚姻的恐惧
**共鸣**: "婚姻真的很难"
**案例**: 七夕排队离婚

#### 主题4: 阶层焦虑
**痛点**: 跨越阶层的代价
**共鸣**: "穷真的很可怕"
**案例**: 张伟和李芳的故事

#### 主题5: 女性困境
**痛点**: 性别带来的限制
**共鸣**: "女人太难了"
**案例**: 在国内vs国外的审美差异

#### 主题6: 原生家庭创伤
**痛点**: 童年阴影
**共鸣**: "我也有这样的经历"
**案例**: 小叶对房子的执念(父亲私奔卖房)

#### 主题7: 社会不公
**痛点**: 被践踏的尊严
**共鸣**: "这个社会就是这样"
**案例**: 富豪出轨、权力不平等

#### 主题8: 真假闺蜜
**痛点**: 女性友谊的珍贵
**共鸣**: "还好我有闺蜜"
**案例**: 闺蜜陪伴系列

#### 主题9: 金钱观冲突
**痛点**: 钱与感情的矛盾
**共鸣**: "谈钱就伤感情"
**案例**: 借钱、买房

#### 主题10: 社会审美暴力
**痛点**: 容貌焦虑
**共鸣**: "我不够漂亮所以..."
**案例**: 有钱男人的审美

### 2. 共鸣点制造技巧

#### 技巧1: 具体化痛点
**错误**: "生活很难"
**正确**: "年底了，火车票抢不到，身上的钱不够，你之前借我的1000块能不能先还我"

#### 技巧2: 代入读者视角
**使用**: "你有没有遇到过..."
**效果**: 让读者对号入座

#### 技巧3: 利用热点事件
**方法**: 贝佐斯离婚 → 引发婚姻/审美/阶层讨论
**要点**: 快速反应，蹭热度

---

## 八、叙事节奏控制

### 1. 长短句搭配

**快节奏**(制造紧张):
```
"他走了。
所有人都找不到他。
一个礼拜后，小叶收到老白的短信:我结婚了。"
```

**慢节奏**(营造氛围):
```
"小叶鼻子发酸，没想到老白消失的这些天，
给自己做了最周全的安排。"
```

### 2. 情节密度设计

**密集情节区**(高潮): 每50字一个转折
**舒缓过渡区**(铺垫): 环境/心理描写

### 3. 时间线设计

#### 技巧1: 倒叙制造悬念
**案例**:
```
"这样好的天气里，我要参加一个初中同学的葬礼"
(先说结果)
"还记得是初一的分班考试..."
(再讲原因)
```

#### 技巧2: 插叙丰富背景
**用法**: 故事进行中插入回忆
**标志**: "还记得..."、"那时候..."

#### 技巧3: 时间戳增强真实感
**案例**:
```
"上午10点 - 北京东城区婚姻登记处
上午11点 - 北京朝阳区婚姻登记处
下午2点 - 北京西城区婚姻登记处"
```

---

## 九、真实感营造技巧

### 1. 细节真实化

#### 品牌/地点具体化
**错误**: "去商场买衣服"
**正确**: "在朝阳大悦城的ZARA买衣服"

**错误**: "开豪车"
**正确**: "开着一汽马自达CX-4"

#### 数字精确化
**错误**: "借了很多钱"
**正确**: "借了1000块"

**错误**: "很贵"
**正确**: "扫地机器人1299元"

### 2. 对话口语化

**书面化**(避免):
```
"我认为你的这种行为非常不妥当"
```

**口语化**(推荐):
```
"你这么说就有点咄咄逼人了"
```

### 3. 证据展示

- **聊天记录截图**
- **新闻报道链接**
- **实地采访记录**
- **时间地点详细描述**

---

## 十、价值观传递技巧

### 1. 隐藏说教

#### 错误方式:
```
"所以我们应该珍惜友谊，不要被金钱污染..."
```

#### 正确方式:
```
(通过故事自然展现)
"借的是钱，付出的利息却是友情"
```

### 2. 多元视角平衡

**正方观点**: 应该还钱
**反方观点**: 朋友之间不要太计较
**咪蒙观点**: 该还的就要还，但更可怕的是失去朋友

**技巧**: 不是非黑即白，而是多层次理解

### 3. 情绪与理性平衡

**情绪部分**(60%): 故事、愤怒、共鸣
**理性部分**(40%): 分析、建议、升华

---

## 十一、实战创作流程

### Step 1: 选题(找痛点)

**方法**:
- 观察生活热点
- 后台留言收集
- 热搜话题榜
- 个人经历提炼

**标准**: 能否让100个人中90个人说"对对对"

### Step 2: 拟标题(定生死)

**流程**:
1. 写10个备选标题
2. 套用7大公式
3. 测试3个给朋友
4. 选点击率最高的

**检查清单**:
- [ ] 有冲突吗?
- [ ] 有痛点吗?
- [ ] 有话题吗?
- [ ] 有情绪吗?

### Step 3: 搭框架(定结构)

**万能结构**:
```
开头: 抛钩子(3段)
├─ 问题/场景/悬念
├─ 制造冲突  
└─ 情绪爆发

主体: 故事/案例(5-8段)
├─ 故事1(铺垫)
├─ 故事2(升级)
├─ 故事3(高潮)
└─ 金句穿插

结尾: 升华(2-3段)
├─ 反转/金句
├─ 价值观输出
└─ 行动建议(可选)
```

### Step 4: 写初稿(放感情)

**要点**:
- 一气呵成，不要停
- 用最真实的情绪写
- 不用刻意追求文采
- 写自己相信的东西

### Step 5: 改稿(三遍法)

**第一遍**: 删废话
- 删掉所有"那么"、"然后"
- 删掉所有不必要的形容词
- 每段不超过100字

**第二遍**: 加细节
- 补充五感描写
- 增加对话冲突
- 植入金句

**第三遍**: 调节奏
- 长短句搭配
- 调整段落顺序
- 强化情绪点

### Step 6: 自检(五问法)

1. 我自己会转发吗?
2. 朋友看了会说什么?
3. 最大的共鸣点在哪?
4. 最大的争议点是什么?
5. 价值观输出清晰吗?

---

## 十二、风格特征总结

### 核心特征

#### 1. 情绪化表达
- 不掩饰情绪
- 用粗口增强真实感(适度)
- 情绪饱满贯穿全文

#### 2. 口语化叙事
- 像说话一样写作
- 少用书面语
- 多用短句

#### 3. 故事化说理
- 不直接讲道理
- 用故事传递价值观
- 让读者自己得出结论

#### 4. 真实感营造
- 具体细节
- 聊天记录
- 实地采访

#### 5. 价值观明确
- 站在弱者立场
- 为不公发声
- 传递正向价值(但不鸡汤)

### 语言特色

#### 词汇特征
- **口语化**: 靠、擦、妈蛋、妈耶
- **网络化**: 傻逼、极品、贱人、渣男
- **形象化**: 炸了、崩溃、气炸、扎心

#### 句式特征
- **短句为主**: 5-15字
- **排比增强**: 我和你...我和你...
- **设问反问**: 凭什么? 为什么?

---

## 十三、常见误区与避免

### 误区1: 过度煽情
**表现**: 每段都在哭
**后果**: 读者审美疲劳
**解决**: 情绪有起伏，理性穿插

### 误区2: 观点模糊
**表现**: 写了5000字不知道想说什么
**后果**: 读者看完没有记忆点
**解决**: 一篇文章只说一个观点

### 误区3: 细节过多
**表现**: 每个细节都写
**后果**: 节奏拖沓
**解决**: 只写关键细节，其他一笔带过

### 误区4: 刻意制造冲突
**表现**: 为了撕逼而撕逼
**后果**: 读者反感
**解决**: 冲突源于真实矛盾

### 误区5: 结尾无力
**表现**: 草草收场或过度鸡汤
**后果**: 破坏整体效果
**解决**: 用金句或反转收尾

---

## 十四、高级技巧

### 1. 多线叙事

**技巧**: 2-3条故事线交织
**案例**: "欺负我的人很多"
- 主线: "我"被霸凌的经历
- 副线: 何畏的选择
- 暗线: 何畏保护"我"的真相

**要点**:
- 主线推进情节
- 副线制造悬念
- 暗线最后反转

### 2. 符号化设计

**技巧**: 用一个物品贯穿全文
**案例**: 手心的烟疤 = 重启按钮
**效果**: 
- 增强记忆点
- 便于情感投射
- 最后升华主题

### 3. 对比式结构

**技巧**: A故事 vs B故事
**案例**: "有钱男人喜欢丑女人"
- 国外富豪的审美
- 国内富豪的审美
- 价值观对比

### 4. 采访式叙事

**技巧**: 实地采访 + 多个案例
**案例**: "七夕排队离婚"
- 上午10点 东城区
- 上午11点 朝阳区
- 下午2点 西城区
- 下午4点 西城区

**效果**: 增强真实感，扩大样本量

---

## 十五、创作清单

### 标题创作清单
- [ ] 使用了7大公式中的至少1个
- [ ] 有冲突/痛点/话题/情绪
- [ ] 字数控制在20字以内
- [ ] 读起来有节奏感
- [ ] 能激发转发欲望

### 开篇创作清单
- [ ] 前3段抓住读者
- [ ] 有问题/场景/悬念
- [ ] 情绪值达到30%
- [ ] 主题已暗示
- [ ] 不超过200字

### 故事创作清单
- [ ] 有完整的情节
- [ ] 有清晰的冲突
- [ ] 细节真实具体
- [ ] 对话自然流畅
- [ ] 节奏张弛有度

### 金句创作清单
- [ ] 使用了金句公式
- [ ] 有传播性
- [ ] 简短有力(不超过20字)
- [ ] 位置在关键处
- [ ] 密度适中(每300字1个)

### 结尾创作清单
- [ ] 有反转/升华/行动召唤
- [ ] 呼应标题
- [ ] 价值观明确
- [ ] 留有余味
- [ ] 不超过150字

### 整体检查清单
- [ ] 痛点足够痛
- [ ] 情绪够饱满
- [ ] 故事够动人
- [ ] 金句够扎心
- [ ] 节奏够紧凑
- [ ] 价值观够正
- [ ] 真实感够强
- [ ] 自己想转发

---

## 附录: 经典案例分析

### 案例1: "借钱不还"文章

**标题**: "你这么有钱，怎么好意思催我还钱?"
- **公式**: 对话式质问型
- **冲突**: 借钱vs催钱的道德绑架

**开篇**:
```
问大家一个生活小常识啊。
AK47去哪里买?
```
- **技巧**: 问题爆炸式
- **效果**: 立即抓住注意力

**主体结构**:
1. 聊天记录截图(引爆情绪)
2. 网友极品案例(加强愤怒)
3. 个人经历故事(制造共鸣)
4. 解决方案建议(行动指南)

**金句**:
- "借钱不还的人,真的是当代社会的一大公害"
- "借的是钱，付出的利息却是友情"
- "我们最怕的，不是钱没了，而是朋友也没了"

**结尾**:
给出4个具体方案(行动召唤式)

**效果**: 
- 10万+阅读
- 评论区全是吐槽借钱不还的经历
- 转发率极高

### 案例2: "欺负我的人很多,你算老几"

**标题**: "欺负我的人很多，你算老几"
- **公式**: 硬气宣言型
- **效果**: 满足弱者爽感

**开篇**:
```
"这样好的天气里，我要参加一个初中同学的葬礼。"
```
- **技巧**: 悬念钩子式
- **效果**: 制造悬念和好奇

**叙事技巧**:
- **多线叙事**: "我"的视角 + 何畏的选择
- **悬念递进**: 何畏为什么打我 → 何畏成为校霸 → 原来是为了保护我
- **符号化**: 手心的烟疤 = 重启按钮

**情绪曲线**:
平静(葬礼) → 愤怒(被欺负) → 绝望(被朋友打) → 反转(理解真相) → 治愈(感动)

**细节处理**:
```
"我的舌尖刚碰到粉笔就被吸走了水分，
粗粒的质感剐蹭着我的喉咙。"
```
- 五感调动
- 慢镜头描写
- 感同身受

**金句**:
- "也许，有些人，一直伪装自己，只是想让一个人，不受伤害，不再哭"

**效果**:
- 评论区很多人哭了
- 勾起校园霸凌的回忆
- 讨论友谊和保护

---

## 使用建议

### 适用场景
1. ✅ 情感共鸣类文章(友情/爱情/亲情)
2. ✅ 社会现象评论(借钱/婚姻/阶层)
3. ✅ 女性话题讨论(审美/独立/困境)
4. ✅ 故事化叙事(真人真事改编)
5. ✅ 价值观输出(正向但不鸡汤)

### 不适用场景
1. ❌ 严肃学术论文
2. ❌ 商业软文(太情绪化)
3. ❌ 专业知识科普(需要理性)
4. ❌ 政治敏感话题(风险高)

### 风险提示
1. **情绪过激**: 可能引发争议
2. **价值观争议**: 做好被骂准备
3. **真实性质疑**: 故事需要可信
4. **法律风险**: 避免诽谤和侵权

### 进阶学习
1. 分析更多咪蒙经典文章
2. 练习7大标题公式
3. 收集真实故事素材
4. 培养情绪感知能力
5. 建立自己的金句库

---

**最后提醒**: 咪蒙的技巧是工具，但不是全部。最重要的是:
1. 真诚表达
2. 尊重读者
3. 传递正向价值
4. 不断迭代优化

**创作宗旨**: 让读者看到自己，说出他们想说的话，然后一起变得更好。
