---
name: cardano-cli-plutus-scripts-operator
description: "Execute Plutus script transactions: script spends, datum/redeemer submission. Manual invoke only."
allowed-tools:
  - Bash(cardano-cli:*)
  - Bash(cat:*)
  - Bash(jq:*)
  - Read
  - Write
disable-model-invocation: true
user-invocable: true
context:
  - "!cardano-cli version 2>&1 | head -5"
---

# cardano-cli-plutus-scripts-operator

> **OPERATOR SKILL**: Executes Plutus script transactions. Requires explicit human invocation due to collateral risk.

## When to use
- When ready to spend from a script address
- After reviewing guidance from `cardano-cli-plutus-scripts`

## Operating rules (must follow)
- **ALWAYS verify collateral UTxO is ADA-only**
- Confirm script hash matches expected
- Validate datum/redeemer JSON before use
- **REQUIRE explicit confirmation before submit**
- Test on preprod/preview before mainnet

## Pre-flight checklist
```
[ ] Network: ___________
[ ] Script file (.plutus) verified
[ ] Script hash matches on-chain
[ ] Datum JSON validated
[ ] Redeemer JSON validated
[ ] Collateral UTxO selected (ADA-only!)
[ ] Protocol parameters fresh
```

## Execution workflow

### Step 1: Verify script
```bash
# Get script hash
cardano-cli conway transaction policyid \
  --script-file script.plutus

# Derive script address
cardano-cli conway address build \
  --payment-script-file script.plutus \
  --testnet-magic 1 \
  --out-file script.addr
```

### Step 2: Query script UTxO
```bash
cardano-cli conway query utxo \
  --address $(cat script.addr) \
  --testnet-magic 1
```

### Step 3: Prepare collateral
```bash
# Must be ADA-only UTxO at your payment address
cardano-cli conway query utxo \
  --address <payment-addr> \
  --testnet-magic 1

# Select one with only ADA (no tokens)
```

### Step 4: Build script spend
```bash
cardano-cli conway transaction build \
  --testnet-magic 1 \
  --tx-in <script-utxo>#<index> \
  --tx-in-script-file script.plutus \
  --tx-in-inline-datum-present \
  --tx-in-redeemer-file redeemer.json \
  --tx-in-collateral <collateral-utxo>#<index> \
  --tx-out <recipient>+<amount> \
  --change-address <payment-addr> \
  --out-file tx.unsigned
```

### Step 5: Sign and submit
```bash
# Sign (collateral signer required)
cardano-cli conway transaction sign \
  --tx-file tx.unsigned \
  --signing-key-file payment.skey \
  --testnet-magic 1 \
  --out-file tx.signed

# ⚠️ CONFIRM before submit
echo "=== SCRIPT SPEND CONFIRMATION ==="
echo "Script: $(cat script.addr | head -c 20)..."
echo "Spending UTxO: <script-utxo>"
echo "Collateral: <collateral-utxo>"
echo "Output to: <recipient>"

cardano-cli conway transaction submit \
  --testnet-magic 1 \
  --tx-file tx.signed
```

## Debugging failed scripts
```bash
# If script fails, check execution units
cardano-cli conway transaction build \
  ... \
  --calculate-plutus-script-cost cost.json

# Review cost.json for budget issues
cat cost.json | jq .
```

## Safety / key handling
- Collateral is at risk if script fails unexpectedly
- Use minimal collateral (1-5 ADA typically sufficient)
- Keep datum/redeemer free of secrets
- Verify script logic on testnet first

## References
- `cardano-cli-plutus-scripts` (guidance skill)
- `shared/PRINCIPLES.md`
