# Shownotes.io API Reference

Base URL: `https://plugins.shownotes.io`

## Authentication

All endpoints require OAuth2 authentication with the following scopes:
- `openid`: OpenID Connect
- `email`: User email

Authorization URL: `https://plugins.shownotes.io/oauth/authorize.php`
Token URL: `https://plugins.shownotes.io/oauth/token.php`

## Endpoints

### 1. Apple Podcast Search

**Endpoint:** `GET /apple.php`

**Description:** Search for podcast episodes on Apple Podcasts. Returns up to 3 matching episodes.

**Parameters:**
- `q` (required): Search query for episode

**Response:**
```json
[
  {
    "podcast": "Podcast name",
    "title": "Episode title",
    "releaseDate": "2024-01-01T00:00:00Z",
    "enclosure": "https://example.com/audio.mp3",
    "description": "Episode description",
    "artwork": "https://example.com/artwork.jpg",
    "protect": false
  }
]
```

**Usage Notes:**
- Display results to user with artwork if available
- Allow user to click enclosure link to listen
- If `protect: true`, do not allow transcription

### 2. Audio Transcription

**Endpoint:** `GET /airplugin.php`

**Description:** Request transcription of a podcast episode. Returns a link where transcript will appear.

**Parameters:**
- `enclosure` (required): URL to the episode audio file
- `podcast` (required): Podcast name
- `title` (required): Episode title

**Response:**
```json
{
  "audiolink": "https://example.com/transcript-link"
}
```

**Usage Notes:**
- Transcription may take several minutes
- User will receive an email when ready
- Inform user about wait time

### 3. Get Existing Transcript from Shownotes.io

**Endpoint:** `GET /captions-shownotes.php`

**Description:** Retrieve existing transcript from shownotes.io database.

**Parameters:**
- `show` (required): The show name

**Response:**
```json
{
  "transcript": {
    "chunk1": "First part of transcript...",
    "chunk2": "Second part of transcript..."
  }
}
```

### 4. YouTube Video Search

**Endpoint:** `GET /search-youtube.php`

**Description:** Search YouTube for videos matching a show name. Returns array of 3 videos.

**Parameters:**
- `show` (required): The show name

**Response:**
```json
[
  {
    "name": "Video title",
    "videoid": "11-char-video-id"
  }
]
```

### 5. YouTube Video Transcript

**Endpoint:** `GET /captions-youtube.php`

**Description:** Extract transcript from YouTube video using video ID.

**Parameters:**
- `videoid` (required): The 11-character YouTube video ID

**Response:**
```json
{
  "transcript": {
    "chunk1": "First part of transcript...",
    "chunk2": "Second part of transcript..."
  }
}
```

**Usage Notes:**
- Only use the transcript returned when making summaries
- Do not embellish or add information not in transcript
- User receives an email summary to their inbox
- Transcript is split into two chunks (chunk1 and chunk2)

## Common Patterns

### Transcribing a Podcast Episode

1. Search for episode: `GET /apple.php?q=episode+name`
2. Display results to user
3. User selects episode
4. Check if `protect: true` - if so, do not transcribe
5. Request transcription: `GET /airplugin.php?enclosure=URL&podcast=NAME&title=TITLE`
6. Return audiolink to user

### Getting YouTube Transcript

1. Search YouTube: `GET /search-youtube.php?show=show+name`
2. Display results to user
3. User selects video
4. Get transcript: `GET /captions-youtube.php?videoid=VIDEO_ID`
5. Process transcript (chunk1 + chunk2)

## Error Handling

- Check for `protect: true` flag before transcribing
- Handle OAuth2 authentication failures
- Inform user if transcription service is unavailable
- Verify video IDs are exactly 11 characters for YouTube
