# Narrative Craft Guide

Techniques for embedding craft elements into Crucible outlines.

## Foreshadowing

### The Plant-Water-Payoff Pattern

Every significant payoff needs:
1. **Plant** — First subtle introduction (reader may not notice)
2. **Water** — Reinforcement (reader registers but doesn't understand significance)
3. **Payoff** — Resolution (reader connects back to plant with satisfaction)

### Foreshadowing Types

**Object Foreshadowing**
Plant an object early that becomes crucial later.
```
Plant (Ch 2): Character notices a peculiar knife on mentor's wall
Water (Ch 8): Story of how the knife was made, seemingly in passing
Payoff (Ch 22): That knife is the only thing that can defeat the antagonist
```

**Dialogue Foreshadowing**
A line of dialogue gains meaning later.
```
Plant (Ch 3): "Your shadow shows your true shape" — throwaway wisdom
Water (Ch 12): Protagonist sees their shadow behave strangely
Payoff (Ch 20): The "shadow" is revealed as [connection to Fire]
```

**Character Foreshadowing**
A character's trait/history plants future action.
```
Plant (Ch 5): Companion mentioned they "never learned to swim"
Water (Ch 14): Group must cross a river; companion is terrified
Payoff (Ch 19): Companion drowns saving protagonist (or conquers fear heroically)
```

**Thematic Foreshadowing**
Theme stated early, proven through action later.
```
Plant (Ch 1): Theme stated by wise character
Water (Multiple): Characters debate/embody theme partially
Payoff (Apex): Protagonist's action proves/answers theme
```

### Crucible-Required Foreshadowing

These MUST be planted and paid off:

| Element | Must Plant | Must Payoff |
|---------|-----------|-------------|
| Each Mercy | The recipient + act | Unexpected Agents (Beat 31) |
| Dark Mirror | Antagonist's philosophy | Final confrontation |
| Fire Mastery | The surrender principle | Mastery moment |
| Core Bond | What makes it unbreakable | Bond That Holds (Beat 27) |
| Betrayal | Cracks in the relationship | The apparent betrayal |
| Sacrifice | Character's willingness to die | The death (Beat 25) |

---

## Scene Structure

### Scene Goals

Every scene needs:
1. **POV Goal** — What does the viewpoint character want?
2. **Obstacle** — What prevents them from getting it?
3. **Turn** — How does the situation change by scene's end?

### Scene Turn Types

**Positive Turns** (use sparingly)
- Character gets what they wanted
- Use for: false victories, earned small wins, breathers

**Negative Turns** (primary driver)
- Character fails to get what they wanted
- Use for: building tension, forcing growth, raising stakes

**Revelation Turns**
- Character learns something that changes everything
- Use for: plot pivots, character development, foreshadowing payoffs

**Decision Turns**
- Character must make a choice
- Use for: chapter ends, character-defining moments

### Scene Types for Crucible

**Action Scenes**
- Clear physical goal
- Rising tension
- Consequences
- Best for: Quest strand, Forge Points

**Dialogue Scenes**
- Character objectives in conflict
- Subtext
- Relationship changes
- Best for: Constellation strand, philosophy debates

**Reflection Scenes**
- Internal journey
- Realization
- Minimal external action
- Best for: Fire strand, after major events

**Revelation Scenes**
- Information delivery
- Reaction to information
- Changed understanding
- Best for: Dark Mirror reveals, sanctuary chapters

---

## Pacing

### Tension Curve

```
                        FP3 ●
                       /    \        APEX ●
             FP2 ●    /      \      /     \
            /    \  /        \    /       \
    FP1 ●  /      \/          \  /         ●● Coda
   /    \ /                    \/
  /      ●                      
 /       
● Start
```

**Rules:**
- Overall tension rises through the book
- Each Forge Point is a local peak
- Valleys allow reader recovery and character reflection
- Apex is the highest tension point
- Coda provides gentle decline

### Chapter-Level Pacing

**High-Tension Chapters:**
- Shorter scenes
- More white space
- Clipped sentences
- Focus on action/dialogue
- End on cliffhangers

**Low-Tension Chapters:**
- Longer scenes
- More description
- Flowing prose
- Focus on character/world
- End on emotional beats

### Pacing Mistakes to Avoid

- **All tension, no valleys**: Reader exhaustion
- **Long valleys**: Momentum death
- **False climaxes**: Crying wolf
- **Rushed Forge Points**: Unearned moments
- **Slow finale**: Anticlimactic

---

## POV Management

### Single POV
- All tension filtered through one character
- Limits information to what POV knows
- Deep intimacy with protagonist

### Dual POV
- Alternate by chapter or scene
- Each POV should have distinct voice
- Use for: ironic tension, parallel journeys, information control

**Best Practices for Dual POV:**
```
CHAPTER PATTERN OPTIONS:

Alternating:   A-B-A-B-A-B-A-B
Weighted:      A-A-B-A-A-B-A-A (protagonist heavy)
Convergent:    A-A-A-B-B-A-B-A-B-A-B (second POV enters later)
```

### POV Selection Per Chapter

Choose POV based on:
1. **Who has the most at stake?** — Primary consideration
2. **What can be revealed?** — Information control
3. **Who changes most?** — Character development
4. **What serves the strand?** — Quest/Fire/Constellation focus

---

## Chapter Endings

### The Hook

Every chapter ending must create forward pull:

**Cliffhanger Hooks**
- Physical danger
- Interrupted action
- "And then the door opened and—"
- Use sparingly (2-3 per book)

**Revelation Hooks**
- "She realized the truth."
- Information that reframes everything
- Question raised that demands answer

**Decision Hooks**
- Character commits to action
- "There was only one choice left."
- Stakes clear, outcome uncertain

**Emotional Hooks**
- A feeling that lingers
- Relationship shift
- Internal realization
- Subtle but effective

**Question Hooks**
- Explicit or implicit question
- "What would happen when they found out?"
- Reader needs the answer

### Chapter Ending Don'ts

- Don't end on resolution (until Coda)
- Don't end with character going to sleep (unless nightmares)
- Don't end mid-scene awkwardly
- Don't end with extended reflection
- Don't give the reader a clean stopping point

---

## Subtext and Layering

### Dialogue Subtext

What characters say ≠ What characters mean

**Example:**
```
Surface: "I hope your training goes well."
Subtext: "I don't believe you'll survive this."
```

### Action Subtext

What characters do reveals what they won't say.

**Example:**
```
Action: Character cleans their weapon three times before battle.
Subtext: They're terrified but won't admit it.
```

### Environmental Subtext

Setting reflects emotional state.

**Example:**
```
Event: Protagonist's lowest point
Setting: Driving rain, failed crops, dead trees
Connection: World mirrors internal state
```

---

## Checklist Per Chapter

Before finalizing any chapter outline, verify:

- [ ] Clear scene goals for each scene
- [ ] At least one turn/reversal
- [ ] Strand focus identified
- [ ] Connection to Crucible beat(s)
- [ ] At least one foreshadowing plant OR payoff
- [ ] Chapter ending creates forward pull
- [ ] Tension level appropriate to position in book
- [ ] POV choice justified
- [ ] No strand absent more than 2 consecutive chapters
