# Outline Templates

Standard formats for chapter and scene outlines.

## Master Outline Template

```markdown
# [BOOK TITLE] — Master Outline

## Overview
- **Series:** [Series name if applicable]
- **Book:** [X of Y]
- **Target Length:** [word count]
- **Chapter Count:** [number]
- **POV:** [Single/Dual/Multiple]

## Theme
[Theme statement from Crucible Thesis]

## Core Elements
- **Burden:** [From Crucible Thesis]
- **Fire:** [From Crucible Thesis]
- **Core Bond:** [From Crucible Thesis]
- **Dark Mirror:** [From Crucible Thesis]

## Movement Breakdown

### MOVEMENT I — IGNITION (Chapters 1-X)
[Summary of movement arc]

### MOVEMENT II — FIRST TEMPERING (Chapters X-X)
[Summary of movement arc]

### MOVEMENT III — SCATTERING (Chapters X-X)
[Summary of movement arc]

### MOVEMENT IV — BRIGHTEST BURNING (Chapters X-X)
[Summary of movement arc]

### MOVEMENT V — FINAL FORGING (Chapters X-X)
[Summary of movement arc]

### CODA (Chapter X)
[Summary]

---

## Chapter Outlines

[Individual chapter outlines follow]
```

---

## Chapter Outline Template (Detailed)

```markdown
# Chapter [X]: [TITLE]

## Metadata
- **Beats:** [Which Crucible beats]
- **Strand Focus:** [Quest/Fire/Constellation]
- **POV:** [Character name]
- **Location(s):** [Setting]
- **Timeline:** [When in story time]
- **Word Target:** [Approximate word count]

## Purpose
[1-2 sentences: Why does this chapter exist? What MUST it accomplish?]

## Opening
**Type:** [Action/Reflection/Dialogue/World]
**Hook:** [What draws reader in immediately]
**Starting Point:** [Where/when exactly does chapter begin]

## Scene Breakdown

### Scene 1: [Scene Title]
**Goal:** [POV character wants...]
**Conflict:** [What prevents...]
**Turn:** [How it shifts]
**Characters:** [Who's present]
**Location:** [Where]
**Key Moments:**
- [Moment 1]
- [Moment 2]
**Plants/Payoffs:**
- Plants: [What this scene sets up]
- Pays off: [What previous setup this resolves]

### Scene 2: [Scene Title]
[Same structure]

### Scene 3: [Scene Title]
[Same structure]

## Chapter Turn
**Type:** [Cliffhanger/Revelation/Decision/Emotional/Question]
**The Turn:** [What happens]
**Reader State:** [How should reader feel]

## Connections
- **Previous Chapter:** [How this follows from Ch X-1]
- **Next Chapter:** [How this leads to Ch X+1]
- **Foreshadowing Plants:** [List what's planted]
- **Foreshadowing Payoffs:** [List what's paid off]

## Notes
[Any additional considerations]
```

---

## Chapter Outline Template (Compact)

```markdown
# Ch [X]: [TITLE]

**Beats:** [X-X] | **Strand:** [Q/F/C] | **POV:** [Name]

## Summary
[2-3 sentence chapter summary]

## Scenes
1. **[Scene Title]** — [Goal] → [Turn]
2. **[Scene Title]** — [Goal] → [Turn]
3. **[Scene Title]** — [Goal] → [Turn]

## End Hook
[Chapter ending / forward pull]

## Plants/Payoffs
- Plant: [What's set up]
- Payoff: [What's resolved]
```

---

## Scene Outline Template

```markdown
## Scene [Chapter.Scene]: [TITLE]

### Core Structure
- **POV:** [Character]
- **Goal:** [What POV wants]
- **Conflict:** [What opposes]
- **Stakes:** [What's at risk]
- **Turn:** [How scene ends differently than it began]

### Setting
- **Location:** [Where]
- **Time:** [When - time of day, relation to previous scene]
- **Atmosphere:** [Mood, tone, sensory details to emphasize]

### Characters Present
| Character | Role in Scene | Emotional State |
|-----------|--------------|-----------------|
| [Name] | POV / Pursuer / etc. | [Emotion] |
| [Name] | [Role] | [Emotion] |

### Beat-by-Beat
1. [Opening beat - how scene begins]
2. [Rising action beat]
3. [Complication beat]
4. [Climax beat - scene's peak tension]
5. [Resolution/Turn beat - how scene ends]

### Key Dialogue
```
[Character]: "[Important line - paraphrase or actual]"
[Character]: "[Response]"
```

### Craft Elements
- **Foreshadowing:** [What's planted]
- **Subtext:** [What's under the surface]
- **World-building:** [What's revealed about world]
- **Character Development:** [How character changes/reveals self]

### Transition
**Exit:** [How scene ends]
**Into:** [How it connects to next scene]
```

---

## Foreshadowing Tracker Template

```markdown
# Foreshadowing Tracker — [BOOK TITLE]

## Thread 1: [Name/Description]
**Type:** [Object/Dialogue/Character/Thematic]
**Final Payoff:** [What this ultimately enables]

| Stage | Chapter | Scene | How |
|-------|---------|-------|-----|
| Plant | Ch [X] | [Scene] | [How it's introduced] |
| Water | Ch [X] | [Scene] | [How it's reinforced] |
| Water | Ch [X] | [Scene] | [Additional reinforcement] |
| Payoff | Ch [X] | [Scene] | [How it resolves] |

---

## Thread 2: [Name/Description]
[Same structure]

---

## Mercy Engine Tracking

### Mercy 1: [Description]
- **Recipient:** [Who]
- **Act:** [What]
- **Plant:** Ch [X] — [Scene/moment]
- **Cost Shown:** Ch [X] — [How cost is demonstrated]
- **Payoff:** Ch [X] — [How it returns]

### Mercy 2: [Description]
[Same structure]

[Continue for all mercies]
```

---

## Character Thread Template

```markdown
# Character Threads — [BOOK TITLE]

## [CHARACTER NAME]

### Arc Summary
**Starts as:** [Beginning state]
**Becomes:** [End state]
**Key Change:** [The transformation]

### Chapter-by-Chapter Presence

| Chapter | Role | Emotional State | Key Moment |
|---------|------|-----------------|------------|
| 1 | [Primary/Supporting/Absent] | [State] | [What happens with them] |
| 2 | [Primary/Supporting/Absent] | [State] | [What happens with them] |
[Continue for all chapters]

### Relationship Arcs
- **With [Character]:** [How relationship evolves]
- **With [Character]:** [How relationship evolves]

### Key Scenes
1. Ch [X], Scene [Y] — [Description of pivotal moment]
2. Ch [X], Scene [Y] — [Description of pivotal moment]
```

---

## Forge Point Chapter Template

Forge Point chapters require special attention:

```markdown
# Chapter [X]: [TITLE] — FORGE POINT [#]

## Forge Point Requirements
- [ ] All three strands in crisis
- [ ] Clear sacrifice made
- [ ] Irreversible change
- [ ] No retreat possible

## The Three Crises

### Quest Crisis
**The Problem:** [What threatens the external quest]
**Why It Can't Be Ignored:** [Stakes]

### Fire Crisis  
**The Problem:** [What threatens internally]
**Why It Can't Be Ignored:** [Stakes]

### Constellation Crisis
**The Problem:** [What threatens relationships]
**Why It Can't Be Ignored:** [Stakes]

## The Sacrifice
**What is Lost:** [What's sacrificed]
**Why This Strand:** [Why this one, not others]
**How It's Lost:** [The moment]

## The Turn
**Before:** [State before Forge Point]
**After:** [State after Forge Point]
**Why No Return:** [What makes this irreversible]

[Standard chapter structure continues below]
```

---

## Chapter Summary Template

For quick reference document:

```markdown
# Chapter Summaries — [BOOK TITLE]

| Ch | Title | Beats | POV | Strand | One-Line Summary |
|----|-------|-------|-----|--------|------------------|
| 1 | [Title] | 1-2 | [Name] | C | [One sentence] |
| 2 | [Title] | 3-4 | [Name] | F | [One sentence] |
| 3 | [Title] | 5-6 | [Name] | Q→⚒ | [One sentence] |
[Continue for all chapters]
```
