# Document Templates

Templates for generating all planning documents from collected answers.

---

## Template 1: Crucible Thesis

```markdown
# Crucible Thesis: {title}

## The Forging Question

> Can {protagonist_name} become {what_they_must_become} without becoming {what_dark_mirror_represents}?

---

## The Three Strands

### The Burden (Quest Strand)
**Nature:** {burden_type}
**Description:** {burden_description}

The external weight that must be carried toward {resolution_type}.

### The Fire (Fire Strand)
**Nature:** {fire_type}
**Description:** {fire_description}

The internal power that threatens to {danger_if_unmastered}.

### The Core Bond (Constellation Strand)
**Bond Type:** {bond_type}
**With:** {bond_character}
**Nature:** {bond_description}

The anchor that cannot break.

---

## The Dark Mirror

**Antagonist:** {antagonist_name}
**Connection:** {dark_mirror_connection}
**Their Truth:** "{antagonist_philosophy}"

What the protagonist could become if the forging fails.

---

## The Theme

> {theme_statement}

---

## The Surrender

At the Apex, the protagonist must willingly surrender: **{surrender_type}**

{surrender_description}

---

## The Blade's Purpose

After the forging, the protagonist becomes: **{blade_purpose}**

{blade_description}

---

## Full Narrative Arc

{full_arc_summary}
```

---

## Template 2: Quest Strand Map

```markdown
# Quest Strand Map: {title}

## The Burden

**What:** {burden_description}
**Origin:** {burden_origin}
**Why This Protagonist:** {why_this_protagonist}

---

## Quest Arc by Movement

### Movement I — Discovery
{movement_1_quest}

### Movement II — First Attempt
{movement_2_quest}

### Movement III — Expansion
{movement_3_quest}

### Movement IV — Convergence
{movement_4_quest}

### Movement V — Resolution
{movement_5_quest}

---

## The Antagonist's Stake

**Why They Oppose:** {antagonist_stake}
**What They Want:** {antagonist_quest_goal}

---

## The Escalation

**Personal to Global:** {escalation_description}

---

## The Impossible Element

**What Makes It Hopeless:** {impossible_requirement}

---

## The Resolution

**How the Burden Ends:** {resolution_method}
**The World After:** {world_state_after}

---

## Key Quest Beats

| Beat | Movement | Quest State |
|------|----------|-------------|
| 4 | I | Burden Chosen |
| 9 | II | First Test |
| 12 | II | The Shaping Blow (failure) |
| 16 | III | Burdens Distributed |
| 19 | III | Institution Corrupted |
| 22 | III | Thread Returns |
| 24 | IV | Gathering Storm |
| 29 | V | War of All Fronts |
| 34 | V | Burden's End |
```

---

## Template 3: Fire Strand Map

```markdown
# Fire Strand Map: {title}

## The Fire

**Nature:** {fire_type}
**Source:** {fire_source}
**Manifestation:** {fire_manifestation}

---

## The Danger

**If Unmastered:** {danger_description}
**Previous Wielders:** {previous_wielders}

---

## The Cost

**Each Use Costs:** {cost_of_use}
**Cumulative Effect:** {cumulative_effect}

---

## Fire Arc by Movement

### Movement I — Awakening
{movement_1_fire}

### Movement II — Instability
**Control Level:** Partial/Unreliable
{movement_2_fire}

### Movement III — Hardening
**The Line Crossed:** {hardening_line}
{movement_3_fire}

### Movement IV — Mastery
**How Achieved:** {mastery_method}
{movement_4_fire}

### Movement V — Surrender/Transformation
{movement_5_fire}

---

## Mastery Requirements

**What Mastery Requires:** {mastery_requirements}
**The Insight:** {mastery_insight}

---

## The Dark Mirror Connection

**Antagonist's Fire:** {antagonist_fire}
**The Parallel:** {fire_parallel}
**The Divergence:** {fire_divergence}

---

## Key Fire Beats

| Beat | Movement | Fire State |
|------|----------|------------|
| 3 | I | First Spark |
| 7 | II | Wandering Flame |
| 8 | II | Rival Flame |
| 17 | III | Hardening Begins |
| 23 | IV | Fire Mastered |
| 26 | IV | Dark Mirror's Offer |
| 32 | V | Confrontation Beyond |
| 33 | V | Willed Surrender |
```

---

## Template 4: Constellation Strand Map

```markdown
# Constellation Strand Map: {title}

## Core Constellation

### The Protagonist
**Name:** {protagonist_name}
**Core Bond With:** {core_bond_character}

### The Core Bond
**Type:** {core_bond_type}
**Nature:** {core_bond_description}
**Why It Cannot Break:** {why_unbreakable}

### The Faithful
**Name:** {faithful_name}
**Role:** {faithful_role}
**What They Provide:** {faithful_provides}

---

## Constellation Arc by Movement

### Movement I — Formation
{movement_1_constellation}

### Movement II — Testing
**First Strain:** {first_strain}
{movement_2_constellation}

### Movement III — Expansion & Fracture
**New Allies:** {new_allies}
**The Betrayal/Strain:** {betrayal_description}
{movement_3_constellation}

### Movement IV — Sacrifice & Anchor
**Who Dies:** {sacrifice_character}
**The Bond That Saves:** {saving_bond}
{movement_4_constellation}

### Movement V — Resolution
{movement_5_constellation}

### Coda — New Constellation
{coda_constellation}

---

## The Sacrifice

**Who:** {sacrifice_character}
**How They Die:** {sacrifice_method}
**What They Model:** {sacrifice_meaning}

---

## The Bond That Saves

**Which Bond:** {saving_bond}
**When It's Tested:** {bond_test}
**How It Anchors:** {anchor_mechanism}

---

## Key Constellation Beats

| Beat | Movement | Constellation State |
|------|----------|---------------------|
| 1 | I | The Unlit Forge |
| 5 | I | First Constellation |
| 10 | II | Constellation Strained |
| 15 | III | Constellation Expands |
| 18 | III | Beloved Endangered |
| 25 | IV | Constellation's Sacrifice |
| 27 | IV | Bond That Holds |
| 35 | Coda | Cost Revealed |
```

---

## Template 5: Forge Point Blueprint

```markdown
# Forge Point {number}: {name}

**Placement:** End of Movement {movement} (~{percentage}%)

---

## The Three Crises

### Quest Crisis
{quest_crisis}

**Why It Cannot Wait:** {quest_urgency}

### Fire Crisis
{fire_crisis}

**Why It Cannot Wait:** {fire_urgency}

### Constellation Crisis
{constellation_crisis}

**Why It Cannot Wait:** {constellation_urgency}

---

## The Impossible Choice

The protagonist cannot resolve all three. They must choose.

**Option A:** Save the Quest at cost of {cost_a}
**Option B:** Save the Fire at cost of {cost_b}
**Option C:** Save the Constellation at cost of {cost_c}

---

## The Sacrifice

**What Is Sacrificed:** {sacrifice_type}
**Specific Loss:** {sacrifice_specific}
**Why It Matters:** {sacrifice_weight}

---

## How This Shapes the Protagonist

{shaping_effect}

---

## The Aftermath

{aftermath_description}

**What This Propels:** {what_comes_next}
```

---

## Template 6: Dark Mirror Profile

```markdown
# Dark Mirror Profile: {antagonist_name}

## Identity

**Name:** {antagonist_name}
**Title/Role:** {antagonist_role}
**Nature:** {antagonist_nature}

---

## The Parallel Path

| Element | Protagonist | Antagonist |
|---------|-------------|------------|
| Origin | {protag_origin} | {antag_origin} |
| Power/Gift | {protag_power} | {antag_power} |
| Defining Choice | {protag_choice} | {antag_choice} |
| What They Lost | {protag_lost} | {antag_lost} |
| What They Gained | {protag_gained} | {antag_gained} |

---

## The Divergence Point

**The Moment:** {divergence_moment}
**Protagonist Chose:** {protag_divergence_choice}
**Antagonist Chose:** {antag_divergence_choice}
**Why It Matters:** {divergence_significance}

---

## The Antagonist's Truth

> "{antagonist_philosophy}"

**Why It's Compelling:** {truth_compelling}
**Why It's Wrong:** {truth_flaw}
**How Protagonist Answers:** {protagonist_answer}

---

## The Dark Mirror's Offer (Beat 26)

**The Offer:** {the_offer}
**Why It's Tempting:** {why_tempting}
**The Hidden Cost:** {hidden_cost}
**Why Protagonist Refuses:** {refusal_reason}

---

## The Defeat

**How They're Defeated:** {defeat_method}
**Role of Mercy:** {mercy_role}
**The Antagonist's End:** {antagonist_end}

---

## Scenes

**First Appearance:** {first_appearance}
**Key Confrontations:** {key_confrontations}
**The Offer Scene:** {offer_scene}
**Final Confrontation:** {final_confrontation}
```

---

## Template 7: Constellation Bible

```markdown
# Constellation Bible: {title}

## The Protagonist

**Name:** {protagonist_name}

### Before the Forging
**Unlit State:** {unlit_state}
**The Wound:** {wound}
**The Lie:** {the_lie}

### After the Forging
**Forged State:** {forged_state}
**The Truth:** {the_truth}
**The Blade's Purpose:** {blade_purpose}

---

## Core Constellation

### {core_bond_name} — The Core Bond
**Role:** {core_bond_type}
**Relationship:** {core_bond_relationship}
**Arc:** {core_bond_arc}
**Key Scenes:** {core_bond_scenes}

### {faithful_name} — The Faithful
**Role:** Unwavering loyalty
**Relationship:** {faithful_relationship}
**Arc:** {faithful_arc}
**Key Scenes:** {faithful_scenes}

### {mentor_name} — The Catalyst/Mentor
**Role:** Guide and revealer
**Relationship:** {mentor_relationship}
**Arc:** {mentor_arc}
**Key Scenes:** {mentor_scenes}

### {sacrifice_name} — The Sacrifice
**Role:** Models the surrender
**Relationship:** {sacrifice_relationship}
**Arc:** {sacrifice_arc}
**Death Scene:** {sacrifice_death}

### {rival_name} — The Rival Flame
**Role:** Comparison and illumination
**Relationship:** {rival_relationship}
**Arc:** {rival_arc}
**Key Scenes:** {rival_scenes}

---

## Extended Constellation

### {ally_1_name}
**Role:** {ally_1_role}
**Arc:** {ally_1_arc}

### {ally_2_name}
**Role:** {ally_2_role}
**Arc:** {ally_2_arc}

### {ally_3_name}
**Role:** {ally_3_role}
**Arc:** {ally_3_arc}

---

## Constellation Dynamics

**The Bond That Cannot Break:** {unbreakable_bond}
**The Bond That Will Break:** {breaking_bond}
**The Sacrifice:** {sacrifice_summary}
**The Unexpected Agent:** {unexpected_agent}
```

---

## Template 8: Mercy Ledger

```markdown
# Mercy Ledger: {title}

## Mercy Engine Overview

The protagonist shows mercy four times. Each costs something. Each pays off unexpectedly.

---

## Mercy 1: The Seed

**Movement:** II
**Recipient:** {mercy_1_recipient}
**Context:** {mercy_1_context}

**The Merciful Act:** {mercy_1_act}

**Immediate Cost:**
- {mercy_1_cost}
- Companion reaction: {mercy_1_reaction}

**Later Payoff (Movement IV):**
- {mercy_1_payoff}

---

## Mercy 2: The Investment

**Movement:** III
**Recipient:** {mercy_2_recipient}
**Context:** {mercy_2_context}

**The Merciful Act:** {mercy_2_act}

**Immediate Cost:**
- {mercy_2_cost}
- Companion reaction: {mercy_2_reaction}

**Later Payoff (Movement V):**
- {mercy_2_payoff}

---

## Mercy 3: The Risk

**Movement:** IV
**Recipient:** {mercy_3_recipient}
**Context:** {mercy_3_context}

**The Merciful Act:** {mercy_3_act}

**Immediate Cost:**
- {mercy_3_cost}
- Companion reaction: {mercy_3_reaction}

**Later Payoff (Movement V):**
- {mercy_3_payoff}

---

## Mercy 4: The Impossible Gift

**Movement:** V
**Recipient:** {mercy_4_recipient}
**Context:** {mercy_4_context}

**The Merciful Act:** {mercy_4_act}

**Immediate Cost:**
- {mercy_4_cost}
- Appears to guarantee: {mercy_4_apparent_doom}

**Later Payoff (Beat 31):**
- {mercy_4_payoff}

---

## The Unexpected Agents (Beat 31)

At the moment of three failures, those who received mercy act:

{unexpected_agents_description}

**How They Enable Victory:**
1. {agent_action_1}
2. {agent_action_2}
3. {agent_action_3}
```

---

## Template 9: World Forge

```markdown
# World Forge: {title}

## The World's Wound

**The Cosmic Problem:** {cosmic_problem}
**What Caused It:** {wound_cause}
**How It Manifests:** {wound_manifestation}

---

## Power System

### Source
**Type:** {power_source_type}
**Description:** {power_source_description}

### Limitations
{limitation_1}
{limitation_2}
{limitation_3}

### Cost of Use
{power_cost}

### Previous Wielders
{previous_wielders}

---

## World-Protagonist Mirror

| Protagonist State | World Reflection |
|-------------------|------------------|
| Before Ignition | {world_before} |
| Fire Uncontrolled | {world_uncontrolled} |
| Hardening | {world_hardening} |
| Fire Mastered | {world_mastered} |
| After Surrender | {world_after} |

---

## Key Locations

### {location_1_name} — The Ordinary World
{location_1_description}
**Sensory Details:** {location_1_sensory}
**Symbolic Meaning:** {location_1_symbol}

### {location_2_name} — The Threshold
{location_2_description}
**Sensory Details:** {location_2_sensory}
**Symbolic Meaning:** {location_2_symbol}

### {location_3_name} — The Sanctuary
{location_3_description}
**Sensory Details:** {location_3_sensory}
**Symbolic Meaning:** {location_3_symbol}

### {location_4_name} — The Dark Heart
{location_4_description}
**Sensory Details:** {location_4_sensory}
**Symbolic Meaning:** {location_4_symbol}

---

## Cultures

{cultures_description}

---

## History

**Relevant Past:** {relevant_history}
**How It Affects Present:** {history_effect}

---

## Rules Summary

### Magic Can:
{magic_can}

### Magic Cannot:
{magic_cannot}

### Magic Costs:
{magic_costs}

---

## Timeline

| Event | Timing | Notes |
|-------|--------|-------|
| {timeline_events} |
```

---

## Template 10: Crucible Summary Card

```markdown
# Crucible Summary: {title}

## The Forging Question
> Can {protagonist} become {must_become} without becoming {dark_mirror}?

## Three Strands
- **Quest:** {quest_summary}
- **Fire:** {fire_summary}
- **Constellation:** {constellation_summary}

## Four Forge Points
1. **Ignition:** {fp0_summary}
2. **First Crucible:** {fp1_summary}
3. **Second Crucible:** {fp2_summary}
4. **Third Crucible:** {fp3_summary}

## The Apex
{apex_summary}

## The Mercy Engine
1. {mercy_1_summary}
2. {mercy_2_summary}
3. {mercy_3_summary}
4. {mercy_4_summary}

## Theme
> {theme}

## The Blade's Purpose
{blade_purpose}
```
