# Forge Point Rules

Mechanics for designing strand convergence crises.

## Core Principle

At each Forge Point, ALL THREE STRANDS must be in **simultaneous crisis**. The protagonist cannot resolve all three—they must choose which strand to sacrifice.

## The Five Forge Points

### FP0: Ignition Forge (End of Movement I, ~10%)

**Purpose:** Light the forge. Destroy the ordinary world forever.

**Required Elements:**
- Quest: The burden becomes real and inescapable
- Fire: The power reveals its dangerous nature
- Constellation: Home/safety is destroyed; bonds form under pressure

**What Burns:** The protagonist's ordinary life. There is no going back.

**Design Questions:**
- What specific event destroys the possibility of return?
- How does the Fire manifest in a way that cannot be hidden?
- Who commits to following despite the danger?

---

### FP1: First Crucible (End of Movement II, ~30%)

**Purpose:** First impossible choice. Shape through failure.

**Required Elements:**
- Quest: A critical obstacle threatens to end the mission
- Fire: Control slips; power overwhelms or fails at worst moment
- Constellation: A companion is alienated, endangered, or lost

**The Sacrifice:** Progress in one strand is lost to save the others.

**Design Questions:**
- What makes this obstacle feel insurmountable?
- How does the protagonist's lack of mastery cause harm?
- Which relationship pays the price for this crisis?

**Common Patterns:**
- Save the mission OR save the companion
- Use dangerous power OR fail the quest
- Maintain a bond OR achieve the objective

---

### FP2: Second Crucible (End of Movement III, ~55%)

**Purpose:** Test the hardened protagonist. Break trust.

**Required Elements:**
- Quest: A major setback; strategy fails or is revealed as flawed
- Fire: The hardening threatens to become permanent corruption
- Constellation: Trust is broken through betrayal, secrets revealed, or impossible demands

**The Sacrifice:** Usually higher stakes than FP1. Something important is lost permanently.

**Design Questions:**
- How has the protagonist's ruthlessness created this crisis?
- What line have they crossed that strains relationships?
- What betrayal (by or against the protagonist) occurs?

**Common Patterns:**
- The protagonist's hardening alienates an ally
- A trusted figure is revealed as compromised
- Doing what's "necessary" costs something irreplaceable

---

### FP3: Third Crucible (Late Movement IV, ~75%)

**Purpose:** The sacrifice that enables the finale. Someone must die.

**Required Elements:**
- Quest: All seems lost; defeat appears certain
- Fire: Full power is required but threatens final corruption
- Constellation: Someone must die for others to continue

**The Sacrifice:** A beloved character dies heroically, modeling the surrender the protagonist must make.

**Design Questions:**
- Who dies, and why must it be them?
- How does their death enable the final push?
- What does their sacrifice teach the protagonist about their own surrender?

**Common Patterns:**
- The mentor completes their arc through death
- The faithful companion saves the protagonist one final time
- A redeemed enemy proves their transformation through sacrifice

---

### Apex: Willed Surrender (Movement V, ~85%)

**Purpose:** The protagonist is unmade and remade. Victory through surrender.

**Required Elements:**
- Quest: The mission can only complete through sacrifice
- Fire: The power must be surrendered or transformed forever
- Constellation: The protagonist must choose others over self

**The Surrender:** Something ESSENTIAL—not merely costly—given up by choice.

**Design Questions:**
- What does the protagonist surrender? (Not life—something that defines them)
- Why must it be willing? What happens if forced?
- How does the surrender enable victory?

**What Can Be Surrendered:**
- The Fire itself (their power)
- Their certainty/beliefs
- Their vengeance/justice
- Their role/destiny
- Their memory/identity
- Their connection to someone they love

**What Cannot Be Surrendered:**
- Something they were going to lose anyway
- Something they don't truly value
- Their life (too easy; not a transformation)

---

## Sacrifice Mechanics

At each Forge Point, one strand is sacrificed:

| Strand Sacrificed | What It Looks Like |
|-------------------|-------------------|
| **Quest** | Delay, setback, loss of progress, failed objective |
| **Fire** | Loss of control, corruption risk, damage from power use |
| **Constellation** | Strained bond, lost ally, broken trust |

**Escalation Pattern:**
- FP1: Minor sacrifice (delay, strain)
- FP2: Significant sacrifice (real loss, broken bond)
- FP3: Major sacrifice (permanent loss, death)
- Apex: Essential sacrifice (identity-level)

---

## Designing Effective Forge Points

### 1. Ensure True Simultaneity

Bad: "The quest is in crisis, and also the protagonist is worried about their power."
Good: "The quest requires using power that will corrupt, while an ally is in danger."

All three strands must **demand action at the same moment**.

### 2. Make the Choice Genuinely Impossible

Bad: "The protagonist faces a difficult decision."
Good: "The protagonist can save ONE—the mission, their control, or their friend."

The reader should understand why all three cannot be saved.

### 3. Ensure Real Consequences

The sacrifice must **actually happen**. No last-minute saves, no "it was all a test."

### 4. Build on Previous Choices

Each Forge Point's crisis should emerge from earlier decisions:
- FP1 crisis comes from choices in Movement I
- FP2 crisis comes from FP1's sacrifice
- FP3 crisis comes from the hardening in Movement III
- Apex comes from everything before

### 5. Shape the Protagonist

Each sacrifice changes who the protagonist is:
- FP1: Teaches them the stakes are real
- FP2: Tests whether they can maintain humanity
- FP3: Shows them what sacrifice looks like
- Apex: Completes the forging

---

## Common Mistakes

**Mistake:** Making Forge Points sequential rather than simultaneous.
**Fix:** Design all three crises to peak at the exact same moment.

**Mistake:** Letting the protagonist avoid the sacrifice.
**Fix:** The sacrifice is required. If avoided, the story hasn't reached a true Forge Point.

**Mistake:** Sacrificing the same strand repeatedly.
**Fix:** Vary which strand pays the price across Forge Points.

**Mistake:** Making the Apex about death rather than transformation.
**Fix:** The protagonist survives but is fundamentally changed.

---

## Forge Point Checklist

For each Forge Point, verify:

- [ ] Quest strand is in genuine crisis
- [ ] Fire strand is in genuine crisis
- [ ] Constellation strand is in genuine crisis
- [ ] All three crises demand action simultaneously
- [ ] The protagonist cannot resolve all three
- [ ] The sacrifice is real and permanent
- [ ] The consequence shapes the protagonist
- [ ] The crisis emerged from earlier choices
