# Anti-Hallucination Protocol

How to write faithfully from an outline without inventing story elements.

## The Danger

AI language models can:
- Invent character names not in the outline
- Create plot events that weren't planned
- Add world details that contradict established rules
- Introduce themes or symbolism not intended
- Drift from the author's vision

**This is catastrophic for novel writing.** The author has spent hours planning. Hallucinations waste that work and create continuity nightmares.

## The Three Laws

### Law 1: If It's Not in the Outline, Don't Write It

**The outline is the contract.** Every scene goal, conflict, turn, and key moment must come from the outline.

**Allowed:**
- Expanding outline elements into prose
- Adding sensory details to described scenes
- Writing dialogue that achieves outlined goals
- Creating transitions between outlined moments

**Not Allowed:**
- Adding scenes not in the outline
- Creating characters not established
- Inventing backstory not planned
- Adding plot twists not outlined

### Law 2: If You're Unsure, Ask

**Uncertainty = Ask the author.**

```
I need clarification before continuing:

The outline mentions Sonny enters the tavern, but doesn't specify:
- The tavern's name
- Who else is present
- Time of day

Options:
A) You provide these details
B) I invent minimal details (will flag for review)
C) I write around the unknowns
```

### Law 3: Flag What You Invent

**Some invention is necessary.** You can't outline every minor character's name or every room's description.

**The rule:** All non-trivial inventions must be flagged.

```
[INVENTED: The innkeeper's name "Wen Dao" — not in outline]
[INVENTED: The specific cultivation technique "Iron River Palm"]
[INVENTED: The appearance of the eastern gate]
```

**What counts as non-trivial:**
- Named characters (even minor)
- Named locations
- Specific power/magic details
- Dates or time specifics
- Family relationships
- Historical events
- Organization names

**What doesn't need flagging:**
- Generic descriptions ("the old man behind the counter")
- Weather/time of day (unless plot-relevant)
- Basic sensory details
- Dialogue filler ("Hello," "Thank you")

## Verification Checkpoints

### Before Writing a Scene

```
PRE-WRITE VERIFICATION:

□ Current scene outline loaded?
□ Scene goal clearly stated in outline?
□ Scene conflict clearly stated?
□ Scene turn clearly stated?
□ Key moments listed?
□ Any plants/payoffs for this scene noted?

If any checkbox is unclear → ASK before writing.
```

### During Writing

**Stop and verify if you find yourself:**
- Naming a character not in your loaded context
- Describing a location with specific details not provided
- Writing a conversation about topics not in the scene goal
- Adding conflict not specified in the outline
- Introducing information the POV character shouldn't have

### After Writing a Scene

```
POST-WRITE VERIFICATION:

□ Scene goal achieved in prose?
□ Scene conflict present?
□ Scene turn executed?
□ All key moments included?
□ All required plants planted?
□ All required payoffs paid?
□ Any [INVENTED] flags needed?
□ Character states consistent with story bible?
□ Timeline consistent?
```

### Before Saving a Chapter

```
CHAPTER VERIFICATION:

□ All scenes from outline written?
□ No scenes added that weren't outlined?
□ Chapter turn achieved?
□ Ending hook present?
□ All [INVENTED] items flagged?
□ Story bible updated?
□ Word count within acceptable range?
□ Ready for author review?
```

## Common Hallucination Patterns

### Pattern 1: The Unplanned Character

**Danger:** Writing a scene and suddenly a "old friend" appears who was never established.

**Prevention:** Before introducing ANY named character:
- Is this character in the constellation bible?
- Is this character mentioned in the outline?
- If no to both → ASK or flag as [INVENTED]

### Pattern 2: The Convenient Information

**Danger:** A character suddenly knows something they shouldn't.

**Prevention:** Check story bible:
- What does this character know at this point?
- When did they learn it?
- Was that knowledge established on-page?

### Pattern 3: The Drift

**Danger:** A conversation starts on-topic and gradually drifts into unplanned territory.

**Prevention:** 
- Keep scene goal visible while writing
- After each dialogue exchange, verify it serves the goal
- If characters "want" to discuss something unplanned → stop and ask

### Pattern 4: The Backstory Expansion

**Danger:** Elaborating on a character's past with invented details.

**Prevention:**
- Only include backstory explicitly in constellation bible
- If you need more backstory → ask author
- Mark any expansion as [INVENTED]

### Pattern 5: The World-Building Addition

**Danger:** Adding magic rules, geography, or history not established.

**Prevention:**
- Reference world forge before adding details
- If detail isn't there, ask or flag
- Be especially careful with: power systems, politics, geography

## The Clarification Request Template

When you need to ask the author:

```
**Clarification Needed — [Scene X.Y]**

The outline specifies: [quote relevant outline]

But I need to know:
1. [Specific question]
2. [Specific question]

Options:
A) You provide these details now
B) I write around it (may feel vague)
C) I invent and flag (you review later)

Which approach?
```

## The Invention Flag Format

When you must invent:

```
[INVENTED: Brief description of what was invented]
```

**Examples:**
```
[INVENTED: Minor character "the fishmonger" given name "Old Chen"]
[INVENTED: The sect's training hall described as having red pillars]
[INVENTED: Sonny's childhood hiding spot described as behind the tannery]
```

## Reviewing Inventions

At end of each chapter:

```
**Invented Details This Chapter:**

1. [INVENTED: Old Chen the fishmonger] — minor character name
2. [INVENTED: Red pillars in training hall] — visual detail
3. [INVENTED: Hiding spot behind tannery] — location detail

Author actions:
A) Approve all (added to story bible)
B) Reject/revise specific items
C) Review in context
```

**Approved inventions** become established facts and enter the story bible.
**Rejected inventions** must be revised in the prose.

## The Ultimate Test

Before submitting any scene for approval, ask:

> "If the author read this scene against their outline, would they say 'yes, this is what I planned' or would they say 'where did THIS come from'?"

If the answer is the latter for ANY element → flag it, ask about it, or remove it.

## Summary

1. **Outline is law** — Don't add what isn't planned
2. **Uncertainty = ask** — Never guess on important details
3. **Flag inventions** — Author approves everything non-trivial
4. **Verify constantly** — Check before, during, and after writing
5. **Track in story bible** — Approved inventions become canon

## Machine-Verifiable Markers

The following markers are validated automatically by the PreToolUse hook when writing draft files.

### [INVENTED: description]

Use this marker to flag any invented detail for author review.

**Format:** `[INVENTED: Brief description of what was invented]`

**Examples:**
```
[INVENTED: Minor character "the fishmonger" given name "Old Chen"]
[INVENTED: The sect's training hall described as having red pillars]
[INVENTED: Sonny's childhood hiding spot described as behind the tannery]
```

**When to use:**
- Named characters not in the outline or story bible
- Named locations not in the world forge
- Specific details about powers/magic not established
- Dates, times, or historical events not documented
- Organization or group names created on the fly

### [VERIFY]

Use this marker for uncertain details that need verification against source documents.

**Format:** `[VERIFY]` placed after the uncertain detail

**Example:**
```
The meeting happened three days after the festival [VERIFY] in the eastern courtyard.
```

**When to use:**
- Details you believe exist in source docs but couldn't verify
- Timeline references you're unsure about
- Character knowledge that might be anachronistic
- Location details that might contradict world forge

### Automated Validation

A PreToolUse hook (`scripts/validate_before_write.py`) scans draft files for potentially invented names or locations. When it detects patterns like:
- `named [CapitalizedName]`
- `called [CapitalizedName]`
- `the [Name] Inn/Tavern/Tower/etc.`

...that lack nearby `[INVENTED` or `[VERIFY` markers, it shows a soft warning reminder.

**This is a reminder system, not a blocker.** The goal is to catch accidental inventions before they become canon. The write always proceeds - the warning just prompts you to review.

### Story Bible Integration

When you use `[INVENTED: description]` markers:
1. The detail is flagged in the story bible as `invented_details`
2. Author reviews during bi-chapter review or on request
3. Approved inventions become `established_facts` with `was_invented: true`
4. Rejected inventions must be revised in the prose

Use `scripts/update_story_bible.py --invented` to record inventions:
```bash
python scripts/update_story_bible.py <project> --invented <chapter> <scene> "description"
```
