# Bi-Chapter Review System

**CRITICAL:** Every 2 chapters, a comprehensive review MUST be triggered to catch issues early.

## Chapter Tracking

After completing each chapter, use `save_draft.py` to mark it complete and sync state:

```bash
python scripts/save_draft.py "./draft-project" --complete-chapter X summary.txt
```

This command:
1. Updates the story bible with chapter completion and summary
2. Syncs progress to draft-state.json (via shared `sync_draft_state()`)
3. Checks if bi-chapter review is needed

The draft state file (`.crucible/state/draft-state.json`) tracks:
```json
{
  "chapters_complete": 6,
  "last_review_at_chapter": 4,
  "review_pending": true,
  "current_chapter": 7,
  "current_scene": 1
}
```

## Review Trigger Logic

**After completing each chapter, check:**

```
chapters_since_last_review = chapters_complete - last_review_at_chapter

IF chapters_since_last_review >= 2:
    TRIGGER bi-chapter review
    UPDATE last_review_at_chapter = chapters_complete
```

## Triggering the Review

When a bi-chapter review is needed, present:

```
═══════════════════════════════════════
BI-CHAPTER REVIEW REQUIRED
═══════════════════════════════════════

You've completed chapters [X] and [Y].
Time for a quality check before continuing.

This review runs 5 specialized agents:
• voice-checker — Style consistency
• continuity-checker — Plot/character continuity
• outline-checker — Outline fidelity
• timeline-checker — Chronological consistency
• prose-checker — Craft-level feedback
```

Use AskUserQuestion:
```json
{
  "questions": [
    {
      "header": "Review",
      "question": "How would you like to proceed with the bi-chapter review?",
      "options": [
        {"label": "Run full review (Recommended)", "description": "Run all 5 review agents now"},
        {"label": "Skip for now", "description": "Continue writing without review (not recommended)"},
        {"label": "Selective review", "description": "Choose which agents to run"}
      ],
      "multiSelect": false
    }
  ]
}
```

## Invoking Review Agents

**IMPORTANT:** To invoke the review agents, use the Task tool with subagent_type for each agent:

```
Task(subagent_type="crucible-suite:voice-checker", prompt="Review chapters X-Y for voice consistency...")
Task(subagent_type="crucible-suite:continuity-checker", prompt="Review chapters X-Y for continuity...")
Task(subagent_type="crucible-suite:outline-checker", prompt="Review chapters X-Y for outline adherence...")
Task(subagent_type="crucible-suite:timeline-checker", prompt="Review chapters X-Y for timeline consistency...")
Task(subagent_type="crucible-suite:prose-checker", prompt="Review chapters X-Y for prose quality...")
```

Launch all 5 agents in parallel for efficiency. Each agent will return a structured report.

## After Review

After all agents complete:

1. **Compile findings** from all 5 reports
2. **Categorize by severity** (Critical/Warning/Suggestion)
3. **Present consolidated report** to author
4. **Update state** with `last_review_at_chapter`
5. **Address critical issues** before continuing

```
═══════════════════════════════════════
BI-CHAPTER REVIEW COMPLETE
Chapters: [X-Y]
═══════════════════════════════════════

CRITICAL ISSUES (Must Fix Before Continuing)
─────────────────────────────────────
[Issues from all agents that require immediate attention]

WARNINGS (Should Address Soon)
─────────────────────────────────────
[Issues to fix during this session or next]

SUGGESTIONS (Consider Later)
─────────────────────────────────────
[Nice-to-haves for polishing]

OVERALL SCORES
─────────────────────────────────────
Voice Consistency: X/10
Continuity: X/10
Outline Fidelity: X/10
Timeline: X/10
Prose Quality: X/10
```

Use AskUserQuestion:
```json
{
  "questions": [
    {
      "header": "Review Action",
      "question": "How would you like to proceed after this review?",
      "options": [
        {"label": "Address issues now", "description": "Fix critical issues before continuing"},
        {"label": "Continue writing", "description": "Note issues and continue (will return later)"},
        {"label": "Show detailed reports", "description": "View full reports from each agent"}
      ],
      "multiSelect": false
    }
  ]
}
```
