# Prose Craft Guide

Genre conventions and writing techniques for Crucible novels.

## Genre: Cultivation Fantasy

### Core Conventions

**Power Progression:**
- Characters advance through defined stages
- Training has visible, earned results
- Power differences create natural tension
- Setbacks are part of growth

**Hierarchy and Respect:**
- Master-student relationships are sacred
- Age often (but not always) equals power
- Honorifics and formal address
- Casual disrespect has consequences

**Internal Cultivation:**
- Qi/energy as tangible presence
- Meditation and body refinement
- Breakthroughs as pivotal moments
- Cost of power (physical, spiritual)

**The World Responds:**
- Nature reacts to cultivation
- Power can be sensed
- Heavenly tribulations
- Resources are contested

### Writing Cultivation Scenes

**Training scenes:**
```
Structure:
1. The challenge (technique to learn)
2. Initial failure (establishes difficulty)
3. Insight (understanding clicks)
4. Attempt (application)
5. Result (success, failure, or partial)

Include:
- Physical sensation
- Internal energy flow
- Environmental response
- Emotional stakes
```

**Breakthrough scenes:**
```
Structure:
1. Build-up (at the edge)
2. Trigger (what pushes them over)
3. The crossing (visceral experience)
4. Integration (new reality)
5. Consequence (what changes)

Include:
- All senses engaged
- Before/after contrast
- Cost made visible
- Others' reactions
```

**Combat scenes:**
```
Structure:
1. Stakes established
2. Engagement
3. Exchange of techniques
4. Turning point
5. Resolution

Include:
- Clear spatial awareness
- Named techniques (if established)
- Physical toll
- Power differential visible
- Meaningful outcome
```

## Genre: Epic Fantasy Elements

### World-Building Integration

**Don't info-dump.** Weave world details through:
- Character observation
- Conflict arising from the world
- Dialogue that assumes knowledge
- Physical interaction with the setting

**Good:**
> The wards flickered as Sonny passed—they'd been keyed to his bloodline, whether he wanted it or not.

**Bad:**
> The wards were magical barriers created centuries ago by the Founding Masters. They were keyed to specific bloodlines and would react to unauthorized entry by...

### Political/Social Nuance

**Show faction dynamics through:**
- How characters address each other
- What's said vs. unsaid
- Physical positioning
- Small acts of respect/disrespect

**Track:**
- Who has power
- Who wants power
- What power costs
- How power is displayed

### Scale Management

**Grand scale:**
- Reference larger events
- Show ripple effects
- Multiple POVs for scope
- Time jumps for sweep

**Personal moments:**
- Intimate dialogue
- Physical details
- Emotional truth
- Relationship nuance

**Balance both within chapters.**

## Technical Craft

### Point of View

**Third Limited (most common for this genre):**

**Do:**
- Stay in one head per scene
- Show only what POV perceives
- Color description with POV's perspective
- Give full access to POV thoughts

**Don't:**
- Head-hop within scenes
- Reveal other characters' thoughts directly
- Describe things POV doesn't notice
- Use POV as neutral camera

**POV filtering:**
> Sonny saw the elder's eyes narrow.

vs.

> The elder's eyes narrowed.

The second is stronger—we're in Sonny's POV, so we don't need "Sonny saw."

### Show vs. Tell

**Show emotions through:**
- Physical reactions
- Actions taken
- Dialogue choices
- Environment interaction

**Tell is appropriate for:**
- Summary passages
- Time compression
- Establishing facts quickly
- When showing would be tedious

**Balance:** Show the important moments. Tell the transitions.

### Dialogue Craft

**Tags:**
- "Said" and "asked" are invisible—use freely
- Avoid said-bookisms ("exclaimed," "retorted," "interjected")
- Action beats can replace tags
- Silence is a valid response

**Attribution rhythm:**
```
"First line," Character A said.
"Response."
"Response to response." Character A's hand moved to his sword.
"Escalation."
Character B turned away. "Final word."
```

**Subtext:**
```
Surface: "I hope your training goes well."
Subtext: "I don't believe you'll survive."
```

Show the gap between what's said and what's meant.

### Description Density

**High density (use sparingly):**
- First time in significant location
- Emotional peak moments
- Character introductions
- Climactic scenes

**Medium density (standard):**
- Most narrative prose
- Action scenes
- Dialogue scenes
- Transitions

**Low density (speed):**
- Combat
- Tension peaks
- Urgent moments
- Summary passages

### Sentence Variety

**Vary length:**
```
Short sentences create tension. They hit hard. Impact.

Longer sentences allow for more complex thoughts, 
building rhythm and flow that carries the reader 
through descriptive passages or moments of reflection.
```

**Vary structure:**
- Simple: "He ran."
- Compound: "He ran, and the ground crumbled behind him."
- Complex: "When the ground began to crumble, he ran."
- Fragment (sparingly): "Running. Always running."

### Paragraph Rhythm

**Single-line paragraphs for:**
- Emphasis
- Dramatic moments
- Dialogue beats
- Tension peaks

**Longer paragraphs for:**
- Description
- Reflection
- World-building
- Flowing action

**Never:**
- Wall of text (break up)
- All short paragraphs (becomes choppy)
- Pattern-lock (vary rhythm)

## Emotional Craft

### Building Emotional Resonance

**Preparation:**
- Establish what matters
- Show character investment
- Create anticipation

**The Moment:**
- Slow down
- Sensory specificity
- Interiority access
- Let it land

**Aftermath:**
- Don't rush away
- Show the change
- Ripple effects

### Avoiding Melodrama

**Don't:**
- Over-describe emotions
- Have characters sob/scream constantly
- Tell us how to feel
- Linger past impact

**Do:**
- Trust understatement
- Use physical grounding
- Let action convey feeling
- Move forward after beats land

### Earning Big Moments

**Setup required for emotional payoff:**
- We must care about what's at stake
- The threat must feel real
- The cost must be established
- The change must be visible

**The Crucible structure provides this—follow it.**

## Common Pitfalls

### Telling the Obvious

**Bad:** "He felt angry at the betrayal."
**Better:** His jaw tightened. The cup shattered in his grip.

### Floating Heads

**Bad:** Dialogue with no grounding—who's where? Doing what?
**Better:** Ground scenes physically. Add action beats.

### Purple Prose

**Bad:** The cerulean orb of celestial luminescence cast its argentine radiance across the obsidian expanse.
**Better:** The moon lit the dark field.

### White Room Syndrome

**Bad:** Dialogue in a void—no sense of place.
**Better:** Use setting. Characters interact with environment.

### As-You-Know-Bob

**Bad:** "As you know, Master Wei, the ancient bloodlines were created during the Founding Era when..."
**Better:** Reveal through action, conflict, discovery—not characters telling each other what they already know.

## Crucible-Specific Techniques

### Writing the Three Strands

**Quest strand scenes:**
- External focus
- Goal clarity
- Progress/setback visible
- Stakes tangible

**Fire strand scenes:**
- Internal focus
- Power sensation
- Cost visibility
- Danger palpable

**Constellation strand scenes:**
- Relationship focus
- Subtext heavy
- Emotional truth
- Bond tested/proven

### Writing Forge Points

**All three strands converge. Structure:**

1. **Build each strand to crisis** (separate scenes leading in)
2. **Convergence** (all three collide)
3. **The choice/sacrifice** (one strand suffers)
4. **The change** (irreversible shift)
5. **Forward momentum** (into next movement)

**Forge Point chapters should feel:**
- Inevitable
- Devastating
- Transformative
- Necessary

### Writing Mercy Moments

**The setup:**
- Establish ruthlessness would be easier
- Show the cost of mercy
- Make it a real choice

**The act:**
- Simple, clear
- Not self-congratulatory
- Cost immediately visible

**The aftermath:**
- Consequences begin
- Doubt from others
- Seed planted for return

### Writing Theme

**"The past cannot be undone, only transcended."**

This theme should:
- Never be stated directly (except perhaps once, by wise character)
- Be proven through character choices
- Resonate in multiple storylines
- Land fully at the Apex

**Show characters:**
- Trying to undo the past (failing)
- Running from the past (failing)
- Transcending the past (succeeding)
