# Story Bible Commands Reference

Complete reference for `update_story_bible.py` commands used during the writing phase.

## Core Update Command

After each chapter, run:

```bash
python scripts/update_story_bible.py "./draft-project" --chapter X
```

The story bible tracks:
- Chapter-by-chapter summaries
- Character locations/states at each chapter end
- Established facts (names, places, rules)
- Foreshadowing planted (awaiting payoff)
- Foreshadowing paid off
- Timeline progression
- Word counts
- **Completed chapter count** (for bi-chapter review tracking)

## Location Tracking

When a new location is introduced or described in detail:

```bash
python scripts/update_story_bible.py "./draft-project" --location "The Iron Gate" "Ancient gate marking eastern city boundary" 3
```

Arguments: `name`, `description`, `first_seen_chapter`

## Relationship Tracking

When character relationships change significantly:

```bash
python scripts/update_story_bible.py "./draft-project" --relationship "Sonny" "Liu_Ming" "Tentative allies after shared ordeal" --chapter 5
```

Arguments: `char_a`, `char_b`, `status`, `--chapter` (optional)

## Chapter Status Check

Check the current status of a specific chapter:

```bash
python scripts/update_story_bible.py "./draft-project" --status 5
```

Returns: title, word count, scene count, completion status, timeline, and summary preview.

## Mercy Engine Tracking

The Crucible Structure requires tracking mercy shown and refused.

### Record Mercy Shown

```bash
python scripts/update_story_bible.py "./draft-project" --mercy-act "Sonny" "Enemy scout" "Spared their life" 6 2
```

Arguments: `character`, `recipient`, `description`, `chapter`, `scene`

### Record Mercy Refused

```bash
python scripts/update_story_bible.py "./draft-project" --mercy-refused "Sonny" "Could have helped but chose revenge" 8 3 "Scout later betrays them"
```

Arguments: `character`, `situation`, `chapter`, `scene`, `[consequence]` (optional)

### Check Mercy Balance

```bash
python scripts/update_story_bible.py "./draft-project" --mercy-status
```

Returns: mercy balance, count of mercy acts, count of mercy refused, recent mercy acts.

## Character State Updates

### Single Field Update

```bash
python scripts/update_story_bible.py "./draft-project" --character Sonny location "the tavern"
```

### Multiple Fields with JSON

```bash
python scripts/update_story_bible.py "./draft-project" --character Sonny --json '{"location": "tavern", "emotional_state": "anxious"}'
```

### With History Tracking

```bash
python scripts/update_story_bible.py "./draft-project" --character Sonny location "forest" --chapter 5
```

Adding `--chapter` records the state change in character history.

## Inventory Tracking

```bash
python scripts/update_story_bible.py "./draft-project" --character Sonny --json '{"inventory": "Ancient key"}'
```

Or with full structure:
```bash
python scripts/update_story_bible.py "./draft-project" --character Sonny --json '{"inventory": {"item": "Ancient key", "acquired_in": "ch5", "status": "possessed"}}'
```

## Foreshadowing Commands

### Plant Foreshadowing

```bash
python scripts/update_story_bible.py "./draft-project" --plant 3 2 "The mysterious symbol on the door"
```

Arguments: `chapter`, `scene`, `thread_description`

### Record Payoff

```bash
python scripts/update_story_bible.py "./draft-project" --payoff 12 3 "The mysterious symbol"
```

Arguments: `chapter`, `scene`, `thread_match`

## Established Facts

### Add Fact

```bash
python scripts/update_story_bible.py "./draft-project" --fact 3 2 "The city has three gates"
```

Arguments: `chapter`, `scene`, `fact`

## Invented Details

### Flag Invented Detail

```bash
python scripts/update_story_bible.py "./draft-project" --invented 2 1 "The innkeeper's name is Marta"
```

Arguments: `chapter`, `scene`, `detail`

## Continuity Report

Generate a full continuity report:

```bash
python scripts/update_story_bible.py "./draft-project" --report
```

## Mark Review Complete

After completing a bi-chapter review:

```bash
python scripts/update_story_bible.py "./draft-project" --mark-review-complete [chapter]
```

If chapter not specified, uses current `chapters_complete` value.
