# Style Capture Guide

How to learn and maintain an author's voice throughout a novel.

## Why Style Matters

A novel written in inconsistent style feels:
- Jarring to read
- Obviously AI-generated
- Like it was written by committee
- Inauthentic to the story

**The goal:** Write so seamlessly that the author could have written it themselves.

## The Style Sample

### What to Request

Ask for 2,000+ words of the author's writing. Ideal samples:
- From the same genre/project
- Narrative prose (not just dialogue)
- Contains both action and reflection
- Represents their "natural" voice

### If Author Has No Sample

If they're a new writer or don't have existing work:

```
Since you don't have a sample to share, let's build your style preferences:

**Sentence Style:**
A) Short, punchy sentences (Hemingway-esque)
B) Longer, flowing sentences (more literary)
C) Mixed — varies with tension
D) Other (describe)

**Description Density:**
A) Sparse — trust the reader
B) Moderate — key details only
C) Rich — immersive description
D) Other (describe)

[Continue through all style elements...]
```

## Style Analysis Framework

### 1. Sentence Architecture

**Length Analysis:**
- Count words per sentence in sample
- Calculate average
- Note variation (do they vary? By how much?)

```
Short (5-10 words): Action, tension
Medium (11-20 words): Standard narrative
Long (21-35 words): Description, reflection
Very long (35+): Complex ideas, building atmosphere
```

**Structure Analysis:**
- Simple sentences (one clause)
- Compound sentences (two+ independent clauses)
- Complex sentences (dependent clauses)
- What's the ratio?

**Rhythm Analysis:**
- Do sentences start the same way frequently?
- Are there recurring rhythmic patterns?
- How do they handle paragraph breaks?

### 2. Vocabulary Profile

**Register:**
- Formal (elevated language, rare words)
- Informal (conversational, contractions)
- Mixed (shifts with context)

**Word Choice Patterns:**
- Anglo-Saxon vs. Latinate roots
- Common words vs. unusual vocabulary
- Genre-specific terminology frequency

**Signature Words:**
- Does the author overuse certain words?
- Are there favorite phrases?
- Note these for authentic recreation

### 3. Dialogue Style

**Attribution:**
- Minimal ("said" only)
- Standard (variety of tags)
- Elaborate (action beats, description)
- Invisible (no tags when possible)

**Character Voice:**
- How distinct are different characters?
- Dialects? Verbal tics? Catchphrases?
- Formality differences between characters?

**Subtext:**
- Is meaning often under the surface?
- Do characters say what they mean?
- How is tension conveyed in conversation?

### 4. Description Approach

**Sensory Focus:**
- Visual (sight-dominant)
- Auditory (sound-dominant)
- Tactile (touch-dominant)
- Olfactory/Gustatory (smell/taste)
- Mixed (rotates senses)

**Metaphor/Simile Usage:**
- Rare (direct description)
- Occasional (for emphasis)
- Frequent (poetic)
- Genre-specific (cultivation imagery, etc.)

**Setting Integration:**
- Front-loaded (describe, then action)
- Woven (details throughout action)
- Minimal (reader imagines)

### 5. Interiority

**POV Depth:**
- Surface (actions and dialogue only)
- Moderate (occasional thoughts)
- Deep (frequent internal experience)
- Stream of consciousness (rare)

**Emotional Conveyance:**
- Show (physical reactions, actions)
- Tell (named emotions)
- Mixed (balance of both)

**Reflection Frequency:**
- Rare (plot-focused)
- Occasional (at key moments)
- Frequent (character-focused)

### 6. Pacing Mechanics

**Scene Transitions:**
- Hard cuts (immediate jumps)
- Smooth transitions (bridging lines)
- Summary bridges (time compression)

**White Space:**
- Dense paragraphs
- Frequent breaks
- Single-line emphasis
- Chapter break patterns

**Tension Building:**
- Sentence length variation
- Paragraph rhythm changes
- Delayed information
- Cliffhanger techniques

## The Style Profile Document

After analysis, create:

```markdown
# Style Profile: [Author Name]

## Sentence Style
- Average length: 18 words
- Variation: High (8-40 word range)
- Structure: 40% simple, 35% compound, 25% complex
- Rhythm: Varies with tension; short in action, longer in reflection

## Vocabulary
- Register: Mixed, shifts formal in cultivation scenes
- Density: Moderate
- Signature words: "something," "perhaps," "simply"
- Avoids: Excessive adverbs

## Dialogue
- Attribution: Minimal; uses action beats over tags
- Character distinction: Moderate; differentiated by formality
- Subtext: Heavy; characters rarely say what they mean directly

## Description
- Sensory focus: Visual primary, tactile secondary
- Metaphor density: Moderate; genre-appropriate imagery
- Setting integration: Woven throughout

## Interiority
- POV depth: Deep third limited
- Emotional conveyance: Show-heavy, names emotions at peaks
- Reflection: Occasional; at chapter ends, after major events

## Pacing
- Transitions: Smooth; uses bridging sentences
- White space: Moderate; dramatic moments get single lines
- Tension: Sentence shortening, paragraph fragmentation

## Signature Elements
1. Uses environment to mirror emotional state
2. Ends chapters on unresolved moments
3. Interrupts dialogue with physical action
4. Names sensations precisely
5. Avoids "said bookisms" (said, asked, replied only)
```

## Maintaining Style During Writing

### The Style Check

Every few paragraphs, ask:
- Does this sentence length match the profile?
- Would the author use this word?
- Is the description density right?
- Does the dialogue attribution match?

### Common Drift Patterns

**Going Too Formal:**
- Sign: Latinate vocabulary creeping in
- Fix: Use simpler Anglo-Saxon alternatives

**Going Too Sparse:**
- Sign: Dialogue without context
- Fix: Add sensory grounding, action beats

**Going Too Dense:**
- Sign: Long paragraphs of description
- Fix: Break up, add dialogue or action

**Losing Character Voice:**
- Sign: All characters sound the same
- Fix: Review character speech patterns

### Mid-Chapter Calibration

If you feel drift occurring:

```
[STYLE CHECK]
Reviewing last 500 words against profile...

Issue detected: Sentences averaging 25 words vs. target 18
Adjusting: Breaking long sentences, adding punchy beats

Continuing with recalibrated style...
```

## Genre-Specific Considerations

### Cultivation Fantasy

Common conventions:
- Power descriptions (internal energy, techniques)
- Formal speech patterns (especially masters)
- Hierarchical relationships in dialogue
- Physical sensation during cultivation
- Combat flow description

### Epic Fantasy

Common conventions:
- World-building integration
- Multiple POV voice distinction
- Political/social nuance
- Grand scale vs. personal moments
- Archaic/formal register variations

### Match genre conventions UNLESS the author's sample deliberately subverts them.

## Style Evolution

Over a long novel, style may legitimately shift:
- Darker chapters → shorter sentences
- Older character → different voice
- Different locations → different atmosphere

**Track these intentional shifts in the style profile.**

## Author Feedback Loop

After each chapter, confirm style:

```
**Style Check — Chapter [X]**

Sample from this chapter:
"[Quote 100-word passage]"

Does this match your voice?
A) Yes, continue
B) Adjustment needed: [specify]
```

Incorporate feedback immediately into the style profile.
