# Writing Process Guide

The scene-by-scene approach to drafting from a Crucible outline.

## The Unit of Work: The Scene

A chapter contains multiple scenes. Write ONE SCENE AT A TIME.

**Why scenes, not chapters:**
- Scenes fit comfortably in context
- Easier to verify against outline
- Natural stopping points
- Easier to revise
- Clearer progress tracking

## Scene Anatomy

From the outline, each scene has:

```
SCENE STRUCTURE:
├── Goal — What POV character wants
├── Conflict — What opposes them
├── Turn — How situation changes
├── Key Moments — Specific beats required
└── Plants/Payoffs — Foreshadowing work
```

**Every scene must execute ALL these elements.**

## Pre-Writing Ritual

Before writing any scene:

### Step 1: Load Context

```
Loading for Chapter [X], Scene [Y]:
□ Scene outline
□ Style profile
□ Previous scene summary (or chapter summary if first scene)
□ Active character states
□ Relevant foreshadowing
```

### Step 2: Confirm Understanding

```
SCENE [X.Y] BRIEF:

Goal: [State it]
Conflict: [State it]
Turn: [State it]

Key Moments:
1. [List from outline]
2. [List]
3. [List]

Plants: [What needs to be seeded]
Payoffs: [What needs to resolve]

Proceeding with this understanding?
```

### Step 3: Identify Unknowns

```
Before writing, I need clarification on:
- [Any unclear elements]
- [Any missing details]

Or: No clarification needed. Proceeding.
```

## Writing the Scene

### Opening the Scene

**Options for scene openings:**

1. **In Media Res** — Start mid-action
   - Best for: Action scenes, tense moments
   - Example: "The blade was already falling when Sonny—"

2. **Establishing** — Ground the reader
   - Best for: New locations, time jumps
   - Example: "Three days later, the gates of the sect rose before them."

3. **Character State** — Interior opening
   - Best for: Reflective scenes, after major events
   - Example: "Sonny couldn't stop seeing the bodies."

4. **Dialogue** — Conversation in progress
   - Best for: Character scenes, relationship moments
   - Example: "'You shouldn't have come,' Liu Ming said."

**Match opening type to scene purpose.**

### The Middle: Executing Key Moments

Work through key moments in order (unless the outline specifies otherwise).

**For each key moment:**
1. Write the beat
2. Verify it matches outline
3. Note word count
4. Continue to next beat

**Pacing through the middle:**
- Build tension toward the turn
- Don't rush key moments
- Don't pad between them
- Let dialogue breathe

### Executing the Turn

The turn is the scene's climax. It must:
- Change the situation
- Create forward momentum
- Land emotionally
- Set up the next scene

**Turn types and how to write them:**

| Turn Type | Technique |
|-----------|-----------|
| Revelation | Build to the moment; short sentence for the reveal |
| Decision | Show the weight; make the choice clear |
| Disaster | Establish hope first; then shatter it |
| Victory | Make the cost visible; don't make it easy |
| Cliffhanger | Cut at maximum tension |

### Closing the Scene

**End with forward pull.** Even within a chapter, scenes should propel.

**Scene ending options:**
- Hard cut (end on turn, jump to next scene)
- Bridging line (transitional sentence)
- Lingering image (final evocative detail)

**Never end on:**
- Resolution of all tension
- Character falling asleep
- Complete satisfaction

## Post-Writing Verification

After completing a scene draft:

### Checklist

```
SCENE [X.Y] VERIFICATION:

Required Elements:
□ Goal: Was it clear what POV wanted?
□ Conflict: Was opposition present throughout?
□ Turn: Did the situation change?

Key Moments:
□ [Moment 1] — Present? Page?
□ [Moment 2] — Present? Page?
□ [Moment 3] — Present? Page?

Foreshadowing:
□ Plants executed: [List what was planted]
□ Payoffs executed: [List what was resolved]

Consistency:
□ Character states match story bible?
□ Timeline consistent?
□ No invented elements (or flagged if so)?

Word Count:
□ Scene total: [X,XXX]
□ On target? [Yes/Adjust]
```

### Flagging Issues

If verification reveals problems:

```
ISSUE DETECTED:

Scene [X.Y] missing required element:
- [What's missing]

Options:
A) Add it now (show revised section)
B) Flag for author input
C) Discuss before proceeding
```

## Chapter Assembly

After all scenes in a chapter are complete:

### Chapter-Level Verification

```
CHAPTER [X] ASSEMBLY:

Scenes:
1. [Scene title] — [word count] — ✓ verified
2. [Scene title] — [word count] — ✓ verified
3. [Scene title] — [word count] — ✓ verified

Total words: [X,XXX]
Target: [X,XXX]
Status: [On target / Over by X / Under by X]

Chapter-level requirements:
□ Opening hook present?
□ Chapter arc complete?
□ Chapter turn achieved?
□ Ending hook present?
□ All outline elements covered?
```

### Transitions Between Scenes

Verify scene transitions are smooth:

```
Scene 1 → Scene 2:
- Time gap: [None / Hours / Days / Weeks]
- Location change: [Same / Different]
- POV change: [Same / Different]
- Transition type: [Hard cut / Bridge / Summary]
```

### Chapter Save

```bash
python scripts/save_draft.py "./draft-project" --chapter X
```

## Handling Scene Variations

### Action Scenes

**Characteristics:**
- Shorter sentences
- More white space
- Less interiority
- Physical sensation focus
- Clear spatial awareness

**Technique:**
- Write beat by beat
- Track positions
- Vary sentence rhythm with tension
- End beats on hooks

### Dialogue Scenes

**Characteristics:**
- Natural speech rhythms
- Action beats between lines
- Subtext awareness
- Character voice distinction

**Technique:**
- Read aloud mentally
- Break up long speeches
- Use silence/pauses
- Show reactions

### Reflection Scenes

**Characteristics:**
- Longer sentences
- More interiority
- Emotional processing
- Thematic connection

**Technique:**
- Ground in sensory detail
- Connect to character arc
- Don't overindulge
- End with forward motion

### Revelation Scenes

**Characteristics:**
- Building tension
- Information control
- Reaction importance
- Turn on the reveal

**Technique:**
- Pace toward the reveal
- Don't bury the lead
- Give reaction space
- Land the implications

## Word Count Management

### Per-Scene Targets

| Scene Type | Target Range |
|------------|--------------|
| Action | 1,500-2,500 words |
| Dialogue | 1,000-2,000 words |
| Reflection | 800-1,500 words |
| Transition | 500-1,000 words |
| Major revelation | 1,500-2,500 words |
| Forge Point climax | 2,500-4,000 words |

### If Running Short

- Expand sensory grounding
- Add interiority at key moments
- Lengthen dialogue exchanges naturally
- Add transitional beats
- Deepen emotional resonance

### If Running Long

- Trust the reader more
- Cut redundant dialogue
- Tighten description
- Remove unnecessary beats
- Check for repeated information

## Revision Within Process

### Minor Revision (same session)

If you see an issue while writing:
- Note it
- Finish the scene
- Revise before saving

### Major Revision (needs discussion)

If the outline seems wrong or incomplete:
- Stop writing
- Flag the issue
- Ask author before proceeding

### Never silently "fix" the outline by writing something different.

## Progress Tracking

After each scene:

```
SESSION PROGRESS:

Chapter [X]:
- Scene 1: 1,847 words ✓
- Scene 2: 1,456 words ✓
- Scene 3: [in progress]

Session total: 3,303 words
Book total: [X,XXX] words
Target: [X,XXX] words
Pace: [On track / Behind by X / Ahead by X]
```

## The Daily Rhythm

A typical writing session:

```
1. Load project state
2. Review where you left off
3. Load context for current scene
4. Write scene
5. Verify scene
6. Save scene
7. Update story bible
8. Repeat or end session

If ending:
- Save all work
- Note exact stopping point
- Summary of session progress
```
