---
name: speckit-analyze-zh
description: 对spec.md、plan.md和tasks.md三个核心文档进行非破坏性跨工件一致性和质量分析。在任务生成后识别不一致、重复、模糊和规范不足的项目。触发词包括："speckit-analyze"、"speckit分析"、"文档一致性分析"、"规范分析"、"质量检查"、"工件分析"、"spec分析"、"plan分析"、"task分析"。
---

## 用户输入

```text
$ARGUMENTS
```

您**必须**在继续之前考虑用户输入（如果不为空）。

## 目标

在实现之前，识别三个核心工件（`spec.md`、`plan.md`、`tasks.md`）之间的不一致、重复、歧义和未充分说明的项目。此命令必须仅在 `speckit-tasks` 成功生成完整的 `tasks.md` 后运行。

## 操作约束

**严格只读**：**不要**修改任何文件。输出结构化分析报告。提供可选的补救计划（用户必须明确批准后才能手动调用任何后续编辑命令）。

**宪章权威性**：项目宪章（`.specify/memory/constitution.md`）在此分析范围内是**不可协商的**。宪章冲突自动为关键级别，需要调整规格、计划或任务——而不是稀释、重新解释或默默忽略原则。如果原则本身需要更改，必须在 `speckit-analyze` 之外的单独、明确的宪章更新中进行。

## 执行步骤

scripts:
  sh: .specify/scripts/bash/check-prerequisites.sh --json
  ps: .specify/scripts/powershell/check-prerequisites.ps1 -Json

### 1. 初始化分析上下文

从仓库根目录运行一次 `{SCRIPT}` 并解析 JSON 以获取 FEATURE_DIR 和 AVAILABLE_DOCS。推导绝对路径：

- SPEC = FEATURE_DIR/spec.md
- PLAN = FEATURE_DIR/plan.md
- TASKS = FEATURE_DIR/tasks.md

如果缺少任何必需文件，则中止并显示错误消息（指示用户运行缺少的先决条件命令）。
对于参数中的单引号，如 "I'm Groot"，使用转义语法：例如 'I'\''m Groot'（或者如果可能的话使用双引号："I'm Groot"）。

### 2. 加载工件（渐进式披露）

仅加载每个工件的最小必要上下文：

**来自 spec.md：**

- 概述/上下文
- 功能要求
- 非功能要求
- 用户故事
- 边缘情况（如果存在）

**来自 plan.md：**

- 架构/技术栈选择
- 数据模型引用
- 阶段
- 技术约束

**来自 tasks.md：**

- 任务 ID
- 描述
- 阶段分组
- 并行标记 [P]
- 引用的文件路径

**来自 constitution：**

- 加载 `.specify/memory/constitution.md` 用于原则验证

### 3. 构建语义模型

创建内部表示（不要在输出中包含原始工件）：

- **要求清单**：每个功能+非功能要求带有一个稳定键（根据祈使句派生 slug；例如，"用户可以上传文件" → `user-can-upload-file`）
- **用户故事/动作清单**：具有验收标准的离散用户动作
- **任务覆盖映射**：将每个任务映射到一个或多个要求或故事（通过关键词/显式引用模式如 ID 或关键词进行推断）
- **宪章规则集**：提取原则名称和 MUST/SHOULD 规范性陈述

### 4. 检测过程（高效令牌分析）

专注于高信号发现。限制总数为 50 个发现；在溢出摘要中聚合其余发现。

#### A. 重复检测

- 识别近似重复的要求
- 标记质量较低的措辞以进行合并

#### B. 歧义检测

- 标记缺乏可测量标准的模糊形容词（快速、可扩展、安全、直观、健壮）
- 标记未解决的占位符（TODO、TKTK、???、`<placeholder>` 等）

#### C. 未充分说明

- 有动词但缺少对象或可测量结果的要求
- 缺少验收标准对齐的用户故事
- 引用在规格/计划中未定义的文件或组件的任务

#### D. 宪章对齐

- 任何与 MUST 原则冲突的要求或计划元素
- 缺少宪章中规定的章节或质量门

#### E. 覆盖差距

- 没有关联任务的要求
- 没有映射要求/故事的任务
- 未在任务中体现的非功能要求（例如，性能、安全性）

#### F. 不一致

- 术语漂移（同一概念在不同文件中有不同名称）
- 计划中引用但在规格中缺失的数据实体（反之亦然）
- 任务排序矛盾（例如，集成任务在基础设置任务之前但没有依赖注释）
- 冲突的要求（例如，一个要求 Next.js 而另一个指定 Vue）

### 5. 严重性分配

使用此启发式方法来优先处理发现：

- **关键**：违反宪章 MUST、缺少核心规格工件，或阻塞基本功能的零覆盖要求
- **高**：重复或冲突的要求、模糊的安全/性能属性、不可测试的验收标准
- **中**：术语漂移、缺少非功能任务覆盖、未充分说明的边缘情况
- **低**：样式/措辞改进、不影响执行顺序的次要冗余

### 6. 生成紧凑分析报告

输出一个 Markdown 报告（不写入文件）具有以下结构：

## 规格分析报告

| ID   | 类别 | 严重性 | 位置             | 摘要               | 建议                       |
| ---- | ---- | ------ | ---------------- | ------------------ | -------------------------- |
| A1   | 重复 | 高     | spec.md:L120-134 | 两个相似的要求 ... | 合并措辞；保留更清晰的版本 |

（每项发现添加一行；生成以类别首字母为前缀的稳定 ID。）

**覆盖摘要表：**

| 要求键 | 有任务？ | 任务 ID | 备注 |
| ------ | -------- | ------- | ---- |

**宪章对齐问题：**（如果有）

**未映射的任务：**（如果有）

**指标：**

- 总要求
- 总任务
- 覆盖率%（有>=1个任务的要求）
- 歧义计数
- 重复计数
- 关键问题计数

### 7. 提供下一步行动

在报告末尾，输出一个简洁的下一步行动块：

- 如果存在关键问题：建议在 `speckit-implement` 之前解决
- 如果只有低/中等：用户可以继续，但提供改进建议
- 提供明确的命令建议：例如，"使用改进运行 `speckit-specify`"，"运行 `speckit-plan` 调整架构"，"手动编辑 tasks.md 添加 'performance-metrics' 的覆盖"

### 8. 提供补救措施

询问用户："您希望我为前 N 个问题建议具体的补救编辑吗？"（不要自动应用它们。）

## 操作原则

### 上下文效率

- **最小高信号令牌**：专注于可操作的发现，而不是详尽的文档
- **渐进式披露**：增量加载工件；不要将所有内容倒入分析
- **高效令牌输出**：限制发现表为 50 行；总结溢出
- **确定性结果**：在没有更改的情况下重新运行应产生一致的 ID 和计数

### 分析指南

- **永不修改文件**（这是只读分析）
- **永不虚构缺失部分**（如果缺失，准确报告）
- **优先处理宪章违规**（这些总是关键的）
- **使用示例而非详尽规则**（引用具体实例，而非通用模式）
- **优雅报告零问题**（发出带有覆盖统计的成功报告）

## 上下文

{ARGS}

