# 分析模式参考

## 检测模式详解

### 1. 重复检测模式

**识别模式:**
- 相似的动词结构
- 同一概念的不同表述
- 功能重叠的描述

**处理策略:**
- 保留更清晰的版本
- 合并相似的描述
- 统一术语表达

### 2. 模糊性检测模式

**常见模糊词汇:**
- 性能相关: "快速"、"高性能"、"优化"
- 安全相关: "安全"、"可靠"、"保护"
- 用户体验: "直观"、"友好"、"易用"
- 可扩展性: "可扩展"、"灵活"、"适应性强"

**解决方案:**
- 添加可量化指标
- 提供具体的衡量标准
- 明确测试条件

### 3. 覆盖度分析模式

**需求-任务映射规则:**
- 直接关键词匹配
- 语义相似性推断
- 上下文关联分析

**覆盖度计算:**
- 有任务覆盖的需求数量 / 总需求数量
- 非功能需求的覆盖检查
- 验收标准的对齐验证

## 严重性评估标准

### CRITICAL级别
- 违反项目宪章MUST原则
- 缺少核心功能需求
- 阻塞基线功能的实现
- 安全或合规性违规

### HIGH级别
- 重复或冲突的需求定义
- 关键性能指标缺失
- 不可测试的验收标准
- 架构决策冲突

### MEDIUM级别
- 术语使用不一致
- 非功能需求覆盖不足
- 边界情况定义不清
- 任务依赖关系不明确

### LOW级别
- 文档风格问题
- 轻微冗余表达
- 格式规范化建议
- 非关键改进建议