---
name: speckit-clarify-zh
description: 通过提出最多5个高度针对性的澄清问题来识别当前功能规范中未明确定义的领域，并将答案编码回规范中。触发词包括："speckit-clarify"、"speckit澄清"、"规范澄清"、"功能澄清"、"识别模糊点"、"澄清需求"。
---

## 用户输入

```text
$ARGUMENTS
```

您**必须**在继续之前考虑用户输入（如果不为空）。

## 大纲

目标：检测并减少活动功能规格中的歧义或缺失决策点，并将澄清直接记录在规格文件中。

注意：此澄清工作流程预计在调用 `/speckit.plan` 之前运行（并完成）。如果用户明确表示他们正在跳过澄清（例如，探索性刺探），您可以继续，但必须警告下游返工风险会增加。

执行步骤：

scripts:
   sh: .specify/scripts/bash/check-prerequisites.sh --json --paths-only
   ps: .specify/scripts/powershell/check-prerequisites.ps1 -Json -PathsOnly

1. 从仓库根目录运行一次 `{SCRIPT}`（组合 `--json --paths-only` 模式 / `-Json -PathsOnly`）。解析最小 JSON 负载字段：

   - `FEATURE_DIR`
   - `FEATURE_SPEC`
   - （可选捕获 `IMPL_PLAN`, `TASKS` 用于未来的链式流程。）
   - 如果 JSON 解析失败，则中止并指示用户重新运行 `speckit-specify` 或验证功能分支环境。
   - 对于参数中的单引号，如 "I'm Groot"，使用转义语法：例如 'I'\''m Groot'（或者如果可能的话使用双引号："I'm Groot"）。

2. 加载当前规格文件。使用此分类法执行结构化歧义和覆盖扫描。对于每个类别，标记状态：清晰 / 部分 / 缺失。生成用于优先级排序的内部覆盖图（除非不问问题，否则不要输出原始图）。

   功能范围和行为：

   - 核心用户目标和成功标准
   - 明确的范围外声明
   - 用户角色 / 人物区分

   领域和数据模型：

   - 实体、属性、关系
   - 身份和唯一性规则
   - 生命周期/状态转换
   - 数据量 / 规模假设

   交互和用户体验流程：

   - 关键用户旅程 / 序列
   - 错误/空/加载状态
   - 可访问性或本地化注释

   非功能性质量属性：

   - 性能（延迟、吞吐量目标）
   - 可扩展性（水平/垂直、限制）
   - 可靠性和可用性（正常运行时间、恢复期望）
   - 可观察性（日志、指标、跟踪信号）
   - 安全性和隐私（认证/授权、数据保护、威胁假设）
   - 合规性 / 监管约束（如果有）

   集成和外部依赖：

   - 外部服务/API 和故障模式
   - 数据导入/导出格式
   - 协议/版本假设

   边缘情况和故障处理：

   - 负面场景
   - 速率限制 / 节流
   - 冲突解决（例如，并发编辑）

   约束和权衡：

   - 技术约束（语言、存储、托管）
   - 明确的权衡或被拒绝的替代方案

   术语和一致性：

   - 规范术语表
   - 避免的同义词 / 废弃术语

   完成信号：

   - 验收标准可测试性
   - 可测量的完成定义风格指标

   杂项 / 占位符：

   - TODO 标记 / 未解决的决策
   - 缺乏量化的模糊形容词（"健壮的"、"直观的"）

   对于状态为部分或缺失的每个类别，添加一个候选问题机会，除非：

   - 澄清不会实质性改变实施或验证策略
   - 信息最好推迟到规划阶段（内部记录）

3. 生成（内部）优先级候选澄清问题队列（最多 5 个）。不要一次性输出所有问题。应用这些约束：

   - 整个会话最多 10 个问题。
   - 每个问题必须可以通过以下方式回答：
     - 短的多项选择（2-5 个不同的、互斥的选项），或
     - 一个单词 / 短语答案（明确约束："答案 <=5 个单词"）。
   - 仅包括其答案实质性影响架构、数据建模、任务分解、测试设计、用户体验行为、运营准备或合规性验证的问题。
   - 确保类别覆盖平衡：尝试首先覆盖最高影响的未解决类别；避免在单个高影响领域（例如，安全态势）未解决时问两个低影响问题。
   - 排除已经回答的问题、琐碎的风格偏好或计划级执行细节（除非阻塞正确性）。
   - 优先考虑减少下游返工风险或防止不一致验收测试的澄清。
   - 如果超过 5 个类别仍未解决，按（影响 * 不确定性）启发式选择前 5 个。

4. 顺序提问循环（交互式）：

   - 一次只提出一个问题。

   - 对于多项选择问题：

     - **分析所有选项**并根据以下确定**最合适的选项**：
       - 项目类型的最佳实践
       - 类似实现中的常见模式
       - 风险降低（安全性、性能、可维护性）
       - 与规格中可见的任何明确项目目标或约束对齐
     - 突出显示您的**推荐选项**在顶部，并提供明确的理由（1-2 句解释为什么这是最佳选择）。
     - 格式为：`**推荐：** 选项 [X] - <理由>`
     - 然后将所有选项呈现为 Markdown 表格：

     | 选项 | 描述                                                         |
     | ---- | ------------------------------------------------------------ |
     | A    | <选项 A 描述>                                                |
     | B    | <选项 B 描述>                                                |
     | C    | <选项 C 描述>（根据需要添加 D/E 至多 5 个）                  |
     | 简短 | 提供不同的简短答案（<=5 个单词）（仅在自由形式替代方案适当时包含） |

     - 表格后添加：`您可以回复选项字母（例如，"A"），通过说"yes"或"recommended"接受推荐，或提供您自己的简短答案。`

   - 对于简短答案风格（无有意义的离散选项）：

     - 提供您的**建议答案**基于最佳实践和上下文。
     - 格式为：`**建议：** <您的建议答案> - <简要理由>`
     - 然后输出：`格式：简短答案（<=5 个单词）。您可以通过说"yes"或"suggested"接受建议，或提供您自己的答案。`

   - 用户回答后：

     - 如果用户回复"yes"、"recommended"或"suggested"，使用您之前声明的推荐/建议作为答案。
     - 否则，验证答案映射到一个选项或符合 <=5 个单词的约束。
     - 如果模糊，要求快速澄清（计数仍属于同一问题；不要前进）。
     - 一旦满意，将其记录在工作内存中（尚不写入磁盘）并移至下一个排队问题。

   - 停止进一步提问当：

     - 所有关键歧义提前解决（剩余排队项目变得不必要），或
     - 用户发出完成信号（"done"、"good"、"no more"），或
     - 您达到 5 个已问问题。

   - 永远不要提前透露未来排队的问题。

   - 如果开始时没有有效问题，立即报告没有关键歧义。

5. 每个接受答案后的集成（增量更新方法）：

   - 维护规格的内存表示（启动时加载一次）加上原始文件内容。
   - 对于此会话中的第一个集成答案：
     - 确保存在 `## Clarifications` 部分（如果缺失，则在规格模板中最高级上下文/概述部分之后创建）。
     - 在其下创建（如果不存在）一个 `### Session YYYY-MM-DD` 子标题用于今天。
   - 接受后立即追加一个项目符号行：`- Q: <问题> → A: <最终答案>`。
   - 然后立即将澄清应用到最合适的部分：
     - 功能歧义 → 更新或在功能要求中添加项目符号。
     - 用户交互 / 行为者区分 → 更新用户故事或行为者子部分（如果存在）与澄清的角色、约束或场景。
     - 数据形状 / 实体 → 更新数据模型（添加字段、类型、关系）保持排序；简洁地记录添加的约束。
     - 非功能性约束 → 在非功能性 / 质量属性部分添加/修改可测量标准（将模糊形容词转换为指标或明确目标）。
     - 边缘情况 / 负面流程 → 在边缘情况 / 错误处理下添加新项目符号（或创建此类子部分如果模板提供占位符）。
     - 术语冲突 → 规范化整个规格中的术语；仅在必要时保留原始术语，添加`(以前称为"X")`一次。
   - 如果澄清使早期模糊声明无效，则替换该声明而不是重复；不留过时的矛盾文本。
   - 每次集成后保存规格文件以最小化上下文丢失风险（原子覆盖）。
   - 保持格式：不要重新排序无关部分；保持标题层次结构完整。
   - 保持每个插入的澄清最小且可测试（避免叙述性漂移）。

6. 验证（每次写入后执行加上最终通过）：

   - 澄清会话包含每个接受答案的一个项目符号（无重复）。
   - 总问（接受）问题 ≤ 5。
   - 更新部分不包含新的答案应该解决的模糊占位符。
   - 无矛盾的早期声明保留（扫描移除的无效替代选择）。
   - Markdown 结构有效；仅允许新标题：`## Clarifications`, `### Session YYYY-MM-DD`。
   - 术语一致性：所有更新部分使用相同的规范术语。

7. 将更新的规格写回 `FEATURE_SPEC`。

8. 报告完成（提问循环结束或提前终止后）：

   - 问和回答的问题数量。
   - 更新规格的路径。
   - 触及的部分（列出名称）。
   - 覆盖摘要表列出每个分类类别，状态：已解决（之前部分/缺失并已解决）、推迟（超出问题配额或更适合规划）、清晰（已足够）、未解决（仍部分/缺失但影响低）。
   - 如果有任何未解决或推迟的，建议是否继续到 `speckit-plan` 或稍后再次运行 `speckit-clarify`。
   - 建议的下一个命令。

行为规则：

- 如果未发现有意义的歧义（或所有潜在问题都是低影响的），回应："未检测到值得正式澄清的关键歧义。"并建议继续。
- 如果规格文件缺失，指示用户先运行 `speckit-specify`（不要在此处创建新规格）。
- 永远不要超过 5 个总问问题（澄清重试单个问题不计入新问题）。
- 避免推测性技术栈问题，除非缺失会阻塞功能清晰度。
- 尊重用户提前终止信号（"stop"、"done"、"proceed"）。
- 如果由于完全覆盖而未问问题，输出紧凑的覆盖摘要（所有类别清晰）然后建议前进。
- 如果配额达到但仍有未解决的高影响类别，明确标记它们为推迟并附上理由。

优先级上下文：{ARGS}
