---
name: speckit-constitution-zh
description: 从交互式或提供的原则输入创建或更新项目章程，确保所有依赖模板保持同步。用于项目管理、规范制定、章程维护和团队协作场景。触发词包括 "speckit章程"、"创建章程"、"更新章程"、"项目章程"、"制定规范"、"团队章程"。
---

## 用户输入

```text
$ARGUMENTS
```

在继续之前，您**必须**考虑用户输入（如果不为空）。

## 大纲

您正在更新位于 `.specify/memory/constitution.md` 的项目章程。此文件源自一个模板[assets/constitution-template.md](assets/constitution-template.md)，包含方括号中的占位符令牌（例如 `[项目名称]`、`[原则_1_名称]`）。您的工作是：(a) 收集/推导具体值，(b) 精确填充模板，以及 (c) 在依赖工件中传播任何修订。

遵循此执行流程：

1. 将 `assets/specify/` 所有文件（包括子目录）按原目录结构复制到仓库根目录下的`.specify` 目录，跳过已有文件，**不能覆盖原有同名文件**。cp命令的 -n（--no-clobber）选项可以防止覆盖已存在的文件。
在此阶段，您的项目文件夹内容应类似于以下内容：

```text
仓库根目录
└── .specify
    ├── memory
    │  └── constitution.md
    ├── scripts
    │  ├──bash    
    │  │  ├── check-prerequisites.sh
    │  │  ├── common.sh
    │  │  ├── create-new-feature.sh
    │  │  ├── setup-plan.sh
    │  │  └── update-claude-md.sh
    │  ├──powershell    
    │  │  ├── check-prerequisites.ps1
    │  │  ├── common.ps1
    │  │  ├── create-new-feature.ps1
    │  │  ├── setup-plan.ps1
    │  │  └── update-claude-md.ps1    
    ├── specs
    │  └── 001-create-taskify
    │      └── spec.md
    └── templates
        ├── plan-template.md
        ├── spec-template.md
        └── tasks-template.md
```


2. 加载位于相对仓库根目录 `.specify/memory/constitution.md` 的现有章程模板。
   - 识别形式为 `[ALL_CAPS_IDENTIFIER]` 的每个占位符令牌。
     **重要**：用户可能需要比模板中使用的更少或更多的原则。如果指定了数量，请遵守该数量 - 遵循通用模板。您将相应地更新文档。

3. 收集/推导占位符的值：
   - 如果用户输入（对话）提供了值，则使用它。
   - 否则从现有仓库上下文推断（README、文档、嵌入的先前章程版本）。
   - 对于治理日期：`批准日期` 是原始采用日期（如果未知则询问或标记 TODO），如果有更改则 `最后修订日期` 是今天，否则保持之前的日期。
   - `章程版本` 必须根据语义版本规则递增：
     - 主版本：向后不兼容的治理/原则删除或重新定义。
     - 次版本：添加新原则/章节或实质性扩展指导。
     - 补丁：澄清、措辞、拼写错误修复、非语义性优化。
   - 如果版本升级类型不明确，在最终确定前提出理由。

4. 起草更新的章程内容：
   - 用具体文本替换每个占位符（除了项目选择尚未定义而有意保留的模板槽位——明确说明任何剩余的占位符）。
   - 保留标题层次结构，一旦替换可以移除注释，除非它们仍然提供澄清指导。
   - 确保每个原则部分：简洁的名称行，段落（或项目符号列表）捕捉不可协商的规则，如果不是显而易见则提供明确的理由。
   - 确保治理部分列出修订程序、版本策略和合规审查期望。

5. 一致性传播检查清单（将先前检查清单转换为积极验证）：
   - 读取 `.specify/templates/plan-template.md` 并确保任何"章程检查"或规则与更新的原则一致。
   - 读取 `.specify/templates/spec-template.md` 以对齐范围/要求——如果章程添加/删除强制性章节或约束则更新。
   - 读取 `.specify/templates/tasks-template.md` 并确保任务分类反映新增或删除的原则驱动任务类型（例如，可观察性、版本控制、测试纪律）。
   - 读取任何运行时指导文档（例如 `README.md`、`docs/quickstart.md` 或存在的特定代理指导文件）。更新对已更改原则的引用。

6. 生成同步影响报告（在更新后作为 HTML 注释预置在章程文件顶部）：
   - 版本变更：旧 → 新
   - 修改的原则列表（旧标题 → 新标题如果重命名）
   - 新增章节
   - 删除章节
   - 需要更新的模板（✅ 已更新 / ⚠ 待处理）及文件路径
   - 如果有任何占位符被故意推迟，则列出后续待办事项。

7. 最终输出前的验证：
   - 没有剩余未解释的括号令牌。
   - 版本行与报告匹配。
   - 日期为 ISO 格式 YYYY-MM-DD。
   - 原则是陈述性的、可测试的，并且没有模糊语言（"应该" → 在适当地方替换为 MUST/SHOULD 理由）。

8. 将完成的章程写回到 `.specify/memory/constitution.md`（覆盖）。

9.  向用户输出最终摘要：
   - 新版本和升级理由。
   - 任何标记为手动跟进的文件。
   - 建议的提交消息（例如，`docs: 修订章程至 vX.Y.Z（原则添加 + 治理更新）`）。

格式化和样式要求：

- 完全按照模板中的 Markdown 标题使用（不要降级/升级级别）。
- 包装长理由行以保持可读性（理想情况下 <100 个字符），但不要用生硬的断行强制执行。
- 在章节之间保持单个空行。
- 避免尾随空白。

如果用户提供部分更新（例如，仅修订一个原则），仍需执行验证和版本决策步骤。

如果关键信息缺失（例如，批准日期确实未知），插入 `TODO(<FIELD_NAME>): explanation` 并在同步影响报告的延期项目下包含。

不要创建新模板；始终在现有的 `.specify/memory/constitution.md` 文件上操作。