---
description: 根据交互式或提供的原则输入创建或更新项目宪章，确保所有依赖模板保持同步
---

## 用户输入

```text
$ARGUMENTS
```

您**必须**在继续之前考虑用户输入（如果不为空）。

## 大纲

您正在更新位于 `/memory/constitution.md` 的项目宪章。此文件是一个模板，包含方括号中的占位符标记（例如 `[PROJECT_NAME]`, `[PRINCIPLE_1_NAME]`）。您的工作是 (a) 收集/推导具体值，(b) 精确填充模板，以及 (c) 传播任何修订到依赖工件。

遵循此执行流程：

1. 加载位于 `/memory/constitution.md` 的现有宪章模板。
   - 识别形式为 `[ALL_CAPS_IDENTIFIER]` 的每个占位符标记。
   **重要**：用户可能需要比模板中使用的更少或更多的原则。如果指定了数量，请尊重 - 遵循通用模板。您将相应地更新文档。

2. 收集/推导占位符的值：
   - 如果用户输入（对话）提供了值，则使用它。
   - 否则从现有仓库上下文（README、文档、先前的宪章版本（如果嵌入））推断。
   - 对于治理日期：`RATIFICATION_DATE` 是原始采用日期（如果未知则询问或标记 TODO），`LAST_AMENDED_DATE` 是今天如果进行了更改，否则保持先前日期。
   - `CONSTITUTION_VERSION` 必须根据语义版本规则递增：
     - MAJOR：向后不兼容的治理/原则删除或重新定义。
     - MINOR：添加新原则/部分或实质性扩展指导。
     - PATCH：澄清、措辞、拼写错误修复、非语义性改进。
   - 如果版本提升类型不明确，在最终确定前提出理由。

3. 起草更新的宪章内容：
   - 用具体文本替换每个占位符（除了项目选择尚未定义的故意保留的模板槽位 - 明确说明任何保留的槽位）。
   - 保持标题层次结构，注释可以在替换后删除，除非它们仍然提供澄清指导。
   - 确保每个原则部分：简洁的名称行，段落（或项目符号列表）捕获不可协商的规则，如果不是显而易见则提供明确的理由。
   - 确保治理部分列出修订程序、版本政策和合规性审查期望。

4. 一致性传播检查表（将先前的检查表转换为积极验证）：
   - 读取 `/templates/plan-template.md` 并确保任何"宪章检查"或规则与更新的原则对齐。
   - 读取 `/templates/spec-template.md` 以对齐范围/要求 - 如果宪章添加/删除了强制性部分或约束则更新。
   - 读取 `/templates/tasks-template.md` 并确保任务分类反映新增或删除的原则驱动任务类型（例如，可观察性、版本控制、测试纪律）。
   - 读取 `/templates/commands/*.md` 中的每个命令文件（包括此文件）以验证没有过时的引用（仅当需要通用指导时保留特定代理名称如 CLAUDE）。
   - 读取任何运行时指导文档（例如，`README.md`, `docs/quickstart.md`，或特定代理指导文件（如果存在））。更新对更改原则的引用。

5. 生成同步影响报告（在更新后作为 HTML 注释预置在宪章文件顶部）：
   - 版本变更：旧 → 新
   - 修改的原则列表（旧标题 → 新标题如果重命名）
   - 添加的部分
   - 删除的部分
   - 需要更新的模板（✅ 已更新 / ⚠ 待处理）及文件路径
   - 如果有任何占位符故意推迟则列出。

6. 最终输出前的验证：
   - 没有剩余的未解释括号标记。
   - 版本行与报告匹配。
   - 日期为 ISO 格式 YYYY-MM-DD。
   - 原则是陈述性的、可测试的，并且没有模糊语言（"应该" → 在适当时替换为 MUST/SHOULD 理由）。

7. 将完成的宪章写回 `/memory/constitution.md`（覆盖）。

8. 向用户输出最终摘要：
   - 新版本和提升理由。
   - 任何标记为手动跟进的文件。
   - 建议的提交消息（例如，`docs: 修订宪章至 vX.Y.Z（原则添加 + 治理更新）`）。

格式和样式要求：

- 完全按照模板中的 Markdown 标题使用（不要降级/升级级别）。
- 包装长理由行以保持可读性（理想情况下 <100 个字符），但不要用尴尬的断行强制执行。
- 在部分之间保持单个空行。
- 避免尾随空格。

如果用户提供部分更新（例如，仅一个原则修订），仍执行验证和版本决策步骤。

如果关键信息缺失（例如，批准日期真正未知），插入 `TODO(<FIELD_NAME>): explanation` 并在同步影响报告的推迟项目下列出。

不要创建新模板；始终在现有的 `/memory/constitution.md` 文件上操作。