---
description: "功能实现的任务列表模板"
---

# 任务：[功能名称]

**输入**：来自 `/specs/[###-功能名称]/` 的设计文档
**先决条件**：plan.md（必需），spec.md（用户故事必需），research.md，data-model.md，contracts/

**测试**：下面的示例包含测试任务。测试是可选的 - 仅在功能规格中明确要求时才包含它们。

**组织**：任务按用户故事分组，以实现每个故事的独立实现和测试。

## 格式：`[ID] [P?] [故事] 描述`

- **[P]**：可以并行运行（不同文件，无依赖关系）
- **[故事]**：此任务属于哪个用户故事（例如，US1, US2, US3）
- 在描述中包含确切的文件路径

## 路径约定

- **单一项目**：`src/`, `tests/` 在仓库根目录
- **Web 应用**：`backend/src/`, `frontend/src/`
- **移动端**：`api/src/`, `ios/src/` 或 `android/src/`
- 下面显示的路径假设为单一项目 - 根据 plan.md 结构进行调整

<!-- 
  ============================================================================
  重要提示：下面的任务仅为示例任务，仅用于说明目的。
  
  /speckit.tasks 命令必须根据以下内容替换这些任务：
  - 来自 spec.md 的用户故事（及其优先级 P1, P2, P3...）
  - 来自 plan.md 的功能要求
  - 来自 data-model.md 的实体
  - 来自 contracts/ 的端点
  
  任务必须按用户故事组织，以便每个故事可以：
  - 独立实现
  - 独立测试
  - 作为 MVP 增量交付
  
  不要在生成的 tasks.md 文件中保留这些示例任务。
  ============================================================================
-->

## 阶段 1：设置（共享基础设施）

**目的**：项目初始化和基本结构

- [ ] T001 根据实现计划创建项目结构
- [ ] T002 使用 [框架] 依赖项初始化 [语言] 项目
- [ ] T003 [P] 配置代码检查和格式化工具

---

## 阶段 2：基础（阻塞先决条件）

**目的**：必须在任何用户故事实现之前完成的核心基础设施

**⚠️ 关键**：在本阶段完成之前，任何用户故事工作都不能开始

基础任务示例（根据您的项目进行调整）：

- [ ] T004 设置数据库模式和迁移框架
- [ ] T005 [P] 实现认证/授权框架
- [ ] T006 [P] 设置 API 路由和中间件结构
- [ ] T007 创建所有故事都依赖的基础模型/实体
- [ ] T008 配置错误处理和日志基础设施
- [ ] T009 设置环境配置管理

**检查点**：基础就绪 - 用户故事实现现在可以并行开始

---

## 阶段 3：用户故事 1 - [标题] (优先级: P1) 🎯 MVP

**目标**：[对此故事交付内容的简要描述]

**独立测试**：[如何验证此故事独立工作]

### 用户故事 1 的测试（可选 - 仅在要求测试时）⚠️

> **注意：首先编写这些测试，确保在实现之前它们失败**

- [ ] T010 [P] [US1] tests/contract/test_[name].py 中 [端点] 的契约测试
- [ ] T011 [P] [US1] tests/integration/test_[name].py 中 [用户旅程] 的集成测试

### 用户故事 1 的实现

- [ ] T012 [P] [US1] 在 src/models/[entity1].py 中创建 [Entity1] 模型
- [ ] T013 [P] [US1] 在 src/models/[entity2].py 中创建 [Entity2] 模型
- [ ] T014 [US1] 在 src/services/[service].py 中实现 [服务]（依赖于 T012, T013）
- [ ] T015 [US1] 在 src/[location]/[file].py 中实现 [端点/功能]
- [ ] T016 [US1] 添加验证和错误处理
- [ ] T017 [US1] 为用户故事 1 操作添加日志

**检查点**：此时，用户故事 1 应该完全功能化并可独立测试

---

## 阶段 4：用户故事 2 - [标题] (优先级: P2)

**目标**：[对此故事交付内容的简要描述]

**独立测试**：[如何验证此故事独立工作]

### 用户故事 2 的测试（可选 - 仅在要求测试时）⚠️

- [ ] T018 [P] [US2] tests/contract/test_[name].py 中 [端点] 的契约测试
- [ ] T019 [P] [US2] tests/integration/test_[name].py 中 [用户旅程] 的集成测试

### 用户故事 2 的实现

- [ ] T020 [P] [US2] 在 src/models/[entity].py 中创建 [实体] 模型
- [ ] T021 [US2] 在 src/services/[service].py 中实现 [服务]
- [ ] T022 [US2] 在 src/[location]/[file].py 中实现 [端点/功能]
- [ ] T023 [US2] 与用户故事 1 组件集成（如果需要）

**检查点**：此时，用户故事 1 和 2 都应该独立工作

---

## 阶段 5：用户故事 3 - [标题] (优先级: P3)

**目标**：[对此故事交付内容的简要描述]

**独立测试**：[如何验证此故事独立工作]

### 用户故事 3 的测试（可选 - 仅在要求测试时）⚠️

- [ ] T024 [P] [US3] tests/contract/test_[name].py 中 [端点] 的契约测试
- [ ] T025 [P] [US3] tests/integration/test_[name].py 中 [用户旅程] 的集成测试

### 用户故事 3 的实现

- [ ] T026 [P] [US3] 在 src/models/[entity].py 中创建 [实体] 模型
- [ ] T027 [US3] 在 src/services/[service].py 中实现 [服务]
- [ ] T028 [US3] 在 src/[location]/[file].py 中实现 [端点/功能]

**检查点**：所有用户故事现在都应该独立功能化

---

[根据需要添加更多用户故事阶段，遵循相同模式]

---

## 阶段 N：完善和跨领域关注点

**目的**：影响多个用户故事的改进

- [ ] TXXX [P] docs/ 中的文档更新
- [ ] TXXX 代码清理和重构
- [ ] TXXX 跨所有故事的性能优化
- [ ] TXXX [P] 附加单元测试（如果要求）在 tests/unit/ 中
- [ ] TXXX 安全加固
- [ ] TXXX 运行 quickstart.md 验证

---

## 依赖关系和执行顺序

### 阶段依赖关系

- **设置（阶段 1）**：无依赖关系 - 可立即开始
- **基础（阶段 2）**：依赖于设置完成 - 阻塞所有用户故事
- **用户故事（阶段 3+）**：都依赖于基础阶段完成
  - 用户故事然后可以并行进行（如果有人员）
  - 或按优先级顺序依次进行（P1 → P2 → P3）
- **完善（最终阶段）**：依赖于所有所需用户故事完成

### 用户故事依赖关系

- **用户故事 1 (P1)**：可在基础阶段完成后开始 - 无其他故事依赖
- **用户故事 2 (P2)**：可在基础阶段完成后开始 - 可能与 US1 集成但应独立可测试
- **用户故事 3 (P3)**：可在基础阶段完成后开始 - 可能与 US1/US2 集成但应独立可测试

### 每个用户故事内部

- 测试（如果包含）必须在实现之前编写并失败
- 模型在服务之前
- 服务在端点之前
- 核心实现在集成之前
- 故事完成后才进入下一个优先级

### 并行机会

- 所有标记为 [P] 的设置任务可以并行运行
- 所有标记为 [P] 的基础任务可以并行运行（在阶段 2 内）
- 一旦基础阶段完成，所有用户故事可以并行开始（如果团队容量允许）
- 标记为 [P] 的用户故事的所有测试可以并行运行
- 标记为 [P] 的故事内的模型可以并行运行
- 不同的用户故事可以由不同团队成员并行处理

---

## 并行示例：用户故事 1

```bash
# 一起启动用户故事 1 的所有测试（如果要求测试）：
任务："tests/contract/test_[name].py 中 [端点] 的契约测试"
任务："tests/integration/test_[name].py 中 [用户旅程] 的集成测试"

# 一起启动用户故事 1 的所有模型：
任务："在 src/models/[entity1].py 中创建 [Entity1] 模型"
任务："在 src/models/[entity2].py 中创建 [Entity2] 模型"
```

---

## 实现策略

### MVP 优先（仅用户故事 1）

1. 完成阶段 1：设置
2. 完成阶段 2：基础（关键 - 阻塞所有故事）
3. 完成阶段 3：用户故事 1
4. **停止并验证**：独立测试用户故事 1
5. 如果准备就绪则部署/演示

### 增量交付

1. 完成设置 + 基础 → 基础就绪
2. 添加用户故事 1 → 独立测试 → 部署/演示（MVP！）
3. 添加用户故事 2 → 独立测试 → 部署/演示
4. 添加用户故事 3 → 独立测试 → 部署/演示
5. 每个故事在不破坏之前故事的情况下增加价值

### 并行团队策略

多个开发人员时：

1. 团队一起完成设置 + 基础
2. 一旦基础完成：
   - 开发人员 A：用户故事 1
   - 开发人员 B：用户故事 2
   - 开发人员 C：用户故事 3
3. 故事独立完成和集成

---

## 备注

- [P] 任务 = 不同文件，无依赖关系
- [故事] 标签将任务映射到特定用户故事以实现可追溯性
- 每个用户故事应该是独立可完成和可测试的
- 在实现之前验证测试失败
- 每个任务或逻辑组之后提交
- 在任何检查点停止以独立验证故事
- 避免：模糊任务、相同文件冲突、破坏独立性的跨故事依赖