# 上下文加载顺序和优先级

## 必需文档 (最高优先级)
1. **tasks.md** - 完整的任务列表和执行计划
   - 包含所有实施步骤
   - 定义依赖关系和执行顺序
   - 指定阶段划分

2. **plan.md** - 技术栈、架构和文件结构
   - 技术选型和架构决策
   - 项目结构和组织方式
   - 开发规范和标准

## 条件文档 (如果存在)

### 数据模型 (如果存在)
3. **data-model.md** - 实体和关系
   - 数据库模式设计
   - 实体关系图
   - 数据验证规则

### API 规范 (如果存在)
4. **contracts/** - API 规范和测试要求
   - 端点定义
   - 请求/响应模式
   - 验证和错误处理

### 研究文档 (如果存在)
5. **research.md** - 技术决策和约束
   - 技术调研结果
   - 性能要求
   - 安全考虑

### 快速开始 (如果存在)
6. **quickstart.md** - 集成场景
   - 使用示例
   - 部署配置
   - 环境要求

## 加载策略

### 错误处理
- 如果必需文档缺失，立即停止并提示
- 如果条件文档缺失，记录但继续执行

### 优先级原则
1. 先加载任务计划，了解实施步骤
2. 再加载技术规划，理解架构约束
3. 最后加载补充信息，完善实施细节

### 依赖分析
- 分析文档间的依赖关系
- 识别可能的冲突或矛盾
- 提供解决建议

## 文档完整性检查

### 必需验证
```markdown
- [ ] tasks.md 存在且格式正确
- [ ] plan.md 存在且内容完整
- [ ] 文档间信息一致
- [ ] 依赖关系明确
```

### 可选验证
```markdown
- [ ] data-model.md 与 tasks.md 一致
- [ ] contracts/ 与 plan.md 架构匹配
- [ ] research.md 决策已实施
- [ ] quickstart.md 场景可执行
```