# 实施工作流参考

## 任务阶段
实施通常分为以下几个阶段：

1. **Setup** - 项目初始化和配置
2. **Tests** - 测试设置和测试用例编写
3. **Core** - 核心功能实现
4. **Integration** - 集成和中间件
5. **Polish** - 优化和完善

## 任务执行规则

### 依赖关系处理
- **顺序任务**: 必须按定义顺序执行
- **并行任务 [P]**: 可以同时执行，但不影响相同文件的任务必须保持顺序

### TDD 方法
- 测试任务优先于对应的实现任务
- 先写测试，再写实现代码

### 文件协调
- 影响相同文件的任务必须按顺序执行
- 避免并发修改冲突

### 验证检查点
- 每个阶段完成后进行验证
- 确保质量标准满足要求

## 错误处理

### 非并行任务失败
- 立即停止执行
- 提供详细错误信息
- 建议修复步骤

### 并行任务失败
- 继续执行成功的任务
- 记录失败的任务
- 汇总所有错误信息

## 进度跟踪

### 任务标记
- 使用 `[X]` 标记已完成的任务
- 保持任务文件同步更新

### 状态报告
- 每个任务完成后报告进度
- 提供清晰的状态概览
- 包含下一步建议

## 完成验证

### 必需检查
- [ ] 所有必需任务已完成
- [ ] 实现功能与原始规范匹配
- [ ] 测试通过且覆盖率达到要求
- [ ] 实现遵循技术计划

### 最终报告
- 提供完成工作的详细摘要
- 列出所有实现的功能
- 说明任何偏离或调整
- 提供维护和扩展建议