---
name: speckit-tasks-zh
description: 基于speckit工作流的任务生成技能，用于根据可用设计文档生成可操作的、依赖有序的tasks.md。当需要基于spec.md、plan.md、data-model.md、contracts/等设计文档为功能开发生成详细任务列表时使用此技能。触发词包括"speckit tasks"、"生成任务"、"任务规划"、"功能任务分解"、"创建tasks.md"等。
---

## 用户输入

```text
$ARGUMENTS
```

您**必须**在继续之前考虑用户输入（如果不为空）。

## 大纲

scripts:
  sh: .specify/scripts/bash/check-prerequisites.sh --json
  ps: .specify/scripts/powershell/check-prerequisites.ps1 -Json

1. **设置**：从仓库根目录运行 `{SCRIPT}` 并解析 FEATURE_DIR 和 AVAILABLE_DOCS 列表。所有路径必须是绝对的。对于参数中的单引号，如 "I'm Groot"，使用转义语法：例如 'I'\''m Groot'（或者如果可能的话使用双引号："I'm Groot"）。

2. **加载设计文档**：从 FEATURE_DIR 读取：
   - **必需**：plan.md（技术栈、库、结构），spec.md（带优先级的用户故事）
   - **可选**：data-model.md（实体），contracts/（API 端点），research.md（决策），quickstart.md（测试场景）
   - 注意：并非所有项目都有所有文档。根据可用内容生成任务。

3. **执行任务生成工作流程**：
   - 加载 plan.md 并提取技术栈、库、项目结构
   - 加载 spec.md 并提取带优先级的用户故事（P1, P2, P3 等）
   - 如果存在 data-model.md：提取实体并映射到用户故事
   - 如果存在 contracts/：将端点映射到用户故事
   - 如果存在 research.md：提取决策用于设置任务
   - 生成按用户故事组织的任务（参见下面的任务生成规则）
   - 生成依赖图显示用户故事完成顺序
   - 为每个用户故事创建并行执行示例
   - 验证任务完整性（每个用户故事都有所需任务，可独立测试）

4. **生成 tasks.md**：使用 `.specify/templates/tasks-template.md` 作为结构，填充：
   - 从 plan.md 获取正确的功能名称
   - 阶段 1：设置任务（项目初始化）
   - 阶段 2：基础任务（所有用户故事的阻塞先决条件）
   - 阶段 3+：按 spec.md 中的优先级顺序排列的每个用户故事一个阶段
   - 每个阶段包括：故事目标、独立测试标准、测试（如果要求）、实现任务
   - 最终阶段：完善和跨领域关注点
   - 所有任务必须遵循严格的检查表格式（参见下面的任务生成规则）
   - 每个任务的明确文件路径
   - 依赖关系部分显示故事完成顺序
   - 每个故事的并行执行示例
   - 实现策略部分（MVP 优先、增量交付）

5. **报告**：输出生成的 tasks.md 路径和摘要：
   - 总任务数
   - 每个用户故事的任务数
   - 识别的并行机会
   - 每个故事的独立测试标准
   - 建议的 MVP 范围（通常仅为用户故事 1）
   - 格式验证：确认所有任务都遵循检查表格式（复选框、ID、标签、文件路径）

为任务生成提供上下文：{ARGS}

tasks.md 应该是立即可执行的 - 每个任务必须足够具体，以便 LLM 可以在没有额外上下文的情况下完成它。

## 任务生成规则

**关键**：任务必须按用户故事组织，以实现独立实现和测试。

**测试是可选的**：仅在功能规格中明确要求或用户要求 TDD 方法时才生成测试任务。

### 检查表格式（必需）

每个任务必须严格遵循此格式：

```text
- [ ] [任务ID] [P?] [故事?] 带文件路径的描述
```

**格式组件**：

1. **复选框**：始终以 `- [ ]` 开头（markdown 复选框）
2. **任务 ID**：按执行顺序的序列号（T001, T002, T003...）
3. **[P] 标记**：仅当任务可并行化时包含（不同文件，不依赖未完成任务）
4. **[故事] 标签**：仅用户故事阶段任务必需
   - 格式：[US1], [US2], [US3], 等（映射到 spec.md 中的用户故事）
   - 设置阶段：无故事标签
   - 基础阶段：无故事标签  
   - 用户故事阶段：必须有故事标签
   - 完善阶段：无故事标签
5. **描述**：带确切文件路径的明确操作

**示例**：

- ✅ 正确：`- [ ] T001 根据实现计划创建项目结构`
- ✅ 正确：`- [ ] T005 [P] 在 src/middleware/auth.py 中实现认证中间件`
- ✅ 正确：`- [ ] T012 [P] [US1] 在 src/models/user.py 中创建用户模型`
- ✅ 正确：`- [ ] T014 [US1] 在 src/services/user_service.py 中实现 UserService`
- ❌ 错误：`- [ ] 创建用户模型`（缺少 ID 和故事标签）
- ❌ 错误：`T001 [US1] 创建模型`（缺少复选框）
- ❌ 错误：`- [ ] [US1] 创建用户模型`（缺少任务 ID）
- ❌ 错误：`- [ ] T001 [US1] 创建模型`（缺少文件路径）

### 任务组织

1. **来自用户故事（spec.md）** - 主要组织：
   - 每个用户故事（P1, P2, P3...）都有自己的阶段
   - 将所有相关组件映射到它们的故事：
     - 该故事需要的模型
     - 该故事需要的服务
     - 该故事需要的端点/UI
     - 如果要求测试：该故事的特定测试
   - 标记故事依赖关系（大多数故事应该是独立的）

2. **来自契约**：
   - 将每个契约/端点 → 映射到它服务的用户故事
   - 如果要求测试：每个契约 → 在该故事阶段实现前的契约测试任务 [P]

3. **来自数据模型**：
   - 将每个实体映射到需要它的用户故事
   - 如果实体服务于多个故事：放在最早的故事或设置阶段
   - 关系 → 在适当的故事阶段中的服务层任务

4. **来自设置/基础设施**：
   - 共享基础设施 → 设置阶段（阶段 1）
   - 基础/阻塞任务 → 基础阶段（阶段 2）
   - 故事特定设置 → 在该故事的阶段内

### 阶段结构

- **阶段 1**：设置（项目初始化）
- **阶段 2**：基础（阻塞先决条件 - 必须在用户故事前完成）
- **阶段 3+**：按优先级顺序的用户故事（P1, P2, P3...）
  - 在每个故事内：测试（如果要求）→ 模型 → 服务 → 端点 → 集成
  - 每个阶段应该是一个完整的、可独立测试的增量
- **最终阶段**：完善和跨领域关注点

