# 任务格式示例与规范

## 检查表格式（必需）

每个任务必须严格遵循此格式：

```markdown
- [ ] [TaskID] [P?] [Story?] 描述与文件路径
```

## 格式组件详解

1. **复选框**: 始终以 `- [ ]` 开始（markdown复选框）
2. **任务ID**: 顺序编号（T001、T002、T003...）按执行顺序
3. **[P]标记**: 仅在任务可并行时包含（不同文件，无未完成任务的依赖）
4. **[Story]标签**: 仅用户故事阶段任务必需
   - 格式: [US1]、[US2]、[US3]等（映射自spec.md的用户故事）
   - 设置阶段: 无故事标签
   - 基础阶段: 无故事标签
   - 用户故事阶段: 必须有故事标签
   - 完善阶段: 无故事标签
5. **描述**: 包含确切文件路径的清晰操作

## 正确示例

- ✅ 正确: `- [ ] T001 按实施计划创建项目结构`
- ✅ 正确: `- [ ] T005 [P] 在src/middleware/auth.py中实现认证中间件`
- ✅ 正确: `- [ ] T012 [P] [US1] 在src/models/user.py中创建User模型`
- ✅ 正确: `- [ ] T014 [US1] 在src/services/user_service.py中实现UserService`

## 错误示例

- ❌ 错误: `- [ ] 创建User模型`（缺少ID和Story标签）
- ❌ 错误: `T001 [US1] 创建模型`（缺少复选框）
- ❌ 错误: `- [ ] [US1] 创建User模型`（缺少TaskID）
- ❌ 错误: `- [ ] T001 [US1] 创建模型`（缺少文件路径）

## 任务组织原则

### 1. 从用户故事出发（spec.md）- 主要组织方式

每个用户故事（P1、P2、P3...）获得自己的阶段：
- 将所有相关组件映射到其故事：
  - 该故事所需的模型
  - 该故事所需的服务
  - 该故事所需的端点/UI
  - 如果需要测试: 特定于该故事的测试
- 标记故事依赖关系（大多数故事应该是独立的）

### 2. 从合同/端点出发

- 将每个合同/端点映射到其服务的用户故事
- 如果需要测试: 每个合同 → 在该故事阶段中实施前的合同测试任务[P]

### 3. 从数据模型出发

- 将每个实体映射到需要它的用户故事
- 如果实体服务多个故事: 放入最早的故事或设置阶段
- 关系 → 相应故事阶段中的服务层任务

### 4. 从设置/基础设施出发

- 共享基础设施 → 设置阶段（阶段1）
- 基础/阻塞任务 → 基础阶段（阶段2）
- 故事特定设置 → 在该故事的阶段内

## 阶段结构

- **阶段1**: 设置（项目初始化）
- **阶段2**: 基础（阻塞先决条件 - 必须在用户故事前完成）
- **阶段3+**: 用户故事按优先级（P1、P2、P3...）
  - 在每个故事内: 测试（如果需要）→ 模型 → 服务 → 端点 → 集成
  - 每个阶段应该是一个完整的、可独立测试的增量
- **最终阶段**: 完善和横切关注点

## 测试任务指南

**测试是可选的**: 仅在功能规格中明确要求或用户要求TDD方法时生成测试任务。

当需要测试时：
- 为每个用户故事创建独立的测试标准
- 确保测试可以独立运行
- 在实施任务前包含测试设置任务