# Speckit Tasks 工作流详细指南

## 工作流概述

本工作流用于根据可用设计文档生成可操作的、依赖有序的tasks.md。

## 详细步骤

### 1. 设置阶段

运行环境检查脚本：
```powershell
.speckit/scripts/powershell/check-prerequisites.ps1 -Json
```

**重要注意事项**：
- 所有路径必须是绝对路径
- 对于参数中的单引号，使用转义语法：例如 `I'm Groot` 应写为 `'I'\''m Groot'`
- 或者尽可能使用双引号：`"I'm Groot"`

### 2. 文档加载阶段

从FEATURE_DIR读取以下文档：

#### 必需文档
- **plan.md**: 技术栈、库、项目结构
- **spec.md**: 带优先级的用户故事

#### 可选文档
- **data-model.md**: 实体定义
- **contracts/**: API端点定义
- **research.md**: 技术决策
- **quickstart.md**: 测试场景

**注意**: 并非所有项目都有所有文档，基于可用内容生成任务。

### 3. 任务生成工作流执行

#### 文档解析步骤

1. **加载plan.md**并提取：
   - 技术栈
   - 库依赖
   - 项目结构

2. **加载spec.md**并提取：
   - 用户故事及其优先级（P1、P2、P3等）

3. **可选文档处理**：
   - 如果data-model.md存在：提取实体并映射到用户故事
   - 如果contracts/存在：映射端点到用户故事
   - 如果research.md存在：提取决策用于设置任务

#### 任务组织生成

1. **按用户故事组织任务**（参见任务生成规则）
2. **生成依赖关系图**显示用户故事完成顺序
3. **创建并行执行示例**（每个用户故事）
4. **验证任务完整性**（每个用户故事都有所需任务，可独立测试）

### 4. tasks.md生成

使用模板结构填充以下内容：

- 正确的功能名称（来自plan.md）
- 阶段1: 设置任务（项目初始化）
- 阶段2: 基础任务（所有用户故事的阻塞先决条件）
- 阶段3+: 每个用户故事一个阶段（按spec.md中的优先级顺序）
- 每个阶段包含：
  - 故事目标
  - 独立测试标准
  - 测试（如果需要）
  - 实施任务
- 最终阶段: 完善和横切关注点
- 所有任务必须遵循严格的检查表格式
- 每个任务的清晰文件路径
- 显示故事完成顺序的依赖关系部分
- 每个故事的并行执行示例
- 实施策略部分（MVP优先，增量交付）

### 5. 报告生成

输出以下内容的摘要：
- 生成的tasks.md路径
- 总任务数量
- 每个用户故事的任务数量
- 识别的并行机会
- 每个故事的独立测试标准
- 建议的MVP范围（通常仅为用户故事1）
- 格式验证：确认所有任务都遵循检查表格式（复选框、ID、标签、文件路径）

## 质量要求

- tasks.md应立即可执行 - 每个任务必须足够具体，使LLM无需额外上下文即可完成
- 确保任务间的依赖关系清晰明确
- 验证每个用户故事的独立可测试性