#Requires -Version 5.1
<#
.SYNOPSIS
    {{DESCRIPTION}}

.DESCRIPTION
    {{SCRIPT_NAME}} - Generated CLI from {{SOURCE_TYPE}}:{{SOURCE_NAME}}

    This script provides a command-line interface for the functionality
    originally implemented as a Claude Code {{SOURCE_TYPE}}.

.PARAMETER Command
    The command to execute: run, list, get, help, version

.PARAMETER Arguments
    Additional arguments passed to the command

.PARAMETER OutputFormat
    Output format: json (default) or text

.PARAMETER Quiet
    Suppress non-essential output

.PARAMETER Verbose
    Enable verbose/debug output

.EXAMPLE
    .\{{SCRIPT_NAME}}.ps1 run
    Execute the main operation

.EXAMPLE
    .\{{SCRIPT_NAME}}.ps1 list
    List all resources

.EXAMPLE
    .\{{SCRIPT_NAME}}.ps1 get abc123
    Get a specific resource

.EXAMPLE
    .\{{SCRIPT_NAME}}.ps1 list | ConvertFrom-Json | Select-Object name
    Parse output and select specific fields

.NOTES
    Generated by: cli-ifying skill
    Source: {{SOURCE_TYPE}}:{{SOURCE_NAME}}
    Version: 1.0.0
#>

[CmdletBinding()]
param(
    [Parameter(Position = 0)]
    [ValidateSet('run', 'list', 'get', 'help', 'version')]
    [string]$Command = 'help',

    [Parameter(Position = 1, ValueFromRemainingArguments = $true)]
    [string[]]$Arguments = @(),

    [Parameter()]
    [ValidateSet('json', 'text')]
    [Alias('o')]
    [string]$OutputFormat = 'json',

    [Parameter()]
    [Alias('q')]
    [switch]$Quiet,

    [Parameter()]
    [Alias('v')]
    [switch]$VerboseOutput
)

# ============================================================
# Script Configuration
# ============================================================

$Script:Version = "1.0.0"
$Script:ScriptName = "{{SCRIPT_NAME}}"

# Configuration from environment with defaults
$Script:Config = @{
    OutputFormat = $env:OUTPUT_FORMAT ?? $OutputFormat
    Verbose = $VerboseOutput -or ($env:VERBOSE -eq 'true')
    Quiet = $Quiet -or ($env:QUIET -eq 'true')
}

# Required environment variables (uncomment and customize)
# if (-not $env:API_KEY) {
#     Write-Error "API_KEY environment variable required"
#     exit 3
# }

# ============================================================
# Logging & Output Helpers
# ============================================================

function Write-ErrorLog {
    param([string]$Message)
    Write-Host "ERROR: $Message" -ForegroundColor Red
}

function Write-WarnLog {
    param([string]$Message)
    Write-Host "WARN: $Message" -ForegroundColor Yellow
}

function Write-InfoLog {
    param([string]$Message)
    if (-not $Script:Config.Quiet) {
        Write-Host "INFO: $Message" -ForegroundColor Cyan
    }
}

function Write-DebugLog {
    param([string]$Message)
    if ($Script:Config.Verbose) {
        Write-Host "DEBUG: $Message" -ForegroundColor Gray
    }
}

function Format-Output {
    param(
        [Parameter(Mandatory = $true)]
        $Data
    )

    switch ($Script:Config.OutputFormat) {
        'json' {
            if ($Data -is [string]) {
                $Data
            } else {
                $Data | ConvertTo-Json -Depth 10 -Compress:$false
            }
        }
        'text' {
            if ($Data -is [string]) {
                $Data | ConvertFrom-Json | Format-Table -AutoSize | Out-String
            } else {
                $Data | Format-Table -AutoSize | Out-String
            }
        }
        default {
            $Data | ConvertTo-Json -Depth 10
        }
    }
}

# ============================================================
# Help & Version
# ============================================================

function Show-Version {
    Write-Output "$($Script:ScriptName) version $($Script:Version)"
}

function Show-Help {
    @"
$($Script:ScriptName) - {{DESCRIPTION}}

USAGE:
    .\$($Script:ScriptName).ps1 <command> [options] [arguments]

COMMANDS:
    run                 Execute the main operation
    list                List resources
    get <id>            Get a specific resource
    help                Show this help message
    version             Show version information

OPTIONS:
    -OutputFormat, -o   Output format: json (default) | text
    -Quiet, -q          Suppress non-essential output
    -VerboseOutput, -v  Enable verbose/debug output
    -Help               Show this help message

ENVIRONMENT VARIABLES:
    OUTPUT_FORMAT       Default output format (json)
    VERBOSE             Enable verbose mode (true/false)
    QUIET               Enable quiet mode (true/false)

EXAMPLES:
    # Run the main operation
    .\$($Script:ScriptName).ps1 run

    # List resources as JSON
    .\$($Script:ScriptName).ps1 list

    # Get specific resource
    .\$($Script:ScriptName).ps1 get abc123

    # Parse output with PowerShell
    .\$($Script:ScriptName).ps1 list | ConvertFrom-Json | Select-Object -First 1 | Select-Object id

    # Text output for humans
    .\$($Script:ScriptName).ps1 list -OutputFormat text

EXIT CODES:
    0   Success
    1   General error
    2   Invalid arguments / usage error
    3   Missing dependencies
    4   Network/API error
    5   Permission denied

NOTES:
    Generated from {{SOURCE_TYPE}}:{{SOURCE_NAME}}
    See: ~\.claude\skills\cli-ifying\
"@
}

# ============================================================
# Dependency Checks
# ============================================================

function Test-Dependencies {
    $missing = @()

    # Add required commands/modules here
    $commands = @(
        # "git"
        # "gh"
    )

    foreach ($cmd in $commands) {
        if (-not (Get-Command $cmd -ErrorAction SilentlyContinue)) {
            $missing += $cmd
        }
    }

    # Check for required PowerShell modules
    $modules = @(
        # "Az"
        # "PSReadLine"
    )

    foreach ($mod in $modules) {
        if (-not (Get-Module -ListAvailable -Name $mod)) {
            $missing += "Module: $mod"
        }
    }

    if ($missing.Count -gt 0) {
        Write-ErrorLog "Missing required dependencies: $($missing -join ', ')"
        Write-ErrorLog "Please install them and try again."
        exit 3
    }
}

# ============================================================
# Command Implementations
# ============================================================

function Invoke-Run {
    Write-InfoLog "Running main operation..."

    # {{TODO: Implement main operation}}
    # Example:
    # $headers = @{ Authorization = "Bearer $env:API_KEY" }
    # $result = Invoke-RestMethod -Uri "https://api.example.com/action" -Headers $headers -Method Post
    # Format-Output $result

    $result = @{
        status = "success"
        message = "Operation completed"
    }
    Format-Output $result
}

function Invoke-List {
    Write-InfoLog "Listing resources..."

    # {{TODO: Implement list operation}}
    # Example:
    # $headers = @{ Authorization = "Bearer $env:API_KEY" }
    # $result = Invoke-RestMethod -Uri "https://api.example.com/items" -Headers $headers
    # Format-Output $result

    $result = @()
    Format-Output $result
}

function Invoke-Get {
    param(
        [Parameter(Mandatory = $false)]
        [string]$Id
    )

    if ([string]::IsNullOrWhiteSpace($Id)) {
        Write-ErrorLog "ID argument required"
        Write-Output "Usage: .\$($Script:ScriptName).ps1 get <id>"
        exit 2
    }

    Write-InfoLog "Getting resource: $Id"

    # {{TODO: Implement get operation}}
    # Example:
    # $headers = @{ Authorization = "Bearer $env:API_KEY" }
    # $result = Invoke-RestMethod -Uri "https://api.example.com/items/$Id" -Headers $headers
    # Format-Output $result

    $result = @{
        id = $Id
        found = $false
    }
    Format-Output $result
}

# ============================================================
# Main Entry Point
# ============================================================

function Main {
    # Check dependencies for most commands
    switch ($Command) {
        { $_ -in @('help', 'version') } {
            # No dependency check needed
        }
        default {
            Test-Dependencies
        }
    }

    # Dispatch to command handler
    switch ($Command) {
        'run' {
            Invoke-Run
        }
        'list' {
            Invoke-List
        }
        'get' {
            $id = if ($Arguments.Count -gt 0) { $Arguments[0] } else { $null }
            Invoke-Get -Id $id
        }
        'help' {
            Show-Help
        }
        'version' {
            Show-Version
        }
        default {
            Write-ErrorLog "Unknown command: $Command"
            Write-Output "Run '.\$($Script:ScriptName).ps1 help' for usage information."
            exit 2
        }
    }
}

# Run main
try {
    Main
}
catch {
    Write-ErrorLog $_.Exception.Message
    if ($Script:Config.Verbose) {
        Write-ErrorLog $_.ScriptStackTrace
    }
    exit 1
}
