# 中文推荐语表达规范

## 核心原则

### 自然流畅
- 使用符合中文阅读习惯的表达方式
- 避免生硬的翻译腔
- 句式多样，避免单调重复

### 精准简洁
- 每个字都有价值
- 删除冗余修饰
- 用词准确，避免模糊

### 信息密度
- 在有限字数内传达最多价值
- 突出核心信息
- 次要信息适当省略

## 常见问题与改进

### 1. 翻译腔问题

**问题**: 直接照搬英文句式结构
```
✗ 这个工具提供了一个全面的解决方案对于开发者来说
✓ 这个工具为开发者提供了全面的解决方案
```

**问题**: 被动语态过度使用
```
✗ 一个新的框架被提出用于解决这个问题
✓ 作者提出了一个新框架来解决这个问题
```

### 2. 口语化过度

**问题**: 使用过多的口语化表达
```
✗ 那么，让我们来看看这篇文章到底讲了啥
✓ 文章主要探讨了...
```

**问题**: 不必要的过渡词
```
✗ 首先，文章介绍了 X。然后，作者讨论了 Y。最后，总结了 Z
✓ 文章介绍了 X，讨论了 Y，并总结了 Z
```

### 3. 标点符号使用

**必须使用全形（全角）中文标点**:

中文推荐语中必须使用全形中文标点符号，不能使用半形（半角）英文标点。

正确的全形标点：
- 句号：`。` (不是半角的 `.`)
- 逗号：`，` (不是半角的 `,`)
- 顿号：`、` (用于中文并列词语，不要用 `,`)
- 分号：`；` (不是半角的 `;`)
- 冒号：`：` (不是半角的 `:`)
- 问号：`？` (不是半角的 `?`)
- 感叹号：`！` (不是半角的 `!`)
- 引号：`""` 或 `「」` (不是半角的 `""`)
- 单引号：`''` 或 `『』` (不是半角的 `''`)
- 书名号：`《》` (书籍、文章标题)
- 破折号：`——` (占两个汉字位置，不是 `--`)
- 省略号：`……` (占两个汉字位置，不是 `...`)

**错误示例** (使用了英文半角标点):
```
✗ 这篇文章介绍了API设计的核心原则,包括一致性、简洁性和可扩展性.
✗ GitHub团队发布了新功能!开发者可以更方便地进行代码审查了.
✗ 文章探讨了三个问题:性能优化、代码质量、团队协作.
```

**正确示例** (使用了中文全角标点):
```
✓ 这篇文章介绍了 API 设计的核心原则，包括一致性、简洁性和可扩展性。
✓ GitHub 团队发布了新功能！开发者可以更方便地进行代码审查了。
✓ 文章探讨了三个问题：性能优化、代码质量、团队协作。
```

**英文内容使用半形标点**:

当中文句子中包含完整的英文句子、英文书名、技术术语内部时，这些英文内容内部使用半形英文标点：

```
✓ 作者引用了那句名言「Stay hungry, stay foolish.」
✓ 推荐阅读 *Hackers & Painters: Big Ideas from the Computer Age*
✓ 使用 React.useEffect() 可以处理副作用
```

**不要重复使用标点符号**:

避免连续使用多个标点符号，这会破坏句子的美观性：

```
✗ 这个功能太强大了！！！
✗ 真的吗？？
✗ 这是什么原理？！？！

✓ 这个功能太强大了！
✓ 真的吗？
✓ 这是什么原理？
```

### 4. 空格使用规范

**中英文之间需要增加空格**:
```
✗ GitHub官方发布的Copilot代码审查指南
✗ 在LeanCloud上，数据存储是围绕AVObject进行的
✓ GitHub 官方发布的 Copilot 代码审查指南
✓ 在 LeanCloud 上，数据存储是围绕 AVObject 进行的
```

**中文与数字之间需要增加空格**:
```
✗ 今天出去买菜花了5000元
✗ 性能提升了50%以上
✓ 今天出去买菜花了 5000 元
✓ 性能提升了 50% 以上
```

**英文/数字与中文之间需要增加空格**:
```
✗ 支持Python、JavaScript和TypeScript等语言
✓ 支持 Python、JavaScript 和 TypeScript 等语言
```

**数字与单位之间需要增加空格**:
```
✗ 光纤入屋宽频有 10Gbps，SSD 一共有 20TB
✓ 光纤入屋宽频有 10 Gbps，SSD 一共有 20 TB
```

例外：度数/百分比与数字之间不需要增加空格：
```
✓ 角度为 90° 的角
✓ 新 MacBook Pro 有 15% 的 CPU 性能提升

✗ 角度为 90 ° 的角
✗ 新 MacBook Pro 有 15 % 的 CPU 性能提升
```

**全形标点与其他字符之间不加空格**:

全形中文标点符号前后不需要添加空格：

```
✗ 刚刚买了一部 iPhone ，好开心 ！
✗ 刚刚买了一部 iPhone， 好开心！
✓ 刚刚买了一部 iPhone，好开心！

✗ 文章探讨了三个问题 ：性能优化 、代码质量 、团队协作 。
✓ 文章探讨了三个问题：性能优化、代码质量、团队协作。
```

**中文词语之间不加空格**:
```
✗ 这是 一个 很好的 工具
✓ 这是一个很好的工具
```

### 5. 修饰词使用

**过度修饰**:
```
✗ 这是一个非常非常重要的、极其关键的、绝对不可或缺的工具
✓ 这是一个关键的开发工具
```

**空洞修饰**:
```
✗ 这篇文章写得很好，内容很丰富，值得一读
✓ 文章系统介绍了 X 技术的核心原理和实践案例
```

### 6. 专业术语处理

**保持英文原词**:
- API、SDK、CLI 等约定俗成的缩写
- GitHub、TypeScript 等专有名词
- 无对应中文或中文使用较少的技术术语

**使用中文译名**:
- 有广泛认可中文译名的概念
- 示例: 机器学习 (machine learning)、数据库 (database)

**混合使用**:
```
✓ React 组件库
✓ API 接口设计
✓ 持续集成 (CI) 流程
```

## 版本差异化策略

### 版本一：推荐版本
**特点**:
- 完整但不冗长
- 客观呈现价值
- 结构完整: 引入→核心内容→价值总结

**句式结构**:
```
[主题定位] + [核心内容概述] + [关键亮点] + [适用场景/目标读者]
```

**示例**:
```
GitHub 官方发布的 Copilot 代码审查指令文件实战指南。文章针对开发者
在使用自定义指令时遇到的常见困惑，提供了系统的解决方案：如何让 
Copilot 准确理解并执行你的审查规则。作者从实际案例出发，总结了指令
编写的核心原则：保持简洁、结构化组织、使用命令式语句、提供代码示例。
```

### 版本二：精炼简洁版本
**特点**:
- 去掉所有非核心信息
- 每句话都是关键点
- 适合快速扫描

**句式结构**:
```
[核心主题] + [关键方法/内容] + [直接价值]
```

**示例**:
```
GitHub 团队总结的 Copilot 代码审查指令编写最佳实践。文章直击痛点：
为什么 Copilot 不按指令执行？核心建议包括保持简洁、结构化组织、
使用命令式语句，并提供可直接使用的模板和示例。
```

### 版本三：个人评论版本
**特点**:
- 客观直接的批判性分析
- 指出潜在不足和需要思考的问题
- 提出值得讨论的疑问
- 更具个人色彩但保持专业
- 可以提出建设性的保留意见

**句式结构**:
```
[个人观察/引入] + [内容概述] + [客观批判性分析] + [建设性建议/讨论点]
```

**批判性分析要点**:
- 基于客观分析，不是个人偏好
- 具体指出缺失或有疑问的地方
- 提出值得进一步思考的问题
- 指出假设可能不成立的场景
- 平衡认可价值与指出局限

**示例**:
```
这篇文章来得正是时候。Copilot 代码审查推出后，很多团队兴冲冲地写了
一堆指令文件，结果发现 AI 根本不按套路出牌。GitHub 这次算是把话说清楚了：
AI 不是人，它需要的是结构化的短指令，而不是你写给人看的长篇规范文档。

文章最有价值的地方是那份模板和不支持指令类型清单。特别是明确告诉你
别想着让 Copilot 改界面样式、别放外部链接、别写"更准确一点"这种模糊要求。
这些都是踩过坑的经验总结。

不过说实话，文章透露出一个信号：Copilot 代码审查还不够成熟，需要开发者
花精力去"调教"它。对于小团队来说，投入产出比需要好好算算。但如果你
已经在用，这篇文章能帮你少走很多弯路。
```

**批判性表达模板**:
- "文章的分析很全面，但有几个现实问题没有深入讨论..."
- "这个方案看起来很理想，但实际应用中可能面临..."
- "作者的观点有道理，但忽略了一个关键问题..."
- "值得注意的是，文章基于的假设在某些场景下可能不成立..."
- "美中不足的是..."
- "需要警惕的是..."
- "这里存在一个权衡..."

## 常用表达模板

### 文章类型引导词
- 实战指南、深度解析、技术分析、案例研究
- 官方发布、团队总结、作者分享
- 系统介绍、详细阐述、全面剖析

### 价值描述
- 提供了系统的解决方案
- 总结了核心原则
- 揭示了底层逻辑
- 提炼出完整的方法论
- 给出了可落地的实践方案

### 适用场景
- 对于...的开发团队来说
- 如果你正在...
- 希望...的读者
- 适合...的场景

### 评价用词 (谨慎使用)
**积极但克制**:
- 不可多得、值得关注、很有参考价值
- 系统完整、详实具体、实用性强

**避免夸张**:
- ✗ 史上最强、空前绝后、颠覆性的
- ✗ 必读、神作、宝典

## 质量自检清单

### 标点符号检查
- [ ] 所有中文标点都使用全形符号（。，、；：？！）
- [ ] 没有使用英文半角标点（.,;:?!）
- [ ] 引号使用正确（"" 或「」，不是 ""）
- [ ] 没有重复使用标点符号（避免！！！或？？）
- [ ] 全形标点前后没有多余空格

### 空格使用检查
- [ ] 中英文之间有空格
- [ ] 中文与数字之间有空格
- [ ] 数字与单位之间有空格（除了度数/百分比）
- [ ] 全形标点与其他字符之间没有空格
- [ ] 中文词语之间没有多余空格

### 内容质量检查
- [ ] 没有冗余修饰词
- [ ] 没有过度使用引号和括号
- [ ] 表达自然流畅，无翻译腔
- [ ] 信息准确，基于原文
- [ ] 结构清晰，逻辑顺畅
- [ ] 版本间有明确差异化
- [ ] 字数符合要求
- [ ] 无 Markdown 渲染问题
