# English Recommendation Writing Standards

## Core Principles

### Natural and Idiomatic
- Use expressions native English speakers would naturally use
- Avoid overly academic or stilted language
- Vary sentence structure for readability

### Concise and Precise
- Every word should add value
- Remove redundant qualifiers
- Use specific rather than vague language

### Professional Yet Accessible
- Technical accuracy without jargon overload
- Clear explanation without condescension
- Engaging without being casual

## Common Issues and Improvements

### 1. Wordiness

**Problem**: Unnecessary verbal padding
```
✗ This article provides a comprehensive overview of the various different approaches
✓ This article overviews various approaches
```

**Problem**: Redundant modifiers
```
✗ A very comprehensive and complete guide
✓ A comprehensive guide
```

### 2. Passive Voice Overuse

**Problem**: Excessive passive constructions
```
✗ A new framework is presented by the author for solving this problem
✓ The author presents a new framework for solving this problem
```

**Exception**: Passive is fine when the actor is unknown or unimportant
```
✓ The results were validated against industry benchmarks
```

### 3. Weak Openings

**Problem**: Vague or generic starts
```
✗ This is an article about GitHub Copilot code review
✓ An official GitHub guide to writing effective Copilot code review instructions
```

**Problem**: Unnecessary meta-commentary
```
✗ In this article, the author discusses...
✓ The article discusses... / [Author name] discusses...
```

### 4. Clichés and Buzzwords

**Avoid overused phrases**:
```
✗ Game-changing, paradigm shift, revolutionary, cutting-edge
✓ Use specific descriptions of what's actually new or different
```

**Be specific**:
```
✗ This leverages best-in-class solutions
✓ This uses [specific technology/approach]
```

### 5. Qualifier Overload

**Problem**: Too many hedging words
```
✗ This might possibly help to somewhat improve your process
✓ This improves your process
```

**Strategic use**: Use qualifiers only when genuinely uncertain
```
✓ This approach may work better for larger teams
```

## Version Differentiation Strategy

### Version 1: Standard Recommendation

**Characteristics**:
- Complete but not verbose
- Objective presentation of value
- Full structure: introduction → core content → value summary

**Sentence Structure Pattern**:
```
[Topic positioning] + [Core content overview] + [Key highlights] + [Target audience/application]
```

**Example**:
```
An official GitHub guide to writing effective instruction files for Copilot 
code review. The article addresses common developer challenges with custom 
instructions by providing systematic solutions for ensuring Copilot accurately 
understands and executes review rules. Drawing from real-world cases, the 
author identifies core principles: keep instructions concise, use structured 
formatting, write imperative statements, and include code examples.
```

### Version 2: Concise Version

**Characteristics**:
- Core information only
- Every sentence is a key point
- Optimized for scanning

**Sentence Structure Pattern**:
```
[Core topic] + [Key method/content] + [Direct value]
```

**Example**:
```
GitHub's best practices for writing Copilot code review instructions. 
The article addresses a key pain point: why doesn't Copilot follow instructions? 
Core recommendations include keeping content concise, using structured formatting, 
writing imperative statements, and providing code examples, while clarifying 
unsupported instruction types.
```

### Version 3: Personal Commentary

**Characteristics**:
- Objective and direct critical analysis
- Points out potential limitations and areas requiring thought
- Raises questions worth discussing
- More personal voice while maintaining professionalism
- Can express constructive reservations

**Sentence Structure Pattern**:
```
[Personal observation/hook] + [Content overview] + [Objective critical analysis] + [Constructive recommendations/discussion points]
```

**Critical Analysis Guidelines**:
- Based on objective analysis, not personal preference
- Specific about what's missing or questionable
- Raises questions requiring further thought
- Notes scenarios where assumptions may not hold
- Balances recognition of value with identification of limitations

**Example**:
```
This article arrives at the right time. After Copilot code review launched, 
many teams enthusiastically wrote extensive instruction files only to find 
the AI completely ignored them. GitHub finally clarifies the issue: AI isn't 
human—it needs structured, concise directives, not lengthy specification 
documents written for people.

The most valuable parts are the template and the list of unsupported instruction 
types. However, the article reveals something: Copilot code review isn't mature 
enough yet and requires developers to invest effort in "training" it. For small 
teams, the cost-benefit ratio deserves careful consideration. But if you're 
already using it, this article can save you considerable trial and error.
```

**Critical Expression Templates**:
- "The analysis is comprehensive, but several practical issues aren't deeply discussed..."
- "This solution looks ideal, but in practice may face..."
- "The author's point is valid, but overlooks a key issue..."
- "Worth noting that the assumptions may not hold in certain scenarios..."
- "What's missing is..."
- "A potential concern is..."
- "This involves a tradeoff between..."

## Common Expression Templates

### Article Type Introductions
- Official guide, comprehensive analysis, technical deep-dive, case study
- Published by [organization], written by [author], shared by [team]
- Systematic introduction, detailed explanation, thorough examination

### Value Descriptions
- Provides systematic solutions
- Identifies core principles
- Reveals underlying logic
- Distills a complete methodology
- Offers actionable implementation strategies

### Target Audience Framing
- For development teams seeking...
- If you're working with...
- Recommended for readers who...
- Particularly valuable when...

### Evaluation Language (Use Judiciously)

**Positive but measured**:
- Valuable, noteworthy, worth attention
- Comprehensive, detailed, practical
- Well-structured, clearly explained

**Avoid hyperbole**:
- ✗ Revolutionary, groundbreaking, unprecedented
- ✗ Must-read, definitive, ultimate

## Style Guidelines

### Punctuation
- Use Oxford comma for clarity: "A, B, and C"
- Em dashes for emphasis—like this
- Colons to introduce: lists or explanations
- Avoid excessive parenthetical remarks

### Sentence Variety
- Mix short and long sentences
- Vary sentence openings
- Use transitions sparingly

### Technical Terms
- Keep standard technical terms in English
- Define acronyms on first use if obscure
- Use industry-standard terminology

### Tone Calibration

**Version 1 tone**:
```
Professional, informative, balanced
- "The article provides..."
- "Key insights include..."
- "This guide helps developers..."
```

**Version 2 tone**:
```
Direct, efficient, matter-of-fact
- "GitHub's guide to..."
- "Addresses the problem of..."
- "Offers ready-to-use templates..."
```

**Version 3 tone**:
```
Conversational, analytical, personal
- "This finally addresses..."
- "What's particularly interesting..."
- "However, it's worth noting..."
```

## Quality Checklist

- [ ] No redundant modifiers
- [ ] No excessive use of quotes or parentheses
- [ ] Active voice where appropriate
- [ ] Specific rather than vague language
- [ ] Natural, idiomatic expressions
- [ ] Accurate information based on source
- [ ] Clear structure and logic
- [ ] Distinct differentiation between versions
- [ ] Word count within targets
- [ ] No grammatical errors

## Common Mistakes to Avoid

### 1. Over-qualification
```
✗ This article seems to provide what might be considered valuable insights
✓ This article provides valuable insights
```

### 2. Nominalization
```
✗ The implementation of the solution requires the consideration of...
✓ Implementing the solution requires considering...
```

### 3. Empty Intensifiers
```
✗ This is really very extremely important
✓ This is critical
```

### 4. Cumbersome Constructions
```
✗ There are many developers who find that...
✓ Many developers find that...
```

### 5. Vague References
```
✗ The article discusses various aspects and different perspectives
✓ The article examines API design patterns and error handling strategies
```
