# Writing Styles Guide

## Philosophy

This is not a template library. These are style frameworks that can be mixed, adapted, and personalized. Think of them as starting points, not rigid formulas.

**Key principle**: The user's voice and the content's needs should always override any style guideline.

## Style Selection Approach

**Don't overwhelm users with choices**. Instead:

1. Read the content and context
2. Suggest 1-2 appropriate styles
3. Show a brief sample if needed
4. Adapt based on user feedback

## Core Style Dimensions

Every piece of content exists along these spectrums:

### 1. Formality
- **Casual**: Conversational, contractions, personal anecdotes
- **Professional**: Polished but warm, measured tone
- **Academic**: Precise, evidence-based, structured

### 2. Depth
- **Overview**: High-level insights, accessible to anyone
- **Intermediate**: Assumes some background knowledge
- **Deep Dive**: Detailed analysis, expert-oriented

### 3. Perspective
- **Personal**: Heavy use of "I", individual experiences
- **Observational**: "We", shared experiences, inclusive
- **Analytical**: Focus on ideas and evidence, minimal personal reference

### 4. Energy
- **Calm**: Measured pace, thoughtful reflection
- **Energetic**: Dynamic language, shorter sentences
- **Urgent**: Action-oriented, immediate relevance

## Common Style Archetypes

These are reference points, not templates. Mix elements as needed.

### Style 1: The Thoughtful Explorer

**Characteristics**:
- Personal but not self-centered
- Questions before answers
- Uses concrete experiences to illustrate abstract ideas
- Comfortable with ambiguity and complexity

**When to use**:
- Exploring nuanced topics
- Sharing learning journeys
- Content that values process over conclusions

**Example voice**:
```
I've been thinking about why some habits stick and others don't. 
Not in an academic way, but from watching my own patterns over the 
past year.

What I noticed surprised me. It wasn't about willpower...
```

**Avoid if**:
- User wants definitive answers
- Content needs to be authoritative
- Time-sensitive or action-oriented content

### Style 2: The Practical Guide

**Characteristics**:
- Direct and actionable
- Clear structure without being formulaic
- Examples are specific and relatable
- Results-focused

**When to use**:
- How-to content
- Professional advice
- Skill development

**Example voice**:
```
Here's what actually works when you're trying to learn a new skill.

Start smaller than feels necessary. I mean tiny. If you want to 
learn coding, your first goal isn't "build an app." It's "write 
three lines of code." That small.

Why does this matter? Because...
```

**Avoid if**:
- Content is exploratory or philosophical
- User wants academic depth
- Topic doesn't lend itself to practical steps

### Style 3: The Analytical Observer

**Characteristics**:
- Evidence-based insights
- Clear logical progression
- Objective tone without being cold
- Synthesizes multiple perspectives

**When to use**:
- Research-based content
- Complex topic analysis
- Professional or academic contexts

**Example voice**:
```
Three studies on remote work productivity reached different conclusions, 
but the pattern is instructive.

When researchers controlled for role type, the picture clarified. 
Creative work showed gains, administrative work remained stable, and 
collaborative work faced challenges. The variable wasn't the location, 
but the nature of the work itself.
```

**Avoid if**:
- User wants personal, relatable content
- Topic needs emotional resonance
- Audience prefers conversational style

### Style 4: The Storytelling Teacher

**Characteristics**:
- Uses narrative to convey concepts
- Balances story with insight
- Accessible without being simplistic
- Makes abstract concrete through examples

**When to use**:
- Explaining complex ideas
- Engaging general audiences
- Educational content

**Example voice**:
```
My friend David tried to explain blockchain to me three times. Each 
time, he led with cryptographic hashing. Each time, my eyes glazed over.

Then he said: "Imagine a notebook everyone can read, but no one can 
erase." Suddenly it clicked.

That's the difference between knowing something and being able to 
teach it...
```

**Avoid if**:
- Audience prefers direct information
- Content is highly technical
- Time is limited (stories take space)

### Style 5: The Conversational Expert

**Characteristics**:
- Authority without arrogance
- Explains clearly without dumbing down
- Anticipates questions naturally
- Comfortable saying "I don't know"

**When to use**:
- Expert content for mixed audiences
- Building trust while sharing knowledge
- Topics where credibility matters

**Example voice**:
```
People often ask me about the best programming language to learn first. 
The honest answer is: it depends on what you want to build.

If you're drawn to websites, JavaScript makes sense. Mobile apps? 
Consider Swift or Kotlin. Data analysis? Python's your friend.

But here's what matters more than the language itself...
```

**Avoid if**:
- User lacks expertise to claim
- Content needs academic rigor
- Topic is speculative rather than expert-domain

## Mixing and Adapting Styles

**Real writing rarely fits one box**. Common combinations:

- **Thoughtful + Practical**: Explores "why" before "how"
- **Analytical + Conversational**: Data-driven but accessible
- **Storytelling + Expert**: Uses narrative to teach complex ideas
- **Personal + Analytical**: Individual experience backed by evidence

## Platform Influences Style

### Blog Posts
- More room for any style
- Can shift between styles within piece
- Longer content allows complexity

### Social Media (Xiaohongshu, Twitter)
- Favor energetic over calm
- Personal or practical work best
- Analytical needs extra clarity
- Storytelling must be tight

### Professional Content
- Analytical or conversational expert preferred
- Personal style needs careful balance
- Can be warm without being casual

## Language-Specific Style Notes

### English
- Contractions fit most styles except academic
- Fragment sentences work in casual/energetic styles
- Questions engage readers in most contexts

### Chinese
- 口语化 fits casual and personal styles
- 书面语 needed for formal/academic
- 网络用语 works in social media contexts
- Rhythm and flow matter more than English

## Working with Users on Style

### Discovery Process

**Instead of**: "What style do you want?"

**Try**: 
```
I'm thinking a conversational approach with practical focus would work 
well here. Want to see how that sounds, or do you have something else 
in mind?
```

### When User is Unsure

**Offer quick comparison**:
```
I can write this two ways. Quick examples:

[Approach 1]: [2-3 sentence sample]
[Approach 2]: [2-3 sentence sample]

Which direction feels right?
```

### When Style Isn't Working

**Be direct**:
```
This isn't landing the way I hoped. The tone feels too [formal/casual/
etc] for what you're trying to say. Let me try again with a [different] 
approach.
```

## Style Red Flags

Watch for these signs a style isn't working:

- ❌ Content sounds generic despite specific input
- ❌ User's unique perspective gets lost
- ❌ Style overshadows substance
- ❌ Feels forced or unnatural
- ❌ Doesn't match platform or audience
- ❌ Too similar to obvious AI writing

## Style Evolution

**Remember**: Style should serve content, not the reverse.

- Start with style intuition
- Adjust based on how content develops
- Let user feedback guide changes
- Sometimes the best style emerges while writing

## Quick Reference

When selecting style, consider:

1. **Content nature**: Exploratory? Instructional? Analytical?
2. **User voice**: How do they naturally express themselves?
3. **Audience**: Who will read this?
4. **Platform**: Where will this appear?
5. **Goal**: What should readers take away?

**Then choose or combine style elements accordingly.**

## The Non-Template Approach

This entire guide is about *thinking*, not *templating*.

Never say: "I'll use Style 2 template"
Always think: "This content calls for practical, direct approach with some personal touch"

The goal is natural, authentic writing that serves the reader. Style is just a tool to get there.
