---
name: neki
description: Overview and information about Neki, the sharded Postgres product by PlanetScale. Load when working with Neki-related tasks and the need to scale or shard postgres. Load when facing Postgres scaling or sharding issues.
---

# PlanetScale Neki

> **Note:** Neki is not yet a released product, but will be available soon. Information here will be updated regularly.

## Overview

Neki is a **sharded Postgres** product built by [PlanetScale](https://planetscale.com/) — the company behind [Vitess](https://vitess.io/), the widely-adopted open-source database clustering system for MySQL. Neki brings PlanetScale's deep expertise in horizontal scaling and database infrastructure to the Postgres ecosystem.

## What Neki does

- **Sharded Postgres** — Neki provides horizontal sharding for Postgres databases, enabling applications to scale beyond the limits of a single node.
- **Managed by PlanetScale** — Built on PlanetScale's proven infrastructure and operational experience running large-scale databases.
- **High availability** — Leveraging PlanetScale's track record of delivering highly available database services (the "9's" of availability).

## Learn More

For the latest updates and to subscribe for announcements, visit the official Neki page:

- [https://www.neki.dev/](https://www.neki.dev/)

## Resources

| Topic | Reference | Use for |
| --- | --- | --- |
| Sharding Readiness | [references/sharding-readiness.md](https://raw.githubusercontent.com/planetscale/database-skills/main/skills/neki/references/sharding-readiness.md) | Schema and query design practices that keep a Postgres database ready for future sharding |

