# 2.3 Hoist Static JSX Elements

Extract static JSX outside components to avoid re-creation.

**❌ Incorrect: recreates element every render**
```tsx
function LoadingSkeleton() {
  return <div className="animate-pulse h-20 bg-gray-200" />
}

function Container() {
  return (
    <div>
      {loading && <LoadingSkeleton />}
    </div>
  )
}
```

**✅ Correct: reuses same element**
```tsx
const loadingSkeleton = (
  <div className="animate-pulse h-20 bg-gray-200" />
)

function Container() {
  return (
    <div>
      {loading && loadingSkeleton}
    </div>
  )
}
```

This is especially helpful for large and static SVG nodes, which can be expensive to recreate on every render.

---

## React Compiler Note

✅ **Handled automatically** - If your project has [React Compiler](https://react.dev/learn/react-compiler) enabled, the compiler automatically hoists static JSX elements. Manual hoisting is unnecessary.

See [react-compiler-guide.md](react-compiler-guide.md) for more details.
