# 1.1 Example Rule

## Overview

<!-- State the problem this rule solves and why it matters for agents.
     Focus on: What goes wrong without this rule? What does this optimize?
     Keep to 2-3 sentences.

     CRITICAL: Focus on EXPERT-ONLY knowledge Claude doesn't have.
     Ask: "Does Claude already know this?" If yes, delete it.
     NEVER explain basic concepts, standard library usage, or common patterns.
     Only include non-obvious trade-offs, edge cases, and expert decisions.
-->

Brief explanation of what this rule covers and why it matters (expert knowledge only).

## Key Principles

<!-- Optional section. Use when there are 3-5 fundamental concepts to understand.
     Skip this section if the Examples below are self-explanatory.
     Each principle should be one sentence. -->

1. **Principle 1**: Explanation
2. **Principle 2**: Explanation
3. **Principle 3**: Explanation

## Examples

<!-- CRITICAL: Always use ❌/✅ paired examples.
     Never show only correct examples - agents learn best from contrasts.
     Keep examples realistic and specific (not "foo/bar" placeholders).
     Use actual code/commands from the domain. -->

### Pattern 1: [Description]

**❌ Incorrect: [description of why]**
```
Example of what NOT to do
```

**Why this is wrong:** Explanation of the problem (focus on consequences: bugs, inefficiency, confusion)

**✅ Correct: [description of why]**
```
Example of the right approach
```

**Why this is better:** Explanation of the improvement (focus on benefits: clarity, performance, correctness)

### Pattern 2: [Description]

**❌ Incorrect: [description of why]**
```
Another example of what NOT to do
```

**Why this is wrong:** Explanation of the problem

**✅ Correct: [description of why]**
```
Correct approach
```

**Why this is better:** Explanation of the improvement

## Additional Guidelines

<!-- Optional section for supplementary rules that don't need full examples.
     Use bullet points for quick reference.
     Remove this section if everything is covered in Examples above. -->

- Guideline 1
- Guideline 2
- Guideline 3

## Common Pitfalls

<!-- Highlight mistakes agents commonly make when applying this rule.
     Focus on subtle errors, not obvious ones covered in Examples.
     Each pitfall should include how to avoid it. -->

- Pitfall 1: Description and how to avoid it
- Pitfall 2: Description and how to avoid it
- Pitfall 3: Description and how to avoid it

---

Reference: [Link to external documentation if applicable]
