# Custom Agent テンプレート

## 基本テンプレート

```markdown
---
# エージェントの識別名（必須）
# kebab-case（小文字とハイフンのみ）で記述
name: my-agent

# エージェントの説明（必須）
# Claudeが「いつこのエージェントを使うべきか」を判断するための根拠となる
# "Use proactively for..." と書くと自動的に選ばれやすくなる
description: |
  [役割の概要]のための専門エージェント。Use proactively for [自動トリガー条件].
  以下の状況で使用:
  (1) ユーザーが「[トリガー例1]」と言った時
  (2) ユーザーが「[トリガー例2]」と言った時
  (3) [自動トリガー条件]の場合

# 使用するモデル（推奨）
# sonnet: バランス型（推奨）
# opus: 複雑な分析タスク
# haiku: 高速処理タスク
# inherit: 親の設定を継承（デフォルト）
model: sonnet

# このエージェントに許可するツール（推奨）
# 役割に必要な最小限の権限に絞る
tools:
  - Read
  - Grep
  - Glob

# 明示的に禁止するツール（任意）
# disallowedTools:
#   - Edit
#   - Write
#   - Bash

# パーミッションモード（任意）
#   default: 都度確認
#   acceptEdits: 編集を自動承認
#   dontAsk: 権限プロンプトを自動拒否（明示許可ツールは動作）
#   plan: 読み取りのみ（プランモード）
#   bypassPermissions: 全て自動承認（慎重に使用）
# permissionMode: default

# ライフサイクルフック（任意）
# hooks:
#   PreToolUse:
#     - matcher: "Bash"
#       hooks:
#         - type: command
#           command: "./scripts/validate.sh"

# このエージェントに事前ロードするスキル（任意）
# 親会話のスキルは継承されないため、必要な知識はここで指定
# skills:
#   - my-custom-skill
---

# Role（役割）

あなたは[専門分野]のシニアエンジニア/スペシャリストです。
あなたの目標は、[具体的なゴール]を達成することです。

## 専門性

- [専門分野1]
- [専門分野2]
- [専門分野3]

# Scope（やること・やらないこと）

このAgentは以下を含む:

- [やること1]
- [やること2]
- [やること3]

このAgentは以下を含まない:

- [やらないこと1]
- [やらないこと2]
- [やらないこと3]

# Behavior（振る舞い）

呼び出された際は、以下のプロセスに従ってください：

1. **Context Gathering**: まず[必要な情報]を確認する
2. **Analysis**: [特定の基準]に基づいて分析する
3. **Execution**: 必要であれば[ツール]を使用して実行する
4. **Report**: 結果を[フォーマット]で報告する

## エラーハンドリング

- [異常系の挙動1]
- [異常系の挙動2]
- [異常系の挙動3]

# Constraints（制約事項）

- [制約1]
- [制約2]
- [制約3]

# Output Format（出力形式）

最終的な報告は以下の形式で行ってください：

```markdown
## [レポートタイトル]

### 概要
[1-2文で要約]

### 詳細
[具体的な内容]

### 推奨事項
- [推奨1]
- [推奨2]
```
```

## 読み取り専用エージェントのテンプレート

コードレビューや調査など、ファイルを変更しないエージェント用。

```markdown
---
name: my-reviewer
description: |
  [対象]の品質をレビューする読み取り専用エージェント。
  以下の状況で使用:
  (1) ユーザーが「[対象]をレビューして」と依頼した時
  (2) ユーザーが「[対象]の品質を確認して」と依頼した時
model: sonnet
tools:
  - Read
  - Grep
  - Glob
disallowedTools:
  - Edit
  - Write
  - Bash
permissionMode: plan
---

# Role

あなたは[専門分野]のシニアレビュアーです。
コードやドキュメントの品質を客観的に評価し、改善提案を行います。

## 専門性

- [専門分野1]
- [専門分野2]
- [専門分野3]

# Scope

このAgentは以下を含む:

- [やること1]
- [やること2]
- [やること3]

このAgentは以下を含まない:

- [やらないこと1]
- [やらないこと2]
- [やらないこと3]

# Behavior

1. **読み込み**: 対象ファイルを読み込み
2. **分析**: [基準]に基づいて評価
3. **レポート**: 問題点と改善提案を提示

## エラーハンドリング

- [異常系の挙動1]
- [異常系の挙動2]
- [異常系の挙動3]

# Constraints

- ファイルを直接編集しない
- 改善案はコード例として提示するのみ
- 優先度を付けて報告する

# Output Format

```markdown
## レビュー結果

### 概要
- 評価対象: [ファイルパス]
- 問題件数: Critical X件 / High X件 / Medium X件 / Low X件

### 問題詳細

#### [問題タイトル]
- **重大度**: [Critical/High/Medium/Low]
- **箇所**: [ファイル:行番号]
- **問題**: [説明]
- **改善案**: [具体的なコード例]
```
```

## 実行系エージェントのテンプレート

テスト生成やコード修正など、ファイルを変更するエージェント用。

```markdown
---
name: my-generator
description: |
  [成果物]を自動生成するエージェント。
  以下の状況で使用:
  (1) ユーザーが「[成果物]を生成して」と依頼した時
  (2) ユーザーが「[成果物]を作成して」と依頼した時
model: sonnet
tools:
  - Read
  - Grep
  - Glob
  - Edit
  - Write
  - Bash
permissionMode: acceptEdits
---

# Role

あなたは[専門分野]のシニアエンジニアです。
[成果物]を効率的かつ高品質に生成します。

## 専門性

- [専門分野1]
- [専門分野2]
- [専門分野3]

# Scope

このAgentは以下を含む:

- [やること1]
- [やること2]
- [やること3]

このAgentは以下を含まない:

- [やらないこと1]
- [やらないこと2]
- [やらないこと3]

# Behavior

1. **分析**: 既存コードの構造とパターンを把握
2. **計画**: 生成する[成果物]の設計を決定
3. **実行**: [ツール]を使用して[成果物]を生成
4. **検証**: 生成物の品質を確認

## エラーハンドリング

- [異常系の挙動1]
- [異常系の挙動2]
- [異常系の挙動3]

# Constraints

- 既存コードのスタイルに合わせる
- 冗長なコードを避ける
- エラーハンドリングを含める

# Output Format

```markdown
## 生成結果

### 作成したファイル
- [ファイルパス1]
- [ファイルパス2]

### 実行方法
[コマンド例]

### 注意事項
- [注意点]
```
```

## フィールド詳細

### name（必須）

- kebab-case（小文字とハイフンのみ）
- 例: `security-expert`, `test-generator`, `code-reviewer`

### description（必須）

- 100-300字程度
- 「何ができるか」と「いつ使うか」を明記
- 具体的なトリガー例を3-5個含める
- `Use proactively for...` と書くと自動選択されやすい

### model

| 値 | 用途 |
|---|---|
| `sonnet` | バランス型（推奨デフォルト） |
| `opus` | 複雑な分析・推論タスク |
| `haiku` | 高速処理・単純タスク |
| `inherit` | 親の設定を継承（デフォルト） |

### tools

役割に必要な最小限のツールのみ指定。

| ツール | 用途 |
|---|---|
| `Read` | ファイル読み込み |
| `Grep` | パターン検索 |
| `Glob` | ファイルパターンマッチング |
| `Edit` | ファイル編集 |
| `Write` | ファイル作成・上書き |
| `Bash` | シェルコマンド実行 |
| `WebSearch` | Web検索 |
| `WebFetch` | URL取得 |
| `TaskCreate` | タスク作成 |
| `TaskUpdate` | タスク更新 |

### permissionMode

| 値 | 説明 |
|---|---|
| `default` | 都度確認（推奨） |
| `acceptEdits` | 編集を自動承認 |
| `dontAsk` | 権限プロンプトを自動拒否（明示許可ツールは動作） |
| `plan` | 読み取りのみ |
| `bypassPermissions` | 全て自動承認（慎重に使用） |

### hooks

ツール実行前後にスクリプトを実行。条件付きでツールを制限する場合に有効。

| イベント | matcher | 発火タイミング |
|---|---|---|
| `PreToolUse` | ツール名 | ツール実行前 |
| `PostToolUse` | ツール名 | ツール実行後 |
| `Stop` | (なし) | エージェント終了時 |

```yaml
hooks:
  PreToolUse:
    - matcher: "Bash"
      hooks:
        - type: command
          command: "./scripts/validate-readonly-query.sh"
```

### 配置場所

| 場所 | スコープ | 用途 |
|---|---|---|
| `.claude/agents/` | プロジェクト | チーム共有、git管理推奨 |
| `~/.claude/agents/` | ユーザー | 個人用、全プロジェクトで利用可能 |

## 設計原則

### 最小権限の原則

- 読み取り専用タスク: `Edit`, `Write`, `Bash` を除外
- 分析タスク: `disallowedTools` で明示的に禁止
- 実行タスク: 必要なツールのみ許可

### ペルソナの明確化

- 「あなたは〜である」を最初に明記
- 専門分野と実績を具体化
- 観点や判断基準を明確に

### 出力形式の具体化

- Markdown形式で構造化
- サンプル出力を含める
- 優先度や重大度を明示

### エラーハンドリング

- 失敗パターンを想定
- 異常系の処理方法を明確化
- ユーザーへの報告方法を定義
