# Agent チェックリスト

## 事前準備フェーズ

### 要件の理解
- [ ] Agentの目的が **1-2文** で簡潔に説明できるか
- [ ] 目的は「何ができるか」を明確に述べているか（「便利」「効率的」ではなく）
- [ ] Agentを必要とする **具体的なシナリオ** が3つ以上思い当たるか
- [ ] Agentの **境界** が明確か（何を含み、何を含まないか）

### ユースケースの定義
各ユースケースについて：
- [ ] ユーザーが **実際に言う言葉** を想定しているか（「ユーザーはXをしたいはず」ではなく「ユーザーはこう言う」）
- [ ] 期待される動作が **段階的** に説明されているか（1→2→3の流れ）
- [ ] 成功基準が **検証可能** か（定性的評価ではなく、「Aが含まれている」など定量的）
- [ ] **エッジケース** が想定されているか（失敗パターン、異常系）
- [ ] **出力形式** が具体的に説明されているか

### メタデータの設計
- [ ] name が **kebab-case** で小文字とハイフンのみ使用されているか
- [ ] description に「**何ができるか**」が含まれているか
- [ ] description に「**いつ使うか**」が含まれているか
- [ ] description に **具体的なトリガー例** が含まれているか（「Use when...」形式）
- [ ] description が **適切な長さ**（100-300字程度）か

### ツール選択の設計
- [ ] **tools** フィールドが目的に対して適切か
- [ ] 読み取り専用Agentは Write/Edit を含まないか
- [ ] 実行系Agentは必要最小限のツールに限定されているか
- [ ] **disallowedTools** で明示的に禁止すべきツールが指定されているか

### モデル選択の設計
- [ ] **model** フィールドが目的に対して適切か
  - 複雑な分析: `sonnet` または `opus`
  - 高速処理: `haiku`
  - 親の設定を継承: `inherit`（デフォルト）
- [ ] モデル選択の **理由** が説明できるか

### パーミッション設計
- [ ] **permissionMode** が目的に対して適切か
  - `default`: 通常のパーミッションチェック
  - `acceptEdits`: ファイル編集を自動承認
  - `dontAsk`: パーミッションプロンプトを自動拒否
  - `bypassPermissions`: 全てのパーミッションチェックをスキップ（慎重に使用）
  - `plan`: プランモード（読み取り専用探索）
- [ ] `bypassPermissions` 使用時、その必要性が説明できるか

### 実装スタイルの指定
- [ ] **エラーハンドリング** の方針が説明されているか
- [ ] **ユーザーインタラクション** が必要な場面が具体的に指定されているか
- [ ] **出力形式** がユースケースごとに明確か

### トリガーの検証
- [ ] description内のトリガーパターンが **3-5個** 挙げられているか
- [ ] トリガーパターンが **具体的な発話例** か（「データ分析」ではなく「このデータを分析して」）
- [ ] トリガーが **広すぎないか**（他Agentと競合しないか）
- [ ] トリガーが **狭すぎないか**（実際のユースケースをカバーしているか）

## 実装フェーズ

### frontmatter完全性
- [ ] **YAML構文** が正しいか（インデント、コロン、引用符）
- [ ] **必須フィールド** が含まれているか（name, description）
- [ ] **name** がkebab-case（小文字とハイフン）か
- [ ] **description** に複数行が必要な場合 `|` または `>` が使用されているか
- [ ] **tools** が配列またはカンマ区切りで正しく指定されているか
- [ ] **model** が有効な値（sonnet/opus/haiku/inherit）か
- [ ] **permissionMode** が有効な値（default/acceptEdits/dontAsk/bypassPermissions/plan）か
- [ ] **不要なフィールド** が含まれていないか

### システムプロンプト品質
- [ ] **命令形** で記述されているか（「You are...」「When invoked...」）
- [ ] プロンプトが **500行以内** に収まっているか
- [ ] **ペルソナ** が明確に定義されているか（「You are a...」）
- [ ] **実行手順** が具体的に説明されているか
- [ ] **チェックリスト** や **評価基準** が明示されているか
- [ ] **出力形式** の具体例が提示されているか
- [ ] エラー時の **挙動** が説明されているか

### ツール選択の妥当性
- [ ] 指定されたツールが **目的達成に必要** か
- [ ] **過剰なツール** が含まれていないか
- [ ] 読み取り専用タスクで Write/Edit が許可されていないか
- [ ] Bash実行が必要な理由が説明できるか
- [ ] disallowedTools で明示的禁止が適切か

### Hooks設定の妥当性（該当する場合）
- [ ] **PreToolUse** フックが必要な理由が説明できるか
- [ ] フックスクリプトが **実在** するか
- [ ] フックスクリプトが **実行可能** (chmod +x) か
- [ ] **matcher** パターンが適切なツール名を指定しているか
- [ ] **Stop** フックが適切に設定されているか

### Skills設定の妥当性（該当する場合）
- [ ] preloadする **skills** の必要性が説明できるか
- [ ] 指定されたスキルが **実在** するか
- [ ] スキルのコンテキスト量が **適切** か（トークン効率）

## 検証フェーズ

### トリガー動作
- [ ] description に記載されたトリガーが **実際に機能** するか
- [ ] 想定外のトリガーで **誤起動しない** か
- [ ] トリガーの **範囲** が適切か（広すぎず狭すぎず）

### エラーハンドリング
- [ ] 異常系の **挙動** が文書化されているか
- [ ] ファイルが見つからない場合の処理が説明されているか
- [ ] パーミッションエラー時の処理が説明されているか
- [ ] タイムアウト時の処理が説明されているか

### 出力形式
- [ ] 期待される **出力** が具体的に説明されているか
- [ ] 出力形式が **一貫** しているか
- [ ] **フォーマット例** が提示されているか

### ツール制限の動作
- [ ] tools 指定が **意図通り** に機能するか
- [ ] disallowedTools が **適切にブロック** するか
- [ ] hooks が **期待通り** に動作するか

## 公開前フェーズ

### ドキュメント完全性
- [ ] **余分なファイル** がないか（README.md、INSTALLATION.mdなど）
- [ ] 必要な情報が **frontmatter + body** に揃っているか
- [ ] **コメント** が適切に記述されているか

### 保守性
- [ ] 他の開発者が **理解** できる構造か
- [ ] 他の開発者が **修正** できる構造か
- [ ] **意図** が明確に伝わるか

### セキュリティ
- [ ] **bypassPermissions** の使用が本当に必要か再確認されているか
- [ ] ツールアクセスが **最小権限の原則** に従っているか
- [ ] hooks で実行されるスクリプトが **安全** か検証されているか

### パフォーマンス
- [ ] モデル選択が **コスト効率** を考慮しているか
- [ ] プロンプトの長さが **適切** か（トークン効率）
- [ ] preload する skills が **必要最小限** か
