## ✅ 含めるべき内容

## 1. プロジェクトの「WHY・WHAT・HOW」の概要

WHATとして技術スタックやプロジェクト構造についてAIに伝えます。モノレポでは特に重要で、アプリが何で、共有パッケージが何で、それぞれの目的を伝えることでAIがどこを見ればいいかわかるようにします。
WHYとしてプロジェクトの目的と、リポジトリが何をしているかを伝えます。
HOWとしてプロジェクト上でどのように作業すべきかを伝えます。

## 2. よく使うコマンド（厳選して）

ビルド・テスト・タイプチェックのような共通のbashコマンド

### 3. プロジェクト固有の「意外な挙動」や注意点

プロジェクトに特有の予期しない動作や警告も理想的な記載内容です。 このような情報はドキュメントに書かれておらず、AIが自力で発見できないため、AGENTS.mdやCLAUDE.mdに書く価値が高いものです。例：「このAPIは429エラーを503として返す」「テスト実行は必ず `--forceExit` フラグが必要」など。

### 4. リポジトリの作法（ブランチ命名、マージ戦略など）

ブランチ命名やmerge vs. rebaseのようなリポジトリエチケットも記載すべき内容です。 これはコードベースを読んでも推測しにくい、チーム固有のルールです。

### 5. 開発環境セットアップの特殊事項

pyenvの使用方法や動作するコンパイラのような開発者環境のセットアップ情報が含まれます。 一般的でないツールチェーンや、環境特有の制約を記載しておくと効果的です。

### 6. モノレポの場合のディレクトリ構造マップ

モノレポでは特に重要で、アプリが何で、共有パッケージが何か、それぞれの目的を伝えることでAIがどこを見ればいいかわかるようにします。

## ❌ 含めないでおくべき内容と、その理由

### 1. 詳細なコードスタイルガイドライン

AGENTS.mdやCLAUDE.mdに最もよく見られるのがコードスタイルのガイドラインですが、「LLMにリンターの仕事をさせるべきではありません」。LLMは従来のリンターやフォーマッターに比べて比較にならないほど高コストかつ非常に遅いです。

さらに、LLMはインコンテキスト学習者です。コードが特定のスタイルガイドラインやパターンに従っているなら、コードベースをいくつか検索するだけで（または優れたリサーチドキュメントがあれば）、エージェントは既存のコードパターンと慣習に従う傾向があります。 つまり書かなくても学習します。

代替案として、ESLint・Biomeなどのリンターをhooksで自動実行する設計のほうが確実です。

### 2. 特定タスクにしか適用されない指示

AGENTS.mdやCLAUDE.mdはすべてのセッションに入るため、その内容が可能な限り普遍的に適用可能であることを確認すべきです。例えば新しいデータベーススキーマの構造化方法のような指示は、それと無関係なことに取り組んでいる際にはモデルの気を散らすだけです。

### 3. ファイルの丸ごとのコピー・コードスニペット

可能であればコードスニペットをこれらのファイルに含めないでください。すぐに古くなります。代わりに `file:line` 参照を使ってAIを正式なコンテキストに誘導してください。

コードは変更されるので、コピーを維持するコストが高くなります。

### 4. 「絶対にXXXするな」系の禁止命令だけの記述

「Never use --foo-bar flag」（エージェントが詰まる）ではなく、「Never use --foo-bar; prefer --baz instead」（代替を示す）のように書くべきです。 禁止だけでは詰まりますが、代替案を示すと適切に動けます。

### 5. `/init` の自動生成結果をそのまま使う

AGENTS.mdやCLAUDE.mdはすべてのセッションに入るため、ハーネスの最も高いレバレッジポイントのひとつです。悪いコードの行は悪いコードの行ですが、AGENTS.mdやCLAUDE.mdファイルはワークフローのすべてのフェーズとすべての成果物に影響します。そのため、入れるすべての行について慎重に考える時間を使うべきです。

### 6. 時限性のある情報

APIのバージョン切り替えの時期など、将来的に無効になる情報は書かないべきです。「2025年8月より前ならば旧APIを使う。2025年8月以降は新APIを使う」といった時間経過で誤りになる内容は含めるべきではありません。

## 📁 「Progressive Disclosure」パターンが鍵

AGENTS.mdやCLAUDE.md自体を短く保ちつつ詳細情報も使えるようにする最も有効な設計が「Progressive Disclosure（段階的開示）」です。

タスクまたはプロジェクト固有の指示は、プロジェクト内のどこかに自己説明的な名前の別のmarkdownファイルに保管することを推奨します。CLAUDE.mdではこれらのファイルを `@{ファイルパス}` という構文で参照する事が出来ます。

```text
.claude/rules/
  |- building-the-project.md
  |- running-tests.md
  |- code-conventions.md
  |- service-architecture.md
  |- database-schema.md
```


## 含めるor含めない の判断基準

1. 毎回のセッションで必要か？ → Yes なら含める候補、No なら別ファイルへ
2. AIが自分でコードを読んで推測できるか？ → できるなら含めない
3. 既存ツール（リンター・CI）で代替できるか？ → できるなら含めない
4. 将来変わる可能性が高いか？ → 高いなら含めない
5. この指示を加えることで他の指示の精度が下がるコストに見合うか？ → 見合わなければ削除
