# 評価指針（Evaluation Criteria）

## 概要

プロジェクトの知識を専用ファイル（コンテキストストア）に出力する場合、推論の正確性（Grounding）と応答の一貫性（Consistency）を最大化するために設計される必要があります。
専用ファイルや外部データベース（RAGシステムで使用されるベクトルデータベースなど）に含めるべき内容としては、主に以下の3つのカテゴリーが挙げられます。これらの情報は、ユーザーのクエリが来た際に検索され、プロンプトのコンテキストとして利用されます。

## 1. プロジェクトの構造と技術的コンテキスト

プロジェクトの静的で普遍的な情報、およびAIエージェントが**行動（Action）**を起こす際に参照すべき具体的な技術情報を含めます。

### ドキュメントとコードベース

PDF、Microsoft Wordドキュメント、およびすべてのテキスト（コードを含む）など、非構造化文書を知識として活用できます。プロジェクトの既存コードやAPI仕様書もこれに含まれます。

### 技術スタックと依存関係

コード生成に必要なライブラリやSDK、外部ツールの定義に関する情報です。例えば、SQL生成タスクのために、データベースのテーブルとカラムのスキーマ（Customers, Products, Ordersなど）を詳細に定義して提供できます。

### ツールの定義とスキーマ

LLMが呼び出すことが可能な**外部関数（ツール）**の定義を含めます。これには、関数のname、description、および入力パラメーターを定義するinput_schema（JSONオブジェクト）が含まれます。これにより、AIエージェントは現実世界の操作を実行できます。

### コンフィギュレーション

LLMの動作に影響を与えるパラメータや設定を含めることもできます。例えば、LLMへのサンプリングリクエスト時に、モデルの優先順位（intelligencePriority、speedPriority、costPriority）のヒントを設定できます。

### 会話履歴

以前の会話全体、またはその一部を埋め込み、ベクトルデータベースに追加することで、エージェントの記憶（Memory）ユーザーのアカウント履歴などの可変コンテンツを含む場合があります。

## 2. ガイドライン、制約、および規律（Guardrails）

生成されるコードや応答の品質、倫理性、および一貫性を保証するために、LLMが順守すべき厳格なルールを定義します。

### コーディング規約/スタイルガイド

プロジェクトが採用しているソフトウェア開発のスタイルガイドやコーディング規約（例：ファイルの命名にはkebab-caseを使用するなど）です。AIは、プロンプト内で明示的に指示されたルールに従います。

### セキュリティ・倫理的制約

AIが倫理的かつ社会的にセンシティブなトピックを慎重に扱い、バランスの取れた敬意ある応答を提供するためのガイダンスです。セキュリティ要件や、特定の望ましくない行動を回避するためのルール（ガードレール）を含めます。

### 命名規則

変数、関数、またはファイルに適用すべき特定の命名規則です。

### 出力形式の標準化

AIが結果を返す際の構造化されたフォーマットの要求です。例えば、Markdownのセクションヘッダー（#）やバッククォート（```）の使用、JSONまたはXMLタグの使用、または特定の認識可能な開始と終了のパターンを設定することで、応答の解析を容易にします。

## 3. 望ましい行動とパターン（Few-Shot Examples）

LLMがその汎化能力を使って、プロジェクト特有のタスクを正確に実行できるようにするための具体例を含めます。
これらの情報は、RAGシステムによって文書としてロード、変換、チャンク分割され、ベクトル化されてベクトルデータベースに格納され、クエリ時にコンテキストとしてプロンプトに投入されます。

### Few-Shot/マルチショットの例

LLMにタスクの実行方法を示すための少数の例（Few-shot examples）です。これにより、LLMは新しい、または未知のコンテンツに対応するためのパターンを学習します。

### ポジティブなパターン

避けるべき反パターンを示すよりも、従うべきポジティブなパターンを示す方が、望ましい応答を導くのに効果的です。

### 一貫した形式の維持

Few-Shotの例では、出力形式をモデルに示すことが主な目的であるため、XMLタグ、空白、改行、および例の区切りを含め、構造と書式を一貫させることが重要です。

### 推論パターンの例

LLMが思考の連鎖（Chain-of-Thought: CoT）や拡張思考（Extended Thinking）を使って問題を解決すべきである場合、プロンプトの例（マルチショット）に推論のプロセスを含めることで、AIは同様の推論パターンに従います。
