# スキル チェックリスト

## Sub Agent vs Skill の妥当性評価

このレビュー対象がそもそも「Skill」として実装するのが適切か、それとも「Sub Agent」にすべきかを評価する。

**Sub Agentにすべき兆候（以下に該当する場合はSub Agent推奨）:**
- [ ] **隔離された作業者に委任したいか**
  - ✅ PASS: 会話履歴を共有する必要があるため、Skillとして正しい
  - ⚠️ WARNING: コンテキスト分離が望ましい可能性がある（要検討）
  - ❌ FAIL: 明らかに隔離実行すべきなのにSkillとして実装されている

- [ ] **権限分離が必要か**
  - ✅ PASS: 特定の権限制限は不要（Skillとして適切）
  - ⚠️ WARNING: 「読み取り専用」など権限分離が望ましい（Sub Agent検討）
  - ❌ FAIL: セキュリティ上権限分離が必須なのにSkillで実装

- [ ] **役割定義（Persona）が主目的か**
  - ✅ PASS: 手順書・知識の提供が主目的（Skillとして適切）
  - ⚠️ WARNING: 「〜の専門家として振る舞う」要素が強い（Sub Agent検討）
  - ❌ FAIL: 明らかに「人格・役割」を定義したいのにSkillで実装

- [ ] **並列処理が必要か**
  - ✅ PASS: 単独タスクのため並列不要（Skillとして適切）
  - ⚠️ WARNING: 複数タスクの同時実行が効率的な可能性
  - ❌ FAIL: 並列処理が必須なのにSkillで実装

**Skillにすべき兆候（以下に該当する場合はSkill推奨）:**
- [ ] **文脈が必要か**
  - ✅ PASS: 現在の会話の流れを前提とする（Skillとして正しい）
  - ⚠️ WARNING: 文脈依存しないタスク（Sub Agent検討）
  - ❌ FAIL: 文脈不要なのにSkillで実装（無駄なコンテキスト消費）

- [ ] **ルールやドメイン知識の共有が目的か**
  - ✅ PASS: コーディング規約・社内用語集など知識提供が主目的
  - ⚠️ WARNING: 知識よりも「処理の実行」が主目的（Sub Agent検討）

- [ ] **資料やスクリプトを同梱したいか**
  - ✅ PASS: references/ や scripts/ を活用している
  - ⚠️ WARNING: 同梱資料がなく、純粋な処理実行のみ（Sub Agent検討）

- [ ] **定型作業（コマンド的操作）か**
  - ✅ PASS: `/review` や `/commit` のような頻繁に使う操作
  - ⚠️ WARNING: 一度きりの調査や分析（Sub Agent検討）

**総合判定:**
- [ ] 総合的に見て、この実装形態（Skill）は妥当か
  - ✅ PASS: Skillとして実装するのが適切
  - ⚠️ WARNING: Sub Agentとの併用（`context: fork` + `agent` 指定）を検討すべき
  - ❌ FAIL: Sub Agentとして再実装すべき

**参照:** `{このファイルのDIR}/subagent-vs-skill.md` の「使い分けのポイント」「補足: クイックチャート」

---

## 事前準備フェーズ

### 要件の理解
- [ ] スキルの目的が **1-2文** で簡潔に説明できるか
- [ ] 目的は「何ができるか」を明確に述べているか（「便利」「効率的」ではなく）
- [ ] スキルを必要とする **具体的なシナリオ** が3つ以上思い当たるか
- [ ] スキルの **境界** が明確か（何を含み、何を含まないか）

### ユースケースの定義
各ユースケースについて：
- [ ] ユーザーが **実際に言う言葉** を想定しているか（「ユーザーはXをしたいはず」ではなく「ユーザーはこう言う」）
- [ ] 期待される動作が **段階的** に説明されているか（1→2→3の流れ）
- [ ] 成功基準が **検証可能** か（定性的評価ではなく、「Aが含まれている」など定量的）
- [ ] **エッジケース** が想定されているか（失敗パターン、異常系）
- [ ] **出力形式** が具体的に説明されているか

### リソースの計画
**参照資料:**
- [ ] 各参照資料について「なぜ参照資料に含める必要があるのか」理由が説明されているか
- [ ] 参照資料が SKILL.md でも説明されている（重複の無視）か、確認されているか
- [ ] 各参照資料が「毎回参照」「たまに参照」「ほぼ参照なし」で分類されているか
- [ ] 大きな参照資料（>5k words）については grep パターンが提示されているか

**スクリプト:**
- [ ] 各スクリプトについて「なぜ自動実行が必要か」が説明されているか
- [ ] スクリプトの入力（パラメータ、ファイル形式）が具体的に指定されているか
- [ ] スクリプトの出力形式が明確か
- [ ] スクリプトの再利用性（毎回/時々/オプション）が判断できるか
- [ ] 依存パッケージが列挙されているか

**アセット:**
- [ ] テンプレートやボイラープレートが実装時に実際に使われるシナリオが想定されているか
- [ ] 静的ファイルは「参照資料」ではなく「アセット」に分類されているか

### メタデータの設計
- [ ] name が **kebab-case** で、且つ `-er` や `-or` といった「...する人」を表す接尾辞か
- [ ] description に「**何ができるか**」が含まれているか
- [ ] description に「**いつ使うか**」が含まれているか
- [ ] description に **具体的なトリガー例** が含まれているか
- [ ] description が **100-200字程度** の適切な長さか（短すぎず、長すぎず）

### 実装スタイルの指定
- [ ] **Degrees of Freedom** が選択されているか（High/Medium/Low）
- [ ] その選択の **理由** が説明されているか
- [ ] **エラーハンドリング** の方針が各パターンで説明されているか
- [ ] **ユーザーインタラクション** が必要な場面が具体的に指定されているか
- [ ] **出力形式** がユースケースごとに異なる場合、各々が明確か

### サブエージェント実行方式の評価
以下の条件に該当する場合、frontmatterで `context: fork` と `agent: {agent_name}` の指定を検討すべき：

**基本判断基準:**
- [ ] **大量のファイル読み込みが必要か**
  - ✅ PASS: 10ファイル以上の探索的読み込みが想定される場合、`context: fork` を指定している
  - ⚠️ WARNING: 5-10ファイル程度の読み込みだが `context: fork` が未指定（状況により推奨）
  - ❌ FAIL: 大量ファイル読み込みが必要なのに `context: fork` が未指定

- [ ] **会話履歴を汚したくないか**
  - ✅ PASS: 定型業務で毎回クリーンな環境が必要な場合、`context: fork` を指定している
  - ⚠️ WARNING: 調査系タスクだが `context: fork` が未指定（推奨される可能性）
  - ❌ FAIL: 独立性が重要なタスクなのに `context: fork` が未指定

- [ ] **特定のツールセットで実行したいか**
  - ✅ PASS: 読み取り専用タスクで `agent: Explore` を指定している
  - ✅ PASS: 計画特化タスクで `agent: Plan` を指定している
  - ✅ PASS: カスタムエージェントが必要で適切に定義・指定されている
  - ⚠️ WARNING: 権限分離が望ましいが agent 指定がない
  - ❌ FAIL: 読み取り専用のはずなのに `agent: Explore` が未指定

**frontmatter記述の完全性:**
- [ ] `context: fork` を使用している場合、`agent` も明示的に指定されているか
  - ✅ PASS: `context: fork` と `agent: Explore` の両方が記述されている
  - ❌ FAIL: `context: fork` のみで agent が未指定（デフォルト動作が不明確）

- [ ] 指定した agent が実在するか
  - ✅ PASS: 組み込みエージェント（Explore, Plan, Architect）を指定している
  - ✅ PASS: カスタムエージェントが `.claude/agents/` に実際に存在する
  - ❌ FAIL: 存在しないエージェント名を指定している

**参照:** `{このファイルのDIR}/subagent-vs-skill.md` の「Skill → Sub Agent」セクション

---

### トリガーの検証
- [ ] トリガーパターンが **5-10個** 挙げられているか
- [ ] トリガーパターンが **具体的な発話例** か（「テキスト処理」ではなく「このmarkdownをHTMLに変換」）
- [ ] トリガーが **広すぎないか**（他スキルと競合しないか）
- [ ] トリガーが **狭すぎないか**（実際のユースケースをカバーしているか）
