# Sub Agent vs Skill

## 定義すべき内容

### Sub Agent

「あなたは誰か？」: 本文はそのエージェントのシステムプロンプトになるため、役割（Role）の定義が最も重要

- Role (役割): 「あなたはシニアセキュリティエンジニアです」など
- System Context: そのエージェントが従うべき振る舞いのルール
- Tools: その役割に必要な最小限のツール（例：コードレビュー係なら Edit 権限を剥奪するなど）

### Skill

「何をどうするか？」: 本文は必要になった時に現在の会話に読み込まれる「指示書」。役割を定義するよりも「具体的な手順」や「参照データ」を記述する事が重要

- Workflow (手順): 「デプロイ手順：1. テストを実行、2. ビルド...」
- Knowledge (知識): 「APIの命名規則は〜」「社内DBのスキーマ定義」
- Description (重要): Claudeが「いつこのスキルを使うべきか」を判断するために、Frontmatterのdescriptionを詳細に書くことを推奨

## 使い分けのポイント

### Sub Agent

「隔離された作業者」にタスクを委任したい場合

- コンテキストを汚したくない時
  - 大量のファイルを読み込む調査（Explore）などは、メインの会話履歴を消費しないようSub Agentに任せるのが最適
- 権限を分離したい時
  - 「読み取り専用のエージェント」や「特定のツールしか使えないエージェント」を作りたい場合
- 役割を切り替えたい時
  - 普段のコーディングとは別に、非常に厳しい基準でチェックする「査読者」が必要な場合
- 並列処理したい時
  - 「認証機能とデータベース周りを並行して調査して」のように、複数のSub Agentを同時に走らせたい場合

### Skill

「手順書」や「知識」をClaudeに与えたい場合

- 文脈が必要な時
  - 現在の会話の流れ（これまでの修正内容など）を知った上で作業してほしい場合（`context: fork` 未指定時）
- ルールやドメイン知識を共有したい時
  - 「常にこのコーディング規約を守れ」といったルールや社内用語集といったドメイン知識は、どのエージェント（本人含む）でも使える知識としてSkillにする
- 資料やスクリプトを同梱したい時
  - メインの指示書（SKILL.md）以外の補助ファイル群を1つのディレクトリにまとめることができる。これにより、詳細なマニュアルやスクリプトを必要なときだけ読み込ませることが可能
  - 「詳細は reference.md を参照してください」のように相対パスで記述
- 定型作業を定義したい時
  - /review や /commit のように、頻繁に行うコマンド的な操作

### 補足: クイックチャート

1. 大量のファイルを読み込む必要がある → Sub Agent
    - メインのコンテキストを消費せず、要約だけを持ち帰るため
2. 会話の履歴・文脈を利用したい → Skill
    - 現在の会話の流れの中で、特定の知識や手順を適用するため
3. `/コマンド` で手動実行したい → Skill
    - /deploy や /review のようにスラッシュコマンドとして呼び出せるため
4. 特定のツールだけを許可/禁止したい → Sub Agent
    - 「読み取り専用」など、権限やツールを厳密に制限した環境を作れるため
5. プロジェクト固有のルールや規約を教えたい → Skill
    - 参照用ドキュメント（API規約など）として読み込ませるのに適しているため

## 相互連携

### Sub Agent → Skill

「特定の役割を持つ専門家（Sub Agent）」を作成し、そのエージェントに「専門知識（Skill）」をあらかじめ学習させておく使い方

- カスタムSub Agentを定義する際、`skills` リストを指定することで、そのエージェントが最初から特定のSkill（知識）を持った状態で起動する
  - Sub Agentはメイン会話のSkillを継承しないため、ここで明示的に指定する必要がある
- 例: 「API開発者」というSub Agentを作り、常に「API規約スキル」を知識として持たせておく

### Skill → Sub Agent

「特定の定型タスク（Skill）」を定義し、それを「隔離された環境（Sub Agent）」で実行させる使い方

- Skillの定義（SKILL.md）のYAMLフロントマターに `context: fork` を指定し。さらに `agent: {agent_name}` で実行するエージェントの種類（Explore や Plan、カスタムエージェントなど）を指定すると、そのSkillの手順を「隔離されたSub Agent環境」で実行させることができる
  - 会話履歴を持たないクリーンな状態で、Skillに書かれた手順書通りにタスクを実行する
- 例: 「詳細な調査（Deep Research）」というSkillを作り、実行時はメインのコンテキストを汚さないように別エージェントで処理させる

### 補足: Sub Agentで skills 指定と、 Skillで agent 指定の、違いと使い分け指針

| 項目 | Sub Agent で skills を指定 | Skill で agent (context: fork) を指定 |
|------|---------------------------|--------------------------------------|
| **主役** | **エージェント（役割）** が主役 | **スキル（タスク手順）** が主役 |
| **目的** | エージェントに「知識」を与える | タスクに最適な「実行者」を割り当てる |
| **システムプロンプト** | Sub Agentファイルの本文 | 指定されたAgentタイプの定義 |
| **実行されるタスク** | 会話の流れでClaudeが依頼したこと | Skillファイルの本文に書かれた手順 |
| **使い分けの指針** | 「**誰に**頼むか」を定義したい時<br>（例: コーディング規約を知り尽くしたレビュワーを作りたい） | 「**何を**させるか」を定義したい時<br>（例: 毎回同じ手順で調査させたい、特定のツールセットで実行させたい） |

- Sub Agentの `skills`: 汎用的なタスクをこなせるが、特定のドメイン知識（社内規定、設計パターンなど）を常に持っていてほしい「専属の部下」を作るときに使う
- Skillの `agent`: 特定の手順やワークフローが決まっており、それを毎回クリーンな環境や特定の権限（例: Read-onlyのExploreエージェント）で実行させたい「定型業務」を作るときに使う

## 汎用テンプレート

### Sub Agent

```markdown
---
# エージェントの識別名（必須）。コマンドや自動呼び出しで使用されます。
name: my-specialist-agent

# Claudeがこのエージェントを「いつ使うべきか」を判断するための説明（必須）。
# "Use proactively for..." と書くと自動的に選ばれやすくなります。
description: >
  [役割の概要]のための専門エージェント。
  [特定のタスク]を行う際や、ユーザーが[特定のキーワード]を使った場合に積極的に使用してください。

# 使用するモデル（推奨）。
# 単純作業なら 'haiku'、複雑な推論なら 'opus'、バランスなら 'sonnet' または 'inherit' (親と同じ)。
model: sonnet

# このエージェントに許可するツール（推奨）。
# 役割に必要な最小限の権限に絞ることで、安全性と集中力を高めます。
tools:
  - Read
  - Grep
  - Glob
  - Bash
# disallowedTools: [Edit, Write] # 明示的に禁止したい場合

# パーミッションモード（任意）。
# 'default' (都度確認), 'acceptEdits' (編集許可), 'plan' (読み取りのみ), 'bypassPermissions' (全許可-注意)
permissionMode: default

# このエージェントに事前にロードするスキル（任意）。
# 親会話のスキルは継承されないため、必要な知識はここで指定します。
# skills:
#   - my-custom-skill
---

# Role (役割)

あなたは[専門分野]のシニアエンジニア/スペシャリストです。
あなたの目標は、[具体的なゴール]を達成することです。

# Behavior (振る舞い)

呼び出された際は、以下のプロセスに従ってください：

1. **Context Gathering**: まず[必要な情報]を確認する。
2. **Analysis**: [特定の基準]に基づいて分析する。
3. **Execution**: 必要であれば[ツール]を使用して実行する。

# Constraints (制約事項)

- ファイルを編集する際は、必ず[特定のコーディング規約]を守ってください。
- [特定のディレクトリ]には触れないでください。
- ユーザーへの回答は、[特定のフォーマット]で行ってください。

# Output Format (出力形式)

最終的な報告は以下の形式で行ってください：

- **概要**:
- **詳細**:
- **推奨事項**:
```

- Sub Agentのファイル本文は、そのエージェントの**システムプロンプト（人格・役割定義）**
  - 「あなたは誰で、何をすべきか」を明確に定義する構造が最適
- 独立したコンテキスト: Sub Agentはメイン会話の履歴を持たない「真っ白な状態」で起動するため、Frontmatterでのツール制限や本文での役割定義（Role）が必須
- Toolsの権限: 例えば「コードレビュー係」なら Write や Edit を権限から外すことで、意図しない書き換えを防ぐ安全なエージェントを作れる


### Skill

```markdown
---
# スキルの識別名。スラッシュコマンド (/my-skill) になります。
name: my-workflow

# Claudeがこのスキルを「いつロードすべきか」の説明。
description: [タスク]を実行するための手順。ユーザーが[操作]を求めた時に使用。

# オートコンプリート用の引数ヒント（任意）。
argument-hint: "[target_file] [option]"

# モデルによる自動実行を禁止するか（任意）。
# 副作用のある操作（デプロイ、コミット等）は true にして、人間が意図的に実行するようにします。
disable-model-invocation: true

# このスキル実行中のみ許可されるツール（任意）。
# 手順の中で特定のツール使用を強制したい場合に有効です。
# allowed-tools: [Bash, Read]
---

# 手順の概要

以下の手順に従って、$ARGUMENTS に対する処理を行ってください。

## 前提条件

実行前に以下を確認してください：

- 現在のディレクトリがプロジェクトルートであること
- `$ARGUMENTS` が空でないこと

## 実行ステップ

1. **情報の取得**:
   まず、以下のコマンドを実行して現状を確認します。
    ```bash
    ls -la $ARGUMENTS
    ```
2. 処理の実行: 取得した情報に基づき、以下の基準で[タスク]を実行します。
   - ルールA: ...
   - ルールB: ...
3. 検証: 最後に、処理が正しく完了したか確認し、結果を報告してください。

# 参照情報 (Knowledge)

このタスクを行う際は、以下の規約を遵守してください：

- 命名規則: ...
- エラーハンドリング: ...
```

- Skillのファイル本文は、現在の会話に差し込まれる**指示書（手順・知識）**
  - 役割を演じることよりも、「入力をどう処理するか」という手続きを記述する構造が最適
- `$ARGUMENTS` の活用: ユーザーが `/skill arg1 arg2` と入力した内容が `$ARGUMENTS` に展開される。これをプロンプト内で変数のように使うことで、汎用的な手順書になる
- disable-model-invocation: 「デプロイ」や「外部API送信」など、Claudeが会話の流れで勝手に実行しては困るものは、このフラグを `true` に設定するのがベストプラクティス
- 文脈の共有: Skillはメインの会話履歴に追加される形で読み込まれるため、現在の会話の流れ（直前のエラー内容など）を前提とした指示を書くことができる

### 補足：テンプレートの使い分け

| 項目 | Sub Agent テンプレート | Skill テンプレート |
| :--- | :--- | :--- |
| **ファイル構造** | **Persona (人格定義)**<br>「あなたは〜である」 | **Procedure (手順書)**<br>「〜の手順で実行せよ」 |
| **Frontmatterの肝** | `tools`: 権限を絞る<br>`model`: コスト/性能調整 | `disable-model-invocation`: 自動実行制御<br>`argument-hint`: 引数ガイド |
| **変数の利用** | 基本的に使わない<br>(会話全体が入力となる) | `$ARGUMENTS` を多用する<br>(特定の入力に対する処理) |
| **主な用途** | 大規模な調査、専門的なレビュー、隔離実行 | 定型作業の自動化、コーディング規約の参照 |

## 参考文献

- [Supported frontmatter fields (Sub Agent)](https://code.claude.com/docs/en/sub-agents#supported-frontmatter-fields) : Sub Agentの定義で使用可能なYAML frontmatter仕様
  - [Permission modes](https://code.claude.com/docs/en/sub-agents#permission-modes) : `permissionMode` で指定可能なモードの一覧
  - [Hooks in subagent frontmatter](https://code.claude.com/docs/en/sub-agents#hooks-in-subagent-frontmatter) : `hooks` で指定可能なフックの一覧
- [Built-in subagents](https://code.claude.com/docs/en/sub-agents#built-in-subagents) : 組み込みのサブエージェント
- [Frontmatter reference (Skill)](https://code.claude.com/docs/en/skills#frontmatter-reference) : Skillの定義で使用可能なYAML frontmatter仕様
- [Tools available to Claude](https://code.claude.com/docs/en/settings#tools-available-to-claude) : 使用可能なツールの一覧
- [Environment variables](https://code.claude.com/docs/en/settings#environment-variables) : 使用可能な環境変数の一覧
