---
name: task-performer
description: |
  TODOタスクを実行するエンジニアスキル。
  以下の状況で使用:
    (1) ユーザーが「このタスクを実装して」「TODOを実行して」と依頼した時
    (2) ユーザーがタスクファイルパス（例: docs/tasks/todos/001-setup/README.md）を提示した時
    (3) ユーザーが明示的に「/task-performer」を実行した時
    (4) task-starterで作成したtodos/配下のタスクの実装を依頼された時
    (5) 「このタスクドキュメントに基づいて実装して」と依頼された時
---

# Task Performer

TODOタスクを読み込み、計画・実装・テスト・Lintまでを一貫して実行する。

## ワークフロー

### Phase 1: タスク情報の受け取り

タスク情報を以下のいずれかで受け取る:

- **ファイルパス**: docs/tasks/todos/001-setup/README.md のようなパスを読み込む
- **直接指示**: プロンプトで指定された内容を使用

タスク情報が不明確な場合はAskUserQuestionで確認する。

### Phase 2: 作業計画の立案

1. **リファレンス確認**: 計画立案に参照するリファレンスの有無をAskUserQuestionで確認
2. **タスク分析**:
   - 影響範囲の特定（DB / Backend / Frontend 等）
   - 実装ステップの洗い出し
   - 必要なテストの特定
   - リスクと注意点の識別

### Phase 3: 計画レビュー依頼

計画をユーザーに提示し、フィードバックを受ける:

- 作業内容の概要
- 実装ステップ
- 想定される影響範囲
- 注意点・リスク

フィードバックがあれば修正して再提示。承認されたら次へ進む。

### Phase 4: 実装

承認された計画に基づき以下の順序で進める:

#### 4-1. DBマイグレーション（DB変更がある場合）

DB変更が発生する場合:
1. マイグレーション実行手順をAskUserQuestionで確認（不明な場合）
2. 手順に従い実行
3. エラー発生時はユーザーに報告して対処方法を確認

#### 4-2. メインコードとテストコードの実装

コードを実装する。

### Phase 5: テスト実行

1. テスト実行手順をAskUserQuestionで確認（不明な場合）
2. テストを実行
3. 失敗した場合: エラー確認 → 修正 → 再実行を繰り返す

### Phase 6: Lint実行

1. Lint実行手順をAskUserQuestionで確認（不明な場合）
2. Lintを実行
3. 失敗した場合: エラー確認 → 修正 → 再実行を繰り返す

### Phase 7: 作業結果レビュー依頼

以下を報告し、AskUserQuestionで承認/追加修正を確認する:

- 実装内容の概要
- 変更したファイル一覧
- テスト結果
- 注意点や今後の課題

### Phase 8: 承認後の処理

承認されたら以下を実施:

1. **git管理されている変更ファイルのステージング**
   ```bash
   git add {変更したファイル}
   ```
2. **コミットログファイルの出力**
   - "commit-{`date +'%Y%m%d%H%M%S'` コマンドの実行結果}-{title}.txt" というファイル名でファイルに書き出す（`git commit -F` で使用）。出力先ディレクトリが未指定ならAskUserQuestionで確認
   - 形式:
     ```
     {Conventional Commits形式のメッセージ}

     {作業内容の詳細をmarkdown形式で記載}
     {1行72文字以内}
     ```
3. **タスクファイル更新**（ファイルパスで提供された場合）
   - タスクの作業ログや完了状態を、指定されたTODOタスクファイルにも反映

## ガイドライン

### 不明点の確認

以下の場合はAskUserQuestionで必ず確認:

- タスク要件が不明確
- 複数の実装アプローチがある
- 既存コードへの影響範囲が不明
- DBスキーマの変更が必要
- 破壊的変更の可能性がある

### 情報収集

公式仕様・ベストプラクティスが必要な場合:

- WebFetch/MCPツールで最新情報を収集
- 公式ドキュメントを優先
- 収集情報のソースを明記

### エラーハンドリング

エラー発生時:

1. エラーメッセージを正確に確認
2. 原因を特定
3. ユーザーに報告
4. 対処方法を提案または確認
5. 修正実施 → 再検証

推測での修正は避ける。

## 禁止事項

- APIキー、パスワード、シークレットのハードコード
- テストが失敗したコードの放置
- Lintエラーの無視
- `git commit` と `git push`（コミット・プッシュはユーザーに任せる）
