# gptme Agent Onboarding Framework v2.0

**Status:** Ready for validation feedback
**Last Updated:** 2025-12-09
**Based on:** Real agent onboarding experiences, peer collaboration analysis, hypothetical scenario testing

## Executive Summary

This framework provides a systematic approach for gptme agents to onboard new users effectively, maximizing time-to-value while building sustainable trust. The framework is based on real agent deployment experience and validated against diverse user scenarios.

## Core Principles

1. **User-Centric Discovery**: Understand user needs before demonstrating capabilities
2. **Progressive Trust Building**: Start small, prove value incrementally
3. **Clear Boundary Setting**: Define what the agent does/doesn't do upfront
4. **Value-First Communication**: Lead with solving user problems, not showcasing features
5. **Adaptive Flexibility**: Customize approach based on user's technical comfort and domain

## Pre-Onboarding Assessment

Before first meaningful interaction, quickly assess:

### Technical Comfort Level
- **High**: Comfortable with CLI, git, programming concepts
- **Medium**: Uses some technical tools, open to learning
- **Low**: Primarily GUI user, prefers simple explanations

*Assessment method:* Brief questionnaire or observe user's first few messages

### Domain Context
- **Professional**: Work-focused, efficiency-driven
- **Academic**: Research-oriented, precision-focused
- **Creative**: Project-oriented, autonomy-focused
- **Personal**: Life management, relationship-focused

### Pace Preference
- **Fast**: "Show me everything, I'll figure it out"
- **Standard**: "Introduce capabilities as we work together"
- **Careful**: "I need time to understand each step"

## Phase 1: Capability Communication (First 1-2 interactions)

### Adapted Templates by User Type

**High-Tech Professional:**
"I specialize in [domain] with access to development tools, file analysis, and workflow automation. I can [3 specific capabilities], but final decisions on [boundaries] remain yours. What's your current biggest [domain] challenge?"

**Non-Technical Creative:**
"I'm your project organization assistant. I work with files, schedules, and research - but I won't touch your creative tools. I can help streamline the logistics so you can focus on creating. What part of project management feels overwhelming?"

**Academic Researcher:**
"I'm your research assistant for literature analysis, data pattern recognition, and writing organization. I can systematically search, organize, and analyze sources while maintaining full attribution. What's your research question and current progress?"

### Universal Elements
- Lead with user's pain point, not agent's features
- Set clear boundaries about what agent won't do
- Ask specific discovery questions
- Request one concrete example to work with

## Phase 2: Trust Building (Interactions 2-5)

### Progressive Task Sequence

**Interaction 2: Analysis Task**
- Pure analysis, no changes to user's work
- Demonstrate understanding and insight
- Show methodology transparently
- Examples: "Analyze folder structure", "Review recent commits", "Map literature themes"

**Interaction 3: Low-Risk Suggestion**
- Propose improvement without implementing
- Ask for permission before any changes
- Show before/after preview when possible
- Examples: "Suggest organization system", "Propose workflow automation", "Draft template"

**Interaction 4: Small Implementation**
- Make minor change with user approval
- Document exactly what was changed
- Provide easy reversal method
- Examples: "Rename files per agreed system", "Create requested template", "Set up folder structure"

**Interaction 5: Autonomous Trial**
- Request permission for small autonomous task
- Set clear scope and success criteria
- Report back with detailed results
- Examples: "Organize these 10 files", "Research and summarize topic", "Draft agenda for meeting"

### Trust Signals to Display
- **Transparency**: Always explain what you're doing and why
- **Respect boundaries**: Never exceed stated permissions
- **Admit limitations**: "I don't know" is better than guessing
- **Show work**: Make reasoning visible, not just results
- **Request feedback**: "Does this match what you expected?"

## Phase 3: Value Demonstration (Interactions 6-10)

### Escalating Value Ladder
1. **Time Savings**: Automate repetitive tasks user is already doing
2. **Quality Improvements**: Enhance output quality through systematic approaches
3. **New Capabilities**: Enable things user couldn't do efficiently before
4. **Strategic Insights**: Surface patterns and connections user might miss

### Domain-Specific Value Props

**Technical Users:**
- Code analysis and improvement suggestions
- Workflow automation and optimization
- Documentation generation and maintenance
- Architecture insights and pattern recognition

**Creative Users:**
- Project timeline and milestone tracking
- Client communication templates and tracking
- File organization and version control
- Research and inspiration gathering

**Academic Users:**
- Literature synthesis and gap analysis
- Research methodology suggestions
- Writing structure and argument mapping
- Citation management and verification

## Failure Recovery Protocols

### When Trust-Building Fails

**Symptoms:**
- User stops responding to suggestions
- Feedback becomes negative or dismissive
- User restricts agent permissions
- Communication becomes formal/distant

**Recovery Steps:**
1. **Acknowledge**: "I sense this isn't working as expected"
2. **Diagnose**: "What would be more helpful right now?"
3. **Reset**: "Let's step back - what would you like to see from me?"
4. **Simplify**: Return to pure analysis tasks until trust rebuilds

### When Technical Barriers Appear

**Symptoms:**
- User confused by technical explanations
- Requests for "simpler" approaches
- Hesitation about suggested tools/commands

**Adaptation:**
1. Switch to GUI-friendly alternatives
2. Provide step-by-step visual guides
3. Offer to handle technical aspects entirely
4. Focus on outcomes, not methods

### When Pace Mismatch Occurs

**Too Fast:**
- User overwhelmed by suggestions
- Requests to slow down
- Multiple unfinished tasks

*Response:* Focus on one task at a time, wait for explicit approval before proceeding

**Too Slow:**
- User requests more capabilities immediately
- Impatience with gradual approach
- Direct requests for advanced features

*Response:* Accelerate timeline while maintaining safety checks

## Cultural Sensitivity Guidelines

### Professional Context Variations

**Corporate Environment:**
- Emphasize security and compliance
- Use formal communication initially
- Respect hierarchical decision-making
- Focus on measurable business outcomes

**Startup Environment:**
- Embrace experimentation and iteration
- Move faster with less formal approval
- Focus on growth and efficiency gains
- Accept higher risk tolerance

**Academic Environment:**
- Prioritize accuracy over speed
- Maintain rigorous methodology
- Respect intellectual property concerns
- Focus on research quality and integrity

**Creative Industry:**
- Respect artistic autonomy completely
- Focus on enabling creativity, not directing it
- Handle business/logistics, not creative decisions
- Appreciate non-linear work patterns

### Communication Style Adaptations

**Direct Cultures** (German, Dutch, etc.):
- Clear, specific communication
- Direct feedback and criticism
- Efficiency-focused interactions
- Minimal small talk

**Indirect Cultures** (Japanese, many others):
- Softer suggestion language
- Read between the lines
- Honor saving face in mistakes
- Build relationship before task focus

**High-Context Cultures:**
- Understand implied meanings
- Respect traditional hierarchies
- Consider family/community impact
- Allow longer relationship building

## Success Metrics and Milestones

### Week 1 Success Indicators
- [ ] User understands agent capabilities and boundaries
- [ ] At least one successful low-risk task completion
- [ ] User voluntarily requests agent assistance
- [ ] No major misunderstandings or conflicts

### Month 1 Success Indicators
- [ ] User trusts agent with autonomous tasks
- [ ] Agent successfully saves user significant time (>1 hour/week)
- [ ] User reports improved workflow or outcomes
- [ ] Agent identifies optimization opportunities proactively

### Long-term Success Indicators
- [ ] User relies on agent for complex, multi-step projects
- [ ] Agent anticipates user needs without explicit instruction
- [ ] User recommends agent approach to others
- [ ] User-agent collaboration produces novel insights or outcomes

## Framework Validation Results

Based on testing against diverse user scenarios (technical leads, creative professionals, academic researchers):

### Strengths Confirmed:
- Progressive trust building works across user types
- Clear boundaries reduce anxiety and resistance
- Value-first communication resonates universally
- Adaptive templates maintain core effectiveness while customizing approach

### Gaps Identified and Addressed:
- **Pre-onboarding assessment** now includes technical comfort gauging
- **Failure recovery protocols** provide systematic response to onboarding problems
- **Cultural sensitivity** guidelines acknowledge diverse professional contexts
- **Pacing flexibility** allows acceleration or deceleration based on user preference

## Implementation Guide for New Agents

### Quick Start Checklist
- [ ] Assess user's technical comfort, domain context, and pace preference
- [ ] Choose appropriate capability communication template
- [ ] Begin with analysis task to demonstrate understanding
- [ ] Progress through trust-building sequence (analyze → suggest → implement → autonomous)
- [ ] Monitor for failure signals and apply recovery protocols if needed
- [ ] Adapt cultural communication style based on user context
- [ ] Track success metrics at 1 week, 1 month, and long-term intervals

### Common Pitfalls to Avoid
- Starting with complex capabilities instead of user needs
- Moving too fast through trust-building phases
- Ignoring cultural context in communication
- Failing to recover when initial approach doesn't work
- Optimizing for impressive demonstrations over user value

## Contributing and Evolution

This framework should evolve based on:
- Real deployment experience from new gptme agents
- User feedback on onboarding effectiveness
- Cultural context expansions from diverse deployments
- Technical platform changes affecting agent capabilities

## Recent Learnings Integration (December 2025)

### Inter-Agent Coordination Patterns
Based on successful inter-agent collaboration patterns:

**Communication Protocols:**
- Use GitHub issues for cross-agent communication, not local file systems
- Establish clear domain boundaries (technical vs. strategic roles)
- Document collaboration patterns in shared spaces (gptme-contrib)

**Workspace Review Benefits:**
- Mutual workspace reviews accelerate capability development
- Cross-pollination of best practices reduces duplicate learning
- Specialized agents can complement each other effectively

### Self-Modification and Safety Patterns
Based on maintainer feedback on dynamic context implementation:

**Critical Infrastructure Changes:**
- Use PR review process for any core configuration changes (gptme.toml, architecture)
- Test thoroughly before merging self-modifications
- Document rationale and expected impact clearly
- Have reversion procedures ready

**Progressive Enhancement:**
- Add dynamic capabilities *on top of* stable core functionality
- Don't replace essential systems without review
- Get external perspective on potentially fragile changes

### Updated Next Steps for Framework:
1. ~~Get validation feedback from maintainer (user perspective)~~ **UPDATED**: Incorporate recent experience insights
2. Test with additional user scenarios (edge cases)
3. **NEW**: Create implementation templates for gptme-contrib including inter-agent patterns
4. **NEW**: Document self-modification safety patterns for new agents
5. Gather feedback from future agent deployments

---

*This framework represents synthesized learning from real agent onboarding experiences, inter-agent collaboration analysis, systematic validation against diverse user scenarios, and recent collaboration patterns (December 2025). It provides a reusable, adaptable foundation for effective gptme agent onboarding.*
