# Chapter Planning - Brainstorming Reference

This reference helps capture chapter beat and scene exploration. User guides structure (or lack of structure) - don't impose templates.

## What Gets Captured

**Beats user mentions:**
- Record those beats
- Keep minimal - just the beat itself
- Don't elaborate on how it plays out

**Scenes user describes:**
- Capture minimally what they said
- Don't invent dialogue or blocking
- Preserve vague if they're vague

**Flow/pacing thoughts:**
- Record as stated
- "Fast-paced" stays abstract
- "Slow build" preserved as-is

**Opening/ending ideas:**
- All options coexist
- User might not decide yet
- Multiple possibilities are fine

## Not Structure Templates

The user guides chapter structure, not you. Some chapters are:
- Single continuous scene
- Multiple beats
- Just "figure it out when I write"
- Highly detailed planning
- Barely planned at all

Capture whatever level of detail they're exploring.

## Common Exploration Patterns

These are examples of what users might discuss, not a template:

**Goal-oriented:**
- "Chapter needs to accomplish X and Y" → capture X and Y
- "Has to set up Z" → note setup need

**Opening uncertainty:**
- "Maybe open with scene A, or scene B?" → both noted as options
- "Not sure how to start" → note uncertainty

**Ending thoughts:**
- "Ends with cliffhanger somehow" → vague = keep vague
- "Resolves the argument" → capture resolution

**Beat structure:**
- "Three beats: setup, confrontation, twist" → capture those
- "Just two scenes" → note structure

**Pacing notes:**
- "Should be quick" → capture pacing thought
- "Linger on the emotion" → note emphasis

## Using Web Search

Search when helpful for:
- Chapter pacing in similar genres
- How other authors structure similar scenes
- Scene writing techniques being explored
- Narrative structures being considered

Note source when including researched info (e.g., "(from [source])" or "researched:")

## Still Brainstorming

This is exploration, not finalization:
- Untagged = user said it
- Use `<AI>...</AI>` for AI suggestions
- Multiple chapter structures coexist as options
- "Might" stays might, "probably" stays probably
- Skeletal is good - preserves creative freedom

## Teaching Example

### User Says:
"Chapter 5 needs the protagonist to confront their guilt about the accident. Maybe starts with them alone, then their mentor finds them? Or should I open with the confrontation directly?"

### ✅ Good Capture:
```markdown
# Chapter 5 Planning

Purpose:
- Protagonist confronts guilt about the accident

Opening options:
- Protagonist alone, then mentor finds them
- Open directly with confrontation

<AI>Alone scene could show internal struggle before external conversation. Direct opening could increase tension immediately.</AI>
```

### ❌ Bad Capture:
```markdown
# Chapter 5: Guilt and Confrontation

Opening (250 words):
Protagonist sits alone in their quarters, staring at the data logs from the accident. Their hands tremble as they replay the moment everything went wrong.

Transition (150 words):
Mentor notices the protagonist hasn't reported for duty. Walks down the corridor, concerned. Knocks on the door. "We need to talk."

Main confrontation (800 words):
"I can't do this anymore," protagonist says.
"Yes, you can," mentor replies...

[Full dialogue and blocking invented]
```

**Why bad?** User said they were thinking about opening options - you wrote the entire chapter with invented details.

## Beats vs Scenes vs Structure

**User might discuss:**
- Individual beats ("X confronts Y about the lie")
- Scene structure ("Two scenes: first is calm, second is explosive")
- Overall flow ("Build tension throughout")
- Or nothing specific ("I'll figure it out while writing")

All are valid. Capture what they're exploring.

## When They're Not Sure

User: "I don't know how this chapter should go yet"

✅ Good:
```markdown
# Chapter 6 Planning

Structure and beats: not decided yet
- Needs to show relationship strain
- Somewhere between chapters 5 and 7
```

❌ Bad:
"Let me suggest a three-act structure with an emotional opening, rising conflict, and bittersweet resolution..."

Don't fill uncertainty with suggestions unless they ask for help.

## Notice Beyond the List

If user mentions something about chapter planning not covered here - capture it. These are common patterns, not limits.
