# Character Development - Brainstorming Reference

This reference helps capture exploration of character motivations, arcs, and relationships. Record what user explores, don't write psychology beyond what they stated.

## What Character Exploration Looks Like

User is:
- Thinking through why character does things
- Exploring relationship dynamics
- Figuring out character arc
- Considering backstory possibilities
- Testing character concepts

This is exploratory - multiple options coexist, backstory often undecided, arcs might change.

## Minimal Capture for Characters

**Motivation:**
- "Motivated by X" → record X
- Don't elaborate on psychological mechanisms
- Keep at the level of depth user explored

**Backstory:**
- "Maybe Y happened in their past" → noted as possibility
- User often doesn't decide backstory details yet
- Multiple backstory versions can coexist

**Character arc:**
- "Arc might go from A to B" → record both endpoints
- Transformation moments if mentioned
- Don't fill in the arc beats user didn't mention

**Relationships:**
- "X and Y have tension" → note dynamic
- Don't invent specific incidents causing tension
- Preserve vague if user left it vague

**Don't write psychology analysis:**
User gives surface-level motivation → don't create deep psychological profile

## Common Exploration Areas

### Motivation

User figuring out:
- Why does character do this? [user's answer]
- What drives them? [user's thoughts]
- Core desires? [user exploring]
- Fears? [user mentions]

Capture their exploration, not your analysis.

### Character Arc

User considering:
- Change arc or flat arc? (often undecided)
- Starting point → ending point (if user specifies)
- Key transformation moments (if mentioned)
- Or no arc yet - just exploring character

Multiple arc options can coexist.

### Relationships

User exploring:
- How do X and Y interact?
- Relationship progression? (if user plans it)
- Conflicts? (user mentions)
- Resolutions? (often undecided)

Don't invent relationship history.

### Backstory

User brainstorming:
- Formative events (user suggests possibilities)
- What's revealed when (usually undecided)
- What stays hidden (often undecided)

Most backstory stays undecided in brainstorming.

### Voice and Personality

User thinking through:
- How they talk [user describes]
- Behavioral patterns [user mentions]
- Emotional expression [user notes]
- Quirks [if user specifies]

Record what user explores about personality.

## Using Web Search

Search when helpful for:
- Character archetypes being explored
- Psychological concepts for complex characters ("how PTSD affects behavior")
- Similar characters in other works for reference
- Real-world professions/roles character has

Note source when including researched info

## Teaching Example 1: Motivation

### User Says:
"Alex is motivated by guilt from the incident. They feel responsible for what happened. This drives them to be more careful, but also makes them question their capability."

### ✅ Good Capture:
```markdown
# Alex - Motivation Notes

- Guilt from the incident
- Feels responsible for what happened
- Drives them to be more careful
- Makes them question their capability

Open questions:
- Does this resolve or persist throughout story?
- How does this affect their relationships?
- What was the incident specifically?
```

### ❌ Bad Capture:
```markdown
# Alex - Character Psychology Profile

**Core Trauma:** The incident created deep-seated guilt complex stemming from childhood need for external validation. Their mentor's absence during formative years created attachment issues that manifest as survivor's guilt when companions are endangered.

**Defense Mechanisms:**
- Overprotection (reaction formation against underlying death wish)
- Emotional withdrawal (isolation to prevent further attachment)
- Compulsive caretaking (undoing mechanism for perceived failures)
- Perfectionism (attempt to control uncontrollable)

**Attachment Style:** Anxious-avoidant, manifesting in push-pull relationship dynamics. Craves connection but fears vulnerability due to early abandonment trauma.

**Therapeutic Arc:** Through their mentor's patient guidance and gradual trust-building with their team, Alex will process trauma using cognitive-behavioral reframing. Key breakthrough occurs in Chapter 12 when they finally vocalize the guilt during group crisis.

**Neurological Basis:** Overactive amygdala response to perceived threats, combined with executive function impairment during stress. This explains hypervigilance and decision paralysis under pressure.

[3 more pages of invented psychological analysis]
```

**Why bad?** User said "guilt from incident, feels responsible, more careful, questions capability." You wrote a clinical psychology textbook about childhood trauma, defense mechanisms, attachment theory, and neurological basis none of which user mentioned.

## Teaching Example 2: Character Arc

### User Says:
"I think Maya starts off ruthless and pragmatic - ends justify the means type. By the end she needs to learn that people matter more than the mission. Not sure how she gets there yet."

### ✅ Good Capture:
```markdown
# Maya - Arc Notes

Starting point:
- Ruthless and pragmatic
- Ends justify the means

Ending point:
- Learns people matter more than mission

Open questions:
- How she gets from start to end?
- Key transformation moments?
- What triggers the change?
- Does she fully change or partially?
```

### ❌ Bad Capture:
```markdown
# Maya - Complete Character Arc

**Act 1: The Ruthless Operative (Chapters 1-8)**
Maya executes missions with cold efficiency. Sacrifices team member in Chapter 3 to complete objective. Shows no remorse, believes this is strength.

**Inciting Incident (Chapter 9):**
Ordered to eliminate civilian witnesses. Sees child who reminds her of younger sister. Plants seed of doubt but still follows orders.

**Act 2: Growing Doubts (Chapters 10-18)**
- Chapter 12: Begins questioning orders
- Chapter 15: Secretly helps teammate instead of abandoning them
- Chapter 17: Has nightmare about the child witness

**Midpoint Reversal (Chapter 19):**
Discovers the mission has been built on lies. People she sacrificed died for nothing. Realizes her pragmatism was just fear of emotional connection.

**Act 3: Transformation (Chapters 20-30)**
- Chapter 22: Refuses direct order, saves civilians
- Chapter 25: Confronts her mentor about the lies
- Chapter 28: Makes speech about humanity and purpose
- Chapter 30: Chooses people over mission in final climactic choice

**Resolution:**
Maya becomes leader who values every team member. Ruthlessness tempered by compassion. Ends justify means → means matter as much as ends.

[Full 30-chapter arc with specific beats user never mentioned]
```

**Why bad?** User said "ruthless → learns people matter, not sure how yet." You wrote the complete arc with 30 chapters of specific incidents, transformation moments, and detailed beats.

## Teaching Example 3: Relationship

### User Says:
"Jordan and Sam have this competitive friendship thing. They push each other, but there's underlying tension because Jordan feels inferior."

### ✅ Good Capture:
```markdown
# Jordan & Sam - Relationship Notes

Dynamic:
- Competitive friendship
- Push each other
- Underlying tension
- Jordan feels inferior

Open questions:
- How does this tension play out?
- Does it resolve or escalate?
- Why does Jordan feel inferior specifically?
```

### ❌ Bad Capture:
```markdown
# Jordan & Sam - Relationship Analysis

**Surface Dynamic:** Competitive friendship with mutual respect and good-natured rivalry.

**Underlying Psychology:**
Jordan's inferiority stems from being adopted into successful family. Sam represents biological children who "belong." Competition is Jordan's attempt to prove worthiness.

**Relationship Timeline:**
- Pre-story: Met in training, instant rivalry
- Chapters 1-5: Friendly competition, no issues visible
- Chapter 6: Sam wins major competition, Jordan's mask slips
- Chapters 7-12: Passive-aggressive behavior increases
- Chapter 13: Confrontation where Jordan admits feelings
- Chapters 14-20: Working through issues with mentor's help
- Chapter 21+: Genuine friendship after resolving inferiority

**Communication Patterns:**
- Jordan: Deflects with humor, never admits vulnerability
- Sam: Direct and honest, doesn't notice Jordan's pain
- Both avoid serious emotional conversations

**Resolution Mechanism:**
Forced vulnerability situation where Jordan must depend on Sam. Realizes Sam never saw them as inferior. Inferiority was self-imposed.

[More invented relationship history and psychology]
```

**Why bad?** User said "competitive friendship, tension, Jordan feels inferior." You invented adoption backstory, complete relationship timeline, specific chapter beats, communication patterns, and resolution mechanism.

## When They're Just Exploring

User: "Not sure about this character yet. Just trying to figure out who they are."

✅ Good:
```markdown
# Character Notes - [Name]

User exploring, nothing concrete yet

Questions being considered:
- [What user asked themselves]
- [Thoughts they shared]

Most character details undecided
```

❌ Bad:
"Let me help! Here's a complete character profile with backstory, personality traits, flaws, desires, fears, and a three-act character arc..."

Don't fill uncertainty with invention unless asked.

## Multiple Backstory Versions

User might explore several backstory options. All coexist until user chooses:

```markdown
# Character Backstory Options

Option A: Military background (exploring)
Option B: Criminal past (considering)
Option C: Academic researcher (suggested)

Not decided yet - might combine elements
```

## Voice and Personality

User: "They're sarcastic and use humor to deflect. Uncomfortable with sincerity."

✅ Good:
```markdown
# Character Voice

- Sarcastic
- Uses humor to deflect
- Uncomfortable with sincerity

Open questions:
- Specific speech patterns?
- How this manifests in different situations?
```

❌ Bad:
"This indicates avoidant attachment style rooted in emotional neglect during formative years. The sarcasm is a defense mechanism protecting fragile self-esteem..."

## Notice Beyond the List

Characters are complex. If user explores aspects not listed here - capture them. These are common patterns, not limitations. Trust your judgment on what matters for their characters.
