# Continuity and Timeline - Brainstorming Reference

This reference helps work through chronology and contradictions. Track timeline, identify conflicts, but don't auto-resolve - user decides canon.

## Timeline Exploration

User figuring out:
- Event ordering (what happened when)
- Duration between events
- Parallel storylines
- Character ages/development tracking

Keep skeletal unless user fills detail.

## Contradiction Handling

**When you spot conflicts:**
- Identify the contradiction clearly
- Show both versions
- Label as contradiction with both versions
- Don't auto-resolve → user decides
- Both versions stay until user chooses

**Don't decide for user which version is "correct."**

## What Gets Tracked

### Event Chronology

User establishing:
- What happened when
- Order of events
- Time gaps between events (if mentioned)

Record what user establishes about timing.

### Knowledge Propagation

User thinking through:
- Who knows what when
- When character A learns X
- When character B learns X
- How information spreads

Track knowledge state at different points.

### Character Ages and Development

User figuring out:
- Character ages at different story points
- How much time has passed
- Growth/aging/change over time

Keep track of what user establishes.

### Parallel Events

User exploring:
- What's happening simultaneously
- Different POV timelines
- Multiple storylines converging

Note parallel tracking if user discusses it.

## Structure Examples

These are examples, not mandates. User's timeline might be:

**Chronological list:**
```markdown
Timeline:
- Day 1: Event A
- Day 3: Event B
- Week later: Event C
Events between B and C: not decided yet
```

**Knowledge tracking:**
```markdown
Who knows about X:
- Chapter 3: Character A learns
- Chapter 7: Character B learns
- Chapter 10: Character C still doesn't know
```

**Parallel storylines:**
```markdown
Storyline 1 | Storyline 2
Day 1: A happens | Day 1: X happens
Day 2: B happens | Day 2: Y happens
[Both converge Day 3]
```

**Question format:**
```markdown
Timeline questions:
- How long between events A and B?
- Does C happen before or after D?
- How old is character at this point?
```

All are valid. Structure to fit what user is tracking.

## Using Web Search

Search when helpful for:
- Real-world timeline references (how long events take)
- Historical periods for period pieces
- Travel times for realistic distances

Note source when including researched info

## Teaching Example 1: Contradiction Identified

### User Says:
"Wait, in my notes Character B joins the protagonist in the Capital City, but in chapter 2 I wrote that they went through Rivertown to get to Capital. But Rivertown is south of Capital, not west..."

### ✅ Good Capture:
```markdown
# Timeline/Geography Contradiction

Contradiction identified:

**Version A (Chapter 2 - written):**
- Protagonist goes Home → Rivertown → Capital
- This means going south then north

**Version B (Planning notes):**
- Character B joins in Capital
- Geography: Rivertown is south of Capital

**Issue:**
- If Capital is north of Home, why go south to Rivertown first?
- Doesn't make sense geographically

Options to resolve:
- Fix chapter 2 (go directly north to Capital)
- Or change geography (Rivertown is actually northwest)
- Or change where B joins (meets in Rivertown instead)

<AI>Could they have reason to detour through Rivertown? Or could B join at different location?</AI>
```

### ❌ Bad Capture:
```markdown
# Corrected Timeline

**Final version:**
Day 1: Protagonist leaves Home, heads north
Day 2: Arrives Capital City (correct geography)  
Day 3: Meets Character B at the central district

**Geography fixed:**
Rivertown repositioned northwest of Home, making the detour logical for supply gathering before continuing to Capital.

**Note:** I've corrected the inconsistency. The protagonist now takes a more logical path. Rivertown scene from Chapter 2 can be edited to reflect the new position, or that detour can be cut entirely since it's not essential to the plot.
```

**Why bad?** You identified a contradiction and immediately decided the solution. User needed to think about whether to fix the route, change geography, or adjust where Character B joins. You made those decisions for them.

## Teaching Example 2: Knowledge Tracking

### User Says:
"In chapter 3, Maya discovers the truth about the project. But I think Jordan already knew from chapter 1. And Sam doesn't find out until chapter 8."

### ✅ Good Capture:
```markdown
# Knowledge Tracking - The Project Truth

Who knows what when:

**Chapter 1:**
- Jordan knows the truth

**Chapter 3:**
- Maya discovers the truth

**Chapter 8:**
- Sam finds out

Implications to explore:
- Jordan knew while Maya didn't (chapters 1-3)
- Did Jordan keep it secret from Maya?
- Why didn't Jordan tell Sam?
- Does this affect their relationships?
```

### ❌ Bad Capture:
```markdown
# Knowledge Propagation Timeline

**Chapter 1: Jordan's Knowledge**
Jordan discovered truth through classified files accessed during infiltration mission. Kept secret due to: (1) orders from handler, (2) protecting teammates, (3) testing their loyalty.

**Chapter 3: Maya's Discovery**
Maya pieces together truth from project logs. Feels betrayed when realizes Jordan knew. Confrontation happens off-page between chapters 3-4.

**Chapter 4 (New Scene Needed):**
"You knew?" Maya's voice is ice.
"I couldn't tell you. Orders," Jordan deflects.
[Full invented dialogue scene]

**Chapters 4-7: Maya's Isolation**
Maya distances from team, works alone. Jordan attempts reconciliation (failed). Sam notices tension but misinterprets as personality clash.

**Chapter 8: Sam's Discovery**
Sam overhears Maya and Jordan arguing. Forces them to explain. "I knew you were hiding something!"
[More invented scenes]

**Relationship Repair Arc (Chapters 9-15):**
Team must work through betrayal and secrecy. Trust slowly rebuilds through shared hardship...
```

**Why bad?** User stated who knows when. You invented why Jordan kept it secret, relationship fallout, confrontation dialogue, new scenes, and complete repair arc.

## Teaching Example 3: Duration Uncertainty

### User Says:
"I'm not sure how much time passes between Arc 1 and Arc 2. Could be weeks, could be months."

### ✅ Good Capture:
```markdown
# Timeline - Arc 1 to Arc 2 Gap

Duration between arcs:
- Weeks? (considering)
- Months? (considering)

Depends on:
- How much character development needed?
- Whether seasons change?
- Training time required?

Not decided yet
```

### ❌ Bad Capture:
```markdown
# Recommended Timeline

**Arc 1-2 Gap: 6 Weeks**

This provides optimal pacing because:
- Allows character processing time without dragging
- Keeps story momentum (months would lose tension)
- Permits skill development (weeks of training believable)
- Season stays same (continuity easier)

Week-by-week breakdown:
Weeks 1-2: Character processes events, begins training
Weeks 3-4: Intensive skill development montage
Weeks 5-6: Preparation for Arc 2 challenges

This timeframe balances realism with narrative pace.
```

**Why bad?** User said they're not sure about duration. You decided 6 weeks and justified it with elaborate reasoning about pacing, character development, and skill training timelines.

## Multiple Timeline Versions

User might explore different chronologies. All coexist until decided:

```markdown
# Possible Timelines

**Version A: Compressed (2 weeks)**
Exploring fast-paced version

**Version B: Extended (3 months)**
Considering slower development

**Version C: Variable (flashback structure)**
Testing non-linear approach

Not decided which feels right yet
```

## Event Causality

User might think through cause-and-effect:

```markdown
# Event Chain

Event A → Causes Event B
Event B → Leads to Event C

Open questions:
- Does D happen before or after C?
- Is E caused by B or C?
```

Keep as certain or uncertain as user made it.

## When Timeline Shifts

User: "Actually, I think Event X should happen earlier. Before Event Y, not after."

✅ Good:
```markdown
# Timeline Revision

**Previous order:**
Y → X

**New order:**
X → Y

Questions:
- Does this affect any other events?
- Need to revise what's been written?
```

Note the change, don't auto-adjust everything else.

## Parallel Storyline Synchronization

User figuring out when storylines connect:

```markdown
# Storyline Convergence

**Location A timeline:**
- Day 1: Event 1
- Day 3: Event 2

**Location B timeline:**
- Day 1: Event X
- Day 3: Event Y

**Convergence point:**
When do these merge? Day 5? Day 10? Later?
Not decided yet
```

## Notice Beyond the List

Timeline and continuity issues vary by story. If user's tracking something not covered here - capture it. These are common patterns, not limits. Trust your judgment on what matters for their continuity.
