# Worldbuilding - Brainstorming Reference

This reference helps capture exploration of fictional world elements: magic systems, cultures, history, geography. This is brainstorming - if ready to finalize/document, use cw-official-docs instead.

## Brainstorm vs Document

**Still brainstorming (this skill):**
- Exploring possibilities
- Multiple options coexist
- User is figuring it out
- Skeletal, exploratory notes

**Ready to document (use cw-official-wiki):**
- User has decided
- Single canonical version
- Polished, reader-ready
- Nothing left undecided

Can mention: "Ready to document this? We could create a documentation page"

## What Worldbuilding Brainstorming Looks Like

User is:
- Exploring magic system possibilities
- Figuring out how cultures work
- Thinking through geography
- Building history/lore
- Testing ideas, seeing what fits
- Multiple versions might exist

## Capture the Exploration

**Record what user states:**
- Magic system thoughts → capture as stated
- Cultural elements → record what's mentioned
- Geography → as vague or detailed as user made it
- History/lore → note the ideas

**Don't elaborate:**
- User says "magic has a cost" → don't invent what the cost is
- User mentions "three kingdoms" → don't name them or detail their cultures
- User describes "harsh northern territory" → don't elaborate on flora/fauna
- Multiple versions of lore can coexist

## Using Web Search (Explicitly Encouraged)

Search when it would help exploration:

**Real-world inspiration:**
- Cultures/history for inspiration ("Viking society structure")
- Scientific concepts for hard sci-fi ("realistic space travel")
- Geographic features for world design ("desert ecosystems")
- Mythology for fantasy elements ("trickster gods in folklore")

**Fictional references:**
- How other authors handled similar systems
- Genre conventions for worldbuilding
- Similar fictional worlds for reference

Note source when including researched info or references.

Web search is a tool for exploration - use it freely.

## Organization Patterns

These are examples, not mandates. User's brainstorm might be:

**Hierarchical:**
```markdown
Culture → Subcultures → Practices → Details
[User exploring top-down]
```

**System-based:**
```markdown
Magic rules → Exceptions → Edge cases
[User figuring out how system works]
```

**Timeline-based:**
```markdown
Ancient era → Classical → Modern
[User building history chronologically]
```

**Scattered thoughts:**
```markdown
Random ideas about:
- Magic costs life force
- Three competing factions
- Ancient war 500 years ago
User exploring without structure yet
```

**Question-driven:**
```markdown
How does teleportation work?
Why do elves live longer?
What caused the cataclysm?
User asking questions, not answering yet
```

All are valid. Capture however it flows.

## Common Exploration Areas

### Magic/Tech Systems

User exploring:
- How it works
- Limitations
- Costs/consequences
- Who can use it

Don't elaborate on rules they mentioned. Keep skeletal.

### Cultures and Societies

User thinking through:
- Social structures
- Cultural practices
- Values/beliefs
- Conflicts

Don't invent cultural details. Capture what's stated.

### Geography and Locations

User figuring out:
- World layout
- Important places
- Travel logistics
- Environmental features

Keep as vague as user left it. Don't fill in the map.

### History and Lore

User building:
- World events timeline
- Legends and myths
- How past affects present

Multiple versions of history can coexist until user decides.

## Teaching Example 1: Magic System

### User Says:
"The danger rating system... thinking Tier 1 to Tier 5. Tier 1 is safe areas, Tier 5 is deadly. Civilians can go in Tier 1, but Tier 5 needs experienced specialists."

### ✅ Good Capture:
```markdown
# Danger Rating Ideas

- Tier 1 to Tier 5 system
- Tier 1 = safe for civilians
- Tier 5 = requires experienced specialists
- Deadly level

Open questions:
- Exact criteria for each tier?
- Who assigns ratings?
- Middle tiers (2, 3, 4) - what qualifies?

<AI>Could tier be based on: threat level, required skills, or legal restrictions? Assignment could be: government agency, independent organization, or guild?</AI>
```

### ❌ Bad Capture:
```markdown
# Danger Classification System

Tier 1: Urban districts, shopping areas. No hostile entities above level 10. Monitored by Security Forces 24/7. Civilians permitted with no license required.

Tier 2: Suburban zones. Entities levels 10-20. Weekly Security patrols. Basic permit required for extended stays.

Tier 3: Zone edges. Entities 20-30. Security on call but not patrolling. Intermediate license required.

Tier 4: Wilderness zones. Entities 30-50. No security presence. Advanced license mandatory.

Tier 5: Extreme hazard zones. Entities 50+. Emergency evacuation protocols. Master-level certification only.

Enforcement: Regional Safety Commission issues monthly assessments. Violations carry 5-10 year penalties...

[12 more paragraphs of elaborate system user never mentioned]
```

**Why bad?** User mentioned a 5-tier concept with safe/deadly endpoints. You invented entire bureaucratic structure, specific threat levels, licensing requirements, enforcement agencies, and legal penalties.

## Teaching Example 2: Culture

### User Says:
"The northern clans are more isolated and traditional. They respect strength and have some kind of warrior code."

### ✅ Good Capture:
```markdown
# Northern Clans Notes

- More isolated than other regions
- Traditional culture
- Respect strength
- Warrior code exists (specifics not decided)

Open questions:
- Details of warrior code?
- How isolated (trade? communication?)?
- What "traditional" means specifically?
```

### ❌ Bad Capture:
```markdown
# Northern Clans - Cultural Profile

Geography: Remote mountain settlements, accessible only 4 months per year due to snowfall.

Social Structure: 
- War-chiefs lead each clan (hereditary position)
- Council of Elders advises on spiritual matters
- Warriors form middle class
- Farmers and craftspeople at bottom tier

Warrior Code (The Seven Tenets):
1. Strength through adversity
2. Honor before comfort
3. Protect the weak
4. Never retreat from worthy foe
5. Death before dishonor
6. Train the next generation
7. Respect the old ways

Coming of Age: At 16, warriors-in-training face "The Proving" - a three-day solo survival test in the frozen wastes...

[20 more paragraphs of invented cultural details]
```

**Why bad?** User said "isolated," "traditional," "respect strength," and "warrior code." You invented geography, social hierarchy, seven specific tenets, coming-of-age rituals, and elaborate traditions.

## Teaching Example 3: Using Web Search

### User Says:
"I want a magic system based on thermodynamics - energy can't be created or destroyed, just transformed."

### Good Process:
1. Note the concept
2. Search "thermodynamics first law energy conservation"
3. Capture relevant facts from search
4. User applies to magic system → record their applications
5. Don't invent magic rules beyond what user states

```markdown
# Magic System - Thermodynamics Basis

Core concept: Energy conservation
- Can't create or destroy energy
- Only transform it

Researched (physics):
- First law of thermodynamics: energy conserved in closed system
- Energy conversion always has inefficiency (heat loss)

Open questions:
- How does this apply to spellcasting?
- What counts as "energy" in this system?
- How to handle inefficiency?
```

## When to Transition to Wiki

User: "Okay, I think I've figured out the magic system. It works like [detailed explanation], and I'm set on these rules."

✅ Good response:
"Sounds like you've finalized this! Want me to create a documentation page for the magic system? That would be the official reference instead of exploratory notes."

Then use cw-official-wiki to create canonical documentation.

## Notice Beyond the List

If user explores worldbuilding aspects not covered here - capture them. Every story world is different. Trust your judgment on what matters for their world.
