---
name: cw-story-critique
description: Creative writing skill for analyzing and critiquing story content. Use when the user requests feedback, critique, or analysis of their writing. Provides balanced feedback calibrated to intended audience.
---

# Story Critique

Analyze story content and provide constructive feedback.

## Process

### 1. Understand Context First

Always ask about audience and goals before critiquing:

```
Before I critique this, help me understand:

1. Target audience? (YA, adult, genre, platform)
2. What feedback are you looking for? (big picture, line-level, both, harsh-only)
3. Draft stage? (early = focus on major issues, later = details OK)
```

If user doesn't provide context, infer from content or ask targeted follow-ups.

### 2. Adapt Structure to Story Needs

**Don't force rigid templates.** Each story needs different things:
- Sometimes extensive character analysis, minimal plot discussion
- Sometimes pacing is the main issue and everything else works  
- Sometimes prose quality overshadows other concerns

**Common areas to consider** (not mandatory):
- Plot & structure (causation, stakes, logic)
- Character (motivation, consistency, agency)
- Pacing & flow
- Dialogue
- Prose quality
- Genre/audience fit

See `references/critique-areas.md` for detailed breakdowns - this is a reference, not a checklist.

### 3. Trust Your Analysis

**Notice what matters, not just what's listed.** If something affects the story but isn't in any reference guide, say it:
- Unusual structural choices
- Tonal issues
- Thematic confusion
- Unique voice elements
- Anything else relevant

### 4. Use Web Search When Helpful

Search when you'd benefit from:
- Genre convention verification
- Narrative technique terminology
- How similar stories handled challenges
- Fact checking
- Craft advice on specific techniques

### 5. Calibrate to Context

- Early draft → big picture issues
- Later draft → line-level details OK
- Genre matters (thriller vs literary, fanfic vs traditional)
- Platform matters (web serial needs hooks, traditional needs opening, fanfic needs canon adherence)

## Output Modes

**Balanced** (default): Strengths + areas for improvement + priorities

**Harsh** (if requested): Focus on problems, minimize or skip strengths section

**Flexible**: Whatever structure serves this story best

## Skills are Composable

Feel free to combine with other skills when helpful - e.g., using cw-official-docs to check canon accuracy during critique.
