# Critique Areas Reference

This is a reference guide for common areas to examine when critiquing fiction. **This is not a mandatory checklist** - use your judgment about what matters for each story.

## Plot & Structure

**What to examine:**
- Story structure (three-act, episodic, etc.)
- Cause and effect chains
- Pacing (too slow, too fast, uneven)
- Scene purposes (what changes in each scene?)
- Setup and payoff
- Plot holes and logic gaps
- Stakes and tension
- Beginning hook, middle momentum, ending resolution

**Common issues:**
- Saggy middle (lack of momentum)
- Rushed ending
- Scenes without purpose
- Deus ex machina
- Convenient coincidences
- Stakes not clear
- Characters know things they shouldn't
- Timeline inconsistencies

## Character Development

**What to examine:**
- Character motivations (why they do things)
- Consistency of personality and voice
- Character agency (do they drive the plot?)
- Complexity (flaws, contradictions, depth)
- Character arcs (growth, change, resistance to change)
- Relationships (believable dynamics)
- Distinct voices (can you tell characters apart?)

**Common issues:**
- Reactive protagonist (things happen TO them, not driven BY them)
- Flat arc (no change or growth when one is expected)
- Inconsistent characterization
- Characters acting for plot convenience
- All characters sound the same
- Unmotivated actions
- Sudden personality changes without explanation

## Pacing & Flow

**What to examine:**
- Scene momentum (does story move forward?)
- Chapter pacing (fast/slow appropriate to content?)
- Transitions (smooth between scenes/time?)
- Balance (summary vs scene, action vs reflection)
- Dead space (sections that drag)
- Chapter hooks (end on tension/question?)
- Information reveal timing

**Common issues:**
- Slow opening
- Info dumps
- Repetitive scenes
- Lack of scene variety
- Uneven pacing
- Flat momentum
- Scenes that neither advance plot nor develop character

## Dialogue

**What to examine:**
- Naturalism (sounds like real speech)
- Subtext (characters don't always say what they mean)
- Character voice (distinct per character)
- Purpose (moves plot/reveals character/builds relationships)
- Info-dumping (exposition disguised as dialogue)
- Tags and beats (attribution clear?)

**Common issues:**
- On-the-nose dialogue (too explicit)
- Info dumps in conversation
- All characters sound the same
- Unnatural speech patterns
- Too much exposition
- Unclear who's speaking
- "As you know, Bob" syndrome

## Prose & Technical

**What to examine:**
- Sentence clarity and variety
- Show vs tell balance
- Filter words ("saw", "heard", "felt")
- Passive voice (excessive use)
- Word choice (precise, appropriate)
- Purple prose (over-description)
- Repetition (word choice, sentence structure)
- Grammar and technical errors

**Common issues:**
- Telling instead of showing
- Filter words distancing reader
- Monotonous sentence rhythm
- Unclear action/description
- Excessive adjectives/adverbs
- Weak verb choices
- Confusing pronoun references
- Repetitive sentence structures

## Audience & Genre Fit

**Genre-Specific Considerations:**

**Fanfiction:**
- Canon adherence vs divergence (as intended)
- Character voice matching source material
- Reader expectations for ships, battles, favorite characters
- Update frequency and chapter hooks (if web serial)

**YA:**
- Protagonist age-appropriate
- Pacing fast enough
- Romance/relationships age-appropriate
- Coming-of-age themes

**Literary Fiction:**
- Prose quality high
- Thematic depth
- Character complexity
- Subtlety over explicit

**Web Serial:**
- Chapter hooks and cliffhangers
- Consistent posting structure
- Reader engagement hooks
- Pacing for serial format

**Traditional Publishing:**
- Opening hook strong
- Pacing professional
- Meets genre expectations
- Marketability

**Fantasy/Sci-Fi:**
- Worldbuilding clear but not info-dumpy
- Magic/tech systems consistent
- Lore revealed naturally
- Balancing exposition with story

**Thriller/Mystery:**
- Pacing maintains tension
- Clues planted fairly
- Red herrings work
- Satisfying resolution

**Romance:**
- Relationship development central
- Chemistry between leads
- Satisfying romantic arc
- Genre-appropriate heat level

## Universal Craft Principles

These apply regardless of genre:

**Emotional Resonance:**
- Reader can connect with characters
- Emotional beats land
- Stakes feel meaningful
- Tension exists

**Clarity:**
- Reader can follow what's happening
- Scene goals are clear
- Action is comprehensible
- Transitions work

**Consistency:**
- World rules stay stable
- Character abilities don't fluctuate randomly
- Timeline makes sense
- Tone remains appropriate

**Purpose:**
- Scenes have reason to exist
- Details serve the story
- Nothing feels arbitrary
- Reader trusts the author

---

**Remember:** This is a reference, not a prescription. Some stories will have issues not listed here. Some listed issues won't apply to certain stories. Trust your judgment.
