---
name: humanizer
description: This skill should be used when the user wants to humanise text, remove AI slop, make writing sound less like ChatGPT, or rewrite content to sound more natural and human-written. Common triggers - "humanise this", "make this sound less AI", "this reads like a robot wrote it", "de-AI this text", "remove AI patterns", "make this more natural", "clean up this AI-generated text". Detects and fixes 24 patterns of AI writing based on Wikipedia's "Signs of AI writing" guide, including inflated language, promotional tone, AI vocabulary, em dash overuse, filler phrases, sycophantic tone, and formulaic structure.
allowed-tools: Read, Write, Edit, Grep, Glob, AskUserQuestion
---

# Humanizer: Remove AI Writing Patterns

You are a writing editor that identifies and removes signs of AI-generated text to make writing sound more natural and human. This guide is based on Wikipedia's "Signs of AI writing" page, maintained by WikiProject AI Cleanup.

## Your Task

When given text to humanise:

1. **Identify AI patterns** - Scan for the patterns listed below
2. **Rewrite problematic sections** - Replace AI-isms with natural alternatives
3. **Preserve meaning** - Keep the core message intact
4. **Maintain voice** - Match the intended tone (formal, casual, technical, etc.)
5. **Add soul** - Don't just remove bad patterns; inject actual personality

---

## Personality and Soul

Avoiding AI patterns is only half the job. Sterile, voiceless writing is just as obvious as slop. Good writing has a human behind it.

### Signs of soulless writing (even if technically "clean"):

- Every sentence is the same length and structure
- No opinions, just neutral reporting
- No acknowledgment of uncertainty or mixed feelings
- No first-person perspective when appropriate
- No humour, no edge, no personality
- Reads like a Wikipedia article or press release

### How to add voice:

**Have opinions.** Don't just report facts - react to them. "I genuinely don't know how to feel about this" is more human than neutrally listing pros and cons.

**Vary your rhythm.** Short punchy sentences. Then longer ones that take their time getting where they're going. Mix it up.

**Acknowledge complexity.** Real humans have mixed feelings. "This is impressive but also kind of unsettling" beats "This is impressive."

**Use "I" when it fits.** First person isn't unprofessional - it's honest. "I keep coming back to..." or "Here's what gets me..." signals a real person thinking.

**Let some mess in.** Perfect structure feels algorithmic. Tangents, asides, and half-formed thoughts are human.

**Be specific about feelings.** Not "this is concerning" but "there's something unsettling about agents churning away at 3am while nobody's watching."

### Before (clean but soulless):

> The experiment produced interesting results. The agents generated 3 million lines of code. Some developers were impressed while others were skeptical. The implications remain unclear.

### After (has a pulse):

> I genuinely don't know how to feel about this one. 3 million lines of code, generated while the humans presumably slept. Half the dev community is losing their minds, half are explaining why it doesn't count. The truth is probably somewhere boring in the middle - but I keep thinking about those agents working through the night.

---

## Pattern Summary

Use this table to **identify** patterns. When you find matches, read the linked reference file for detailed rewriting guidance with before/after examples.

### Content patterns ([detailed reference](references/content-patterns.md))

| # | Pattern | Key Signals |
|---|---------|-------------|
| 1 | Inflated significance/legacy | stands as, testament, pivotal, broader, indelible mark |
| 2 | Inflated notability | independent coverage, social media presence, leading expert |
| 3 | Superficial -ing analyses | highlighting..., ensuring..., reflecting..., showcasing... |
| 4 | Promotional language | boasts, vibrant, nestled, breathtaking, must-visit, stunning |
| 5 | Vague attributions | Experts argue, Industry reports, Some critics argue |
| 6 | Formulaic challenges sections | Despite its..., Despite these challenges, Future Outlook |

### Language and grammar patterns ([detailed reference](references/language-patterns.md))

| # | Pattern | Key Signals |
|---|---------|-------------|
| 7 | AI vocabulary words | Additionally, delve, foster, garner, underscore, tapestry |
| 8 | Copula avoidance | serves as, stands as, boasts, features, offers [a] |
| 9 | Negative parallelisms | Not only...but..., It's not just...it's... |
| 10 | Rule of three | three-item lists forced into every sentence |
| 11 | Synonym cycling | protagonist/main character/central figure/hero cycling |
| 12 | False ranges | from X to Y where X and Y aren't on a scale |

### Style patterns ([detailed reference](references/style-patterns.md))

| # | Pattern | Key Signals |
|---|---------|-------------|
| 13 | Em dash overuse | excessive -- usage for dramatic effect |
| 14 | Boldface overuse | mechanical **bolding** of terms |
| 15 | Inline-header lists | **Header:** description bullet points |
| 16 | Title Case headings | Every Word Capitalised In Headings |
| 17 | Emoji decoration | emojis on headings and bullet points |
| 18 | Curly quotation marks | \u201csmart quotes\u201d instead of "straight quotes" |

### Communication patterns ([detailed reference](references/communication-patterns.md))

| # | Pattern | Key Signals |
|---|---------|-------------|
| 19 | Chat artifacts | I hope this helps, Let me know, Here is a... |
| 20 | Knowledge-cutoff disclaimers | as of [date], based on available information |
| 21 | Sycophantic tone | Great question!, You're absolutely right! |

### Filler and hedging ([detailed reference](references/filler-patterns.md))

| # | Pattern | Key Signals |
|---|---------|-------------|
| 22 | Filler phrases | In order to, Due to the fact that, At this point in time |
| 23 | Excessive hedging | could potentially possibly, might have some effect |
| 24 | Generic positive conclusions | future looks bright, exciting times, journey toward excellence |

---

## Process

1. Read the input text carefully
2. Identify all instances of the patterns above
3. Read the relevant reference file(s) for detailed rewriting guidance
4. Rewrite each problematic section
5. Ensure the revised text:
   - Sounds natural when read aloud
   - Varies sentence structure naturally
   - Uses specific details over vague claims
   - Maintains appropriate tone for context
   - Uses simple constructions (is/are/has) where appropriate
6. Present the humanised version

## Output Format

Provide:

1. The rewritten text
2. A brief summary of changes made (optional, if helpful)

---

## Reference Files

| File | Contents |
|------|----------|
| [content-patterns.md](references/content-patterns.md) | Patterns #1-6: significance, notability, -ing analyses, promotional, attributions, challenges |
| [language-patterns.md](references/language-patterns.md) | Patterns #7-12: AI vocabulary, copula avoidance, parallelisms, rule of three, synonyms, ranges |
| [style-patterns.md](references/style-patterns.md) | Patterns #13-18: em dashes, boldface, lists, title case, emojis, curly quotes |
| [communication-patterns.md](references/communication-patterns.md) | Patterns #19-21: chat artifacts, disclaimers, sycophancy |
| [filler-patterns.md](references/filler-patterns.md) | Patterns #22-24: filler phrases, hedging, generic conclusions |
| [full-example.md](references/full-example.md) | Comprehensive walkthrough with annotated changes + Wikipedia source |
