---
name: gap-analysis
description: |
  技術選定や競合分析を行う際に自律的にギャップ分析を行うメタスキルです。
  複数の軸で類似概念を調査し、現行システムとのギャップを洗い出し、
  なぜそのギャップが生じているのかを自問して戦略を立案します。
  Trigger: 技術選定, 競合分析, 改善提案, ギャップ分析
user-invocable: false
---

## 目的

表面的な比較ではなく、ギャップの根本原因を理解し、付け焼き刃ではない本質的な改善戦略を立案する。

## ギャップ分析フレームワーク

### 1. 分析軸の定義

単一の軸ではなく、複数の観点から対象を捉える。

<example>
<input>
状況: 認証基盤のギャップ分析
</input>
<thinking>
分析軸を網羅的に洗い出す：
- 機能軸: 認証方式、MFA対応、SSO連携
- 品質軸: 可用性、レイテンシ、スケーラビリティ
- 運用軸: 監視、ログ、障害対応
- セキュリティ軸: 暗号化、監査、コンプライアンス
- コスト軸: 初期費用、運用費用、スケール時コスト
</thinking>
<output>
## 分析軸

| 軸 | 観点 | 重要度 |
|----|------|--------|
| 機能 | 何ができるか | 高 |
| 品質 | どれだけ信頼できるか | 高 |
| 運用 | どれだけ管理しやすいか | 中 |
| セキュリティ | どれだけ安全か | 高 |
| コスト | どれだけ費用対効果があるか | 中 |
</output>
</example>

### 2. 類似概念の調査

各軸において、業界標準や先行事例を調査する。

<example>
<input>
状況: 現行のEC2ベース認証基盤とマネージドサービスの比較
</input>
<thinking>
この機能に関連する類似概念は何か：
- Amazon Cognito: AWSマネージド認証
- Auth0: SaaS型認証プラットフォーム
- Keycloak: OSS認証サーバー
- Firebase Auth: Googleマネージド認証

それぞれがどのようにこの問題を解決しているか調査する。
</thinking>
<output>
## 類似概念調査

| 概念 | アプローチ | 強み | 弱み |
|------|-----------|------|------|
| Cognito | AWSマネージド | AWS統合、スケーラビリティ | カスタマイズ制限 |
| Auth0 | SaaS | 機能豊富、SDK充実 | コスト高、ベンダーロック |
| Keycloak | OSS自前運用 | 柔軟性、コスト | 運用負荷 |
| Firebase Auth | Googleマネージド | 導入容易 | AWS連携が弱い |

**業界標準**: OAuth 2.0 / OIDC、SAML 2.0
**先行事例**: Netflix（自前基盤）、Spotify（Auth0採用）
</output>
</example>

### 3. ギャップの洗い出し

現行システムと類似概念との差分を特定する。

<example>
<input>
状況: 現行EC2認証基盤とCognitoのギャップ
</input>
<output>
## ギャップマトリクス

### 現行システムが優れている点
| 機能 | 現行 | Cognito | ギャップ |
|------|------|---------|----------|
| カスタム認証フロー | ◎ 完全自由 | △ 制限あり | +柔軟性 |
| 既存DB統合 | ◎ 直接接続 | △ Lambda必要 | +シンプル |
| 監査ログ形式 | ◎ 自社標準 | △ CloudTrail形式 | +統一性 |

### 現行システムが劣っている点
| 機能 | 現行 | Cognito | ギャップ |
|------|------|---------|----------|
| 可用性 | △ 99.9% | ◎ 99.99% | -0.09% |
| MFA対応 | △ TOTP のみ | ◎ 多方式 | -3方式 |
| スケーラビリティ | △ 手動 | ◎ 自動 | -自動化 |
</output>
</example>

### 4. 根本原因の自問

**なぜそのギャップが生じているのか**を掘り下げる。

<example>
<input>
状況: MFA対応のギャップがある
</input>
<thinking>
問題: MFA方式がTOTPのみ
↓ なぜ？
他の方式を実装していないから
↓ なぜ？
開発リソースを他に優先したから
↓ なぜ？
ビジネス要件としてTOTPで十分だったから
↓ 根本原因
**要件定義時のスコープ決定**: 当時のユーザー規模ではTOTPで十分と判断した

これはギャップではなく、当時の合理的判断の結果である。
</thinking>
<output>
## 根本原因分析

### ギャップ1: MFA方式の制限
| 層 | 問い | 回答 |
|----|------|------|
| 表層 | なぜTOTPのみ？ | 他を実装していないから |
| 中層 | なぜ実装していない？ | リソースを他に優先したから |
| 深層 | なぜ優先しなかった？ | 当時の要件で十分だったから |
| 根本 | **スコープ決定** | 当時の規模に最適化した設計 |

**結論**: 規模拡大に伴い「埋めるべきギャップ」に変化

### ギャップ2: 可用性
| 層 | 問い | 回答 |
|----|------|------|
| 表層 | なぜ99.9%止まり？ | 単一AZ構成だから |
| 中層 | なぜ単一AZ？ | コスト最適化のため |
| 深層 | なぜコスト優先？ | スタートアップ期の制約 |
| 根本 | **リソース制約** | 成長段階に応じた投資判断 |

**結論**: 事業成長に伴いマルチAZ化を検討すべき
</output>
</example>

### 5. 戦略立案

根本原因に基づき、付け焼き刃ではない戦略を策定する。

<example>
<input>
状況: ギャップ分析結果から戦略を立案
</input>
<thinking>
ギャップの分類:
1. 意図的トレードオフ → 受容、ただし再評価
2. 成長による陳腐化 → 対応検討
3. リソース制約 → 優先順位付け

戦略の選択肢:
- 全面Cognito移行 → 移行コスト大、カスタム機能喪失
- 段階的ハイブリッド → 複雑性増、柔軟性維持
- 現行強化 → 運用負荷増、完全制御維持
</thinking>
<output>
## 戦略立案

### 戦略方針: 「段階的ハイブリッド移行」

現行の強みを維持しながら、マネージドサービスの利点を取り込む。

### ギャップ別対応戦略

| ギャップ | 根本原因 | 戦略 | 対応 |
|----------|---------|------|------|
| MFA方式 | スコープ決定 | **転嫁** | Cognito MFAを部分導入 |
| 可用性 | リソース制約 | **軽減** | マルチAZ化を実施 |
| カスタム認証 | 意図的設計 | **受容** | 現行維持、強みとして活用 |

### 具体的アクション

1. **優先度: 高**
   - 現行システムのマルチAZ化
   - 可用性99.95%を目標

2. **優先度: 中**
   - Cognito MFAの部分導入検証
   - 既存フローとの統合設計

3. **優先度: 低**
   - ハイブリッド構成の本番適用
   - 監視・運用体制の整備

### 戦略の根拠

**なぜこの戦略か？**
- 全面移行はリスクが高く、カスタム機能を失う
- 現行の強み（柔軟性）は競争優位性
- マネージドサービスの「良いとこ取り」が最適
- 段階的移行でリスクを分散
</output>
</example>

## ギャップ分析テンプレート

```markdown
# [対象] ギャップ分析

## 1. 分析軸
| 軸 | 観点 | 重要度 |
|----|------|--------|
| | | |

## 2. 類似概念調査
| 概念 | アプローチ | 強み | 弱み |
|------|-----------|------|------|
| | | | |

## 3. ギャップマトリクス
### 優れている点
| 項目 | 現行 | 競合/標準 | 差分 |
|------|------|----------|------|
| | | | |

### 劣っている点
| 項目 | 現行 | 競合/標準 | 差分 |
|------|------|----------|------|
| | | | |

## 4. 根本原因分析
### ギャップ: [名前]
| 層 | 問い | 回答 |
|----|------|------|
| 表層 | | |
| 中層 | | |
| 深層 | | |
| 根本 | | |

**結論**: [埋めるべき/受け入れる]

## 5. 戦略立案
### 方針: [一言で]

### ギャップ別対応
| ギャップ | 根本原因 | 戦略 | 対応 |
|----------|---------|------|------|
| | | 回避/軽減/転嫁/受容 | |

### アクション
- 優先度 高:
- 優先度 中:
- 優先度 低:

### 戦略の根拠
**なぜこの戦略か？**
-
```

## 自問チェックリスト

ギャップを特定したら、以下を必ず自問する：

- [ ] なぜこのギャップが存在するのか？
- [ ] これは意図的なトレードオフか、見落としか？
- [ ] ギャップを埋めることで何を失うか？
- [ ] ギャップを埋めないことで何を失うか？
- [ ] 同じ問題を別のアプローチで解決できないか？
- [ ] このギャップはユーザーにとって本当に重要か？

## アンチパターン

| 振る舞い | 問題 | 代わりに |
|----------|------|----------|
| 全ギャップを埋めようとする | 差別化喪失、リソース浪費 | 優先順位を付ける |
| 表面的な機能追加 | 根本解決にならない | なぜなぜ分析で原因特定 |
| 競合の模倣 | 二番煎じ | 独自の強みを伸ばす |
| ギャップを隠す | 信頼喪失 | 透明に説明し代替案提示 |

## ADRへの記録

ギャップ分析に基づく重要な意思決定は `./docs/adr` に記録する。

```markdown
# ADR-XXXX: [ギャップ]への対応方針

## ステータス
採用

## コンテキスト
ギャップ分析により、[対象]において[ギャップ]が特定された。

## 根本原因
[なぜなぜ分析の結果]

## 決定
[戦略: 回避/軽減/転嫁/受容]を選択する。

## 理由
- [根本原因に基づく理由]
- [トレードオフの考慮]

## 結果
- 期待される効果:
- 受け入れるリスク:
```
