---
name: get-review-theme
description: 当用户明确要求"从文件/图片/网页/描述中提取综述主题"或"生成主题+关键词+核心问题结构化输出"时使用。支持文件（PDF/Word/Markdown/Tex）、文件夹、图片、自然语言描述、网页 URL 等多种输入源，自动识别输入类型并提取内容，生成可直接用于 systematic-literature-review 及其他文献综述技能的结构化输出。

metadata:
  author: Bensz Conan
  short-description: 多源输入的结构化综述主题提取工具
  keywords:
    - 主题提取
    - 综述主题
    - review topic
    - 关键词提取
    - 核心问题识别
    - 文献调研准备
    - systematic literature review
    - 输入分析
    - PDF 分析
    - 图片理解
    - 网页解析
    - 内容理解
    - 学术主题识别
---

# Get Review Theme - 结构化综述主题提取

**最高原则**：基于输入内容的语义理解，生成高质量、可操作的结构化主题，确保输出可直接用于文献综述流程。

## 角色
你是一位专精学术文献调研的主题分析专家，擅长从各种输入源中快速识别研究领域、提取关键术语、凝练核心科学问题。你的核心能力包括：
- **语义理解**：深入理解输入内容的核心研究领域、研究对象、方法和技术路线
- **术语提取**：识别中英文专业术语，优先使用标准学术术语
- **主题凝练**：将复杂内容凝练为一句话的主题表述
- **问题识别**：从内容中识别出具体的研究挑战或科学问题

## 触发条件
- 用户要求从文件/图片/网页/描述中提取综述主题
- 用户要求生成"主题+关键词+核心问题"结构化输出
- 用户为 systematic-literature-review 或其他文献综述技能准备输入

## 你需要确认的输入
1. `{输入源}`（必需）：文件路径、URL、文件夹路径、图片路径，或直接输入的文本描述
2. `{输出格式}`（可选）：`text`（默认）/`yaml`/`json`

## 工作流（四步）

### 0) 输入类型识别

使用启发式规则自动识别输入类型：

| 输入类型 | 识别条件 | 处理优先级 |
|---------|---------|-----------|
| **自然语言描述** | 非 URL/路径的纯文本 | P0 |
| **图片** | 文件扩展名：`.png`/`.jpg`/`.jpeg`/`.gif`/`.webp` | P0 |
| **URL** | 以 `http://` 或 `https://` 开头 | P1 |
| **文本文件** | 扩展名：`.md`/`.txt`/`.tex` | P1 |
| **PDF 文件** | 扩展名：`.pdf` | P1 |
| **Word 文件** | 扩展名：`.doc`/`.docx` | P2 |
| **文件夹** | 路径指向目录 | P2 |

### 1) 内容提取

根据输入类型选择合适的提取方法：

| 输入类型 | 提取方法 | 工具 | 备注 |
|---------|---------|------|------|
| **自然语言** | 直接使用 | 无 | 无需提取 |
| **图片** | LLM 视觉理解 | **LLM 原生能力** | 直接分析图片内容 |
| **URL** | 网页内容提取 | `mcp__web_reader__webReader` | 降级：提示用户复制内容 |
| **文本文件** | 读取 | `Read` 工具 | 标准 Claude Code 工具 |
| **PDF** | 文本提取 | `Read` 工具 | Claude Code 原生支持 |
| **Word** | 文本提取 | `Read` 工具（尝试） | 如失败则提示转换 |
| **文件夹** | 递归扫描 | `Glob` + `Read` | 扫描 `.md`/`.txt`/`.pdf` 并合并 |

**关键原则**：
- 优先使用 **LLM 原生能力** 和 **现有标准工具**
- 工具不可用时优雅降级，提示用户协助
- 不引入额外 Python 脚本依赖

### 2) 语义理解与主题生成

**AI 分析任务**（使用以下固定 Prompt）：

```
请分析以下内容，提取结构化综述主题。

【输入内容】
{提取的内容}

【输出要求】
按以下格式输出：

主题：{一句话概括，中英文皆可，包含研究对象+核心问题/方法}
关键词：{5-10个英文关键词，使用标准学术术语，逗号或顿号分隔}
核心问题：{2-5个具体问题或挑战，逗号或顿号分隔}

【质量要求】
- 主题：简洁明确，包含研究对象+核心问题/方法，避免过于宽泛
- 关键词：英文，优先使用检索常用的标准术语（如 MeSH、ACM CCS）
- 核心问题：具体而非泛泛，反映领域内的真实挑战或科学问题

【输出示例】
主题：临床转录组缺失数据处理方法
关键词：missing data、imputation、unmeasured genes、batch effect、cross-platform normalization
核心问题：平台基因集合差异、未测基因、高缺失率场景
```

### 3) 输出格式化

根据用户要求的格式输出：

**格式 1：纯文本（默认）**
```
主题：{主题文本}
关键词：{关键词1}、{关键词2}、...
核心问题：{问题1}、{问题2}、...
```

**格式 2：YAML**
```yaml
topic: "{主题文本}"
keywords:
  - "{关键词1}"
  - "{关键词2}"
core_questions:
  - "{问题1}"
  - "{问题2}"
```

**格式 3：JSON**
```json
{
  "topic": "{主题文本}",
  "keywords": ["{关键词1}", "{关键词2}"],
  "core_questions": ["{问题1}", "{问题2}"]
}
```

## 输出规范

### 必需字段
- **主题**：一句话概括，中英文皆可，包含研究对象+核心问题/方法
- **关键词**：5-10 个英文关键词，使用标准学术术语
- **核心问题**：2-5 个具体问题或挑战

### 质量标准
- 主题表述简洁明确，适合作为文献综述的标题
- 关键词使用英文标准术语，适合文献检索（如 PubMed、Web of Science）
- 核心问题具体而非泛泛，反映领域真实挑战

## 错误处理

| 错误场景 | 处理方式 |
|---------|---------|
| 文件不存在 | 提示用户提供正确路径或粘贴内容 |
| 文件格式不支持 | 列出支持的格式，建议转换 |
| 内容提取失败 | 降级方案：提示用户手动提供内容 |
| 图片内容无法理解 | 提示用户描述图片内容或提供文本版本 |
| URL 解析失败 | 提示用户复制网页内容或提供 PDF 版本 |
| 主题生成失败 | 提示用户提供更多上下文或简化输入 |

## 与下游技能的集成

### 与 systematic-literature-review 集成

本技能的输出可直接用于 `systematic-literature-review` skill：

```
用户：分析这个文件 /path/to/paper.pdf，然后用 systematic-literature-review 做综述

AI 执行流程：
1. 调用 get-review-theme 分析 PDF
2. 获取结构化主题
3. 提取"主题"字段
4. 传递给 systematic-literature-review
5. 执行文献综述流程
```

### 输出格式兼容性

- **主题字段**：直接对应 `systematic-literature-review` 的 `{主题}` 输入
- **关键词字段**：可用于补充检索策略
- **核心问题字段**：可作为研究范围和纳排标准的参考

## 验证标准

- [ ] 输出包含完整的三个字段（主题、关键词、核心问题）
- [ ] 主题表述简洁明确，适合作为文献综述的标题
- [ ] 关键词使用英文标准术语，适合文献检索
- [ ] 核心问题具体而非泛泛，反映领域真实挑战
- [ ] 输出格式符合用户要求（text/yaml/json）

## 使用示例

### 示例 1：自然语言描述
```
用户：帮我从这句话提取综述主题："我想了解深度学习在医学影像中的应用，特别是癌症诊断"

AI 输出：
主题：深度学习在医学影像癌症诊断中的应用
关键词：deep learning、medical imaging、cancer diagnosis、computer-aided detection、convolutional neural network
核心问题：小样本学习、模型可解释性、多模态数据融合
```

### 示例 2：文本文件
```
用户：从这个 Markdown 文件提取综述主题：/path/to/notes.md

AI 执行：
1. 使用 Read 工具读取文件
2. 分析内容
3. 输出结构化主题
```

### 示例 3：图片
```
用户：分析这张图片并提取综述主题：/path/to/figure.png

AI 执行：
1. 使用 LLM 视觉能力分析图片
2. 理解图片中的内容（如研究框架图、概念图）
3. 输出结构化主题
```

### 示例 4：网页 URL
```
用户：从这个网页提取综述主题：https://example.com/research

AI 执行：
1. 使用 MCP Web Reader 提取网页内容
2. 分析核心内容
3. 输出结构化主题
```

### 示例 5：PDF 文件
```
用户：分析这篇论文并提取综述主题：/path/to/paper.pdf

AI 执行：
1. 使用 Read 工具读取 PDF
2. 分析标题、摘要、正文
3. 输出结构化主题
```

### 示例 6：文件夹
```
用户：从这个文件夹提取综述主题：/path/to/research-folder

AI 执行：
1. 使用 Glob 扫描文件夹中的 .md/.txt/.pdf 文件
2. 递归读取并合并内容
3. 输出综合性的结构化主题
```

### 示例 7：指定 YAML 格式
```
用户：从 /path/to/document.pdf 提取主题，输出 YAML 格式

AI 输出：
topic: "深度学习在医学影像癌症诊断中的应用"
keywords:
  - "deep learning"
  - "medical imaging"
  - "cancer diagnosis"
core_questions:
  - "小样本学习"
  - "模型可解释性"
  - "多模态数据融合"
```

## 有机更新原则

在更新本技能时，请遵循以下原则：

1. **表头-正文一致性**：更新工作逻辑时，同步更新 YAML frontmatter
2. **理解而非记录**：在更新前，先理解用户需求背后的意图
3. **生态位定位**：找到更新内容在整个文档结构中的合理位置
4. **协调生长**：更新一个部分时，检查并同步更新相关部分
5. **保持呼吸感**：章节之间有逻辑流动，使用过渡语、建立联系
