# Guide Updater — 用户使用指南

本 README 面向**使用者**：如何触发并正确使用 `guide-updater` skill。
执行指令与硬性规范在 `SKILL.md`；默认参数在 `config.yaml`。

---

## 推荐工作流

```
systematic-literature-review（文献综述） → guide-updater（优化指南）
                   ↓
      在与 AI 的持续交互中明确标书关键部分，
      深化对项目的理解，形成可复用的写作规范
```

这是 `guide-updater` 最强大的使用场景——先用 `systematic-literature-review` 进行文献综述，然后将综述中沉淀的洞察融会贯通，有机地、增量地优化项目指南。

---

## 快速开始

### 开发者推荐 1：多轮对话优化项目指南

通过多轮对话逐步沉淀写作洞见，让 `guide-updater` 在交互过程中持续优化项目指南：

```
我后续会给出很多指令，我需要你结合那些指令和 guide-updater 这个skill来进行
项目指南.md 的优化。你先做一些准备工作；如果你完成了，请告诉我"准备好了"即可。
先不要开始操作。
```

**工作方式**：
- AI 先完成准备工作（读取指南文件、理解 skill 规范、验证结构等）
- 确认"准备好了"后，你可以逐条给出指令
- 每条指令都会以最小补丁方式融入指南，不破坏既有结构
- 支持随时调整方向、回退修改或补充新洞见

**适用场景**：
- 需要通过多轮讨论逐步明确项目规范
- 希望在对话中试错、迭代、优化写作口径
- 将碎片化洞见系统化沉淀为可复用指南

---

### 开发者推荐 2：从文献综述融会贯通更新项目指南

```
我之前用 systematic-literature-review 这个skill做了很多文献综述的工作，
保存在 xxx/reviews 这个文件夹里，其中和目前标书相关的主题包括：xxx、xxx。
请仔细阅读这些综述的 tex 文件（只读，千万不能修改），彻底理解它们的内容，
融会贯通，然后使用 guide-updater 这个skill 有机地、增量地优化本项目的
`项目指南.md`。如果`项目指南.md`不符合 guide-updater 的一般规范，可以修改，
但千万不要修改该skill的源代码。
```

**适用场景**：
- 准备撰写新标书/论文，希望将既往综述的洞察系统化沉淀
- 多个综述项目共享方法论，需要统一口径
- 将领域知识转化为可复用的写作规范

**重要约束**：
- 综述文件**只读不写**，绝不修改原始综述内容
- skill 源代码（`SKILL.md`、`config.yaml`、脚本等）**不可修改**

---

### 日常用法（自然语言触发）

```
更新项目指南（路径：projects/MyProject/项目指南.md）：
我们在对话中发现了一个新的写作原则——所有缩写词首次出现时必须全称+缩写，
请将这条原则沉淀到指南中。
```

**适用场景**：
- 对话中产生了新的写作规范或术语约定
- 需要快速将单条洞见沉淀到指南
- 保持项目口径的一致性

---

## 设计理念

`guide-updater` 的核心价值在于：

1. **实时沉淀**：将对话中产生的可复用写作洞见立即写入指南，避免遗忘
2. **融入式更新**：新增内容融入既有结构，不破坏原有组织
3. **口径一致**：统一术语、缩写、写法，减少全文口径漂移
4. **可检验可复现**：通过结构验证确保指南质量稳定

> **核心原则**：不新增 `##` 级标题，不在既有标题中"另起炉灶"，只做最小补丁式增量更新。

---

## 功能概述

| 特性 | 说明 |
|------|------|
| **原子洞见抽取** | 将用户表达拆成若干条"可落笔"的要点，每条只包含一个主张/规则/写法 |
| **智能落点选择** | 根据洞见类型自动选择合适的章节（写作哲学/命名术语/基本原理等） |
| **最小补丁写入** | 只做增量更新，新增 1-3 条 bullet 或在既有 bullet 末尾补充 |
| **结构验证** | 通过 `scripts/validate_guide.py` 确保关键标题未被破坏 |

---

## 洞见类型 → 推荐落点对照表

| 洞见类型 | 推荐落点 | 示例 |
|---------|---------|------|
| **写作原则/禁语/句式建议** | `## 写作哲学` | "避免使用'显著提高'等模糊表述" |
| **术语/缩写/大小写/核心概念定义** | `## 命名与术语` | "英文缩写首次出现必须使用'全称（缩写）'格式" |
| **方法链条/验证口径/评估指标** | `## 基本原理` | "统计分析必须报告效应量" |
| **范式定位/对照坐标系/差异化要点** | `## 文献综述与创新性` | "本研究与 XXX 方法的差异在于..." |
| **具体写到文档哪一节** | `## 落点清单` | "在技术路线图中必须包含验证步骤" |
| **评审问答口径** | `## 评审专家可能的问题及回答` | "Q: 样本量是否足够？A: ..." |
| **风险与对策** | `## 研究风险` | "风险：数据缺失；影响：..." |
| **可核验事实锚点**（源码/参数/流程） | `## 附录` | "数据预处理脚本位于 `scripts/preprocess.py`" |

> **不确定放哪？** 优先放到"最能减少未来写作返工"的位置；仍不确定可以先问用户。

---

## 更新原则（核心约束）

更新项目指南时，必须遵循以下原则：

| 原则 | 说明 | 反模式 |
|------|------|--------|
| **不新增 `##` 级标题** | 只在既有小节/列表中融入新增要点 | ❌ 新开"## 新发现的原则"章节 |
| **不改动既有标题** | 不修改标题文本、编号、顺序 | ❌ 将"## 命名与术语"改为"## 术语规范" |
| **最小补丁式更新** | 新增 1-3 条 bullet 或在既有 bullet 末尾补充 | ❌ 重写整个章节 |
| **保持写法一致** | 新增内容紧贴相邻条目的写法与语气 | ❌ 用完全不同的风格新增内容 |
| **只写可核验信息** | 涉及事实/文献时，只写可核验信息 | ❌ 编造文献引用或具体数字 |
| **标注待核验内容** | 无法核验的信息标注"待核验" | ❌ 将不确定的内容当作事实写入 |

---

## 配置选项

| 参数 | 默认值 | 说明 |
|------|--------|------|
| `guide_path` | **必填** | 项目指南文件的路径（相对于项目根目录或绝对路径） |

在 Prompt 中指定路径的方式：
- "更新项目指南（路径：projects/MyProject/项目指南.md）"
- "把这些内容同步到指南文件 docs/写作指南.md"

---

## 备选用法（脚本/硬编码流程）

### 步骤 1：验证指南结构

```bash
# 检查指南文件是否包含所有必需的标题
python3 skills/guide-updater/scripts/validate_guide.py projects/MyProject/项目指南.md
```

**说明**：验证指南是否包含 7 个必需的 `##` 级标题（写作哲学、命名与术语、基本原理、文献综述与创新性、落点清单、研究风险、附录）

**输出**：
- `[OK] Guide structure looks intact.` — 结构完整
- `[FAIL] Required headings missing:` — 缺少必需标题，会列出缺失的标题

---

### 步骤 2：手动更新指南（可选）

如果需要手动编辑指南，请遵循：
1. 不新增 `##` 级标题
2. 新增内容写成 1 条或少量 bullet
3. 紧贴相邻条目的写法与语气
4. 涉及事实/文献时，只写可核验信息

---

### 步骤 3：再次验证结构

```bash
python3 skills/guide-updater/scripts/validate_guide.py projects/MyProject/项目指南.md
```

**说明**：确认手动更新后结构仍然完整

---

## 输出文件

- `{项目指南.md}` — 更新后的项目指南文件
- 验证脚本的输出（标准输出/标准错误）

---

## 配套资源

| 资源 | 用途 |
|------|------|
| `references/guide-structure-map.md` | 详细的结构映射与落点规则，用于判断洞见应该写入哪个章节 |
| `scripts/validate_guide.py` | 验证指南文件的结构完整性，确保关键标题未被破坏 |

---

## 常见问题

### Q：技能会改动指南的既有结构吗？

A：不会。`guide-updater` 遵循"融入式更新"原则：
- 不新增 `##` 级标题
- 不改动既有标题的文本、编号、顺序
- 不为"整理美观"重排大量内容
- 只在既有小节/列表中新增 bullet

如果验证脚本检测到结构被破坏，会返回错误。

---

### Q：如何确保新增内容放对了位置？

A：技能会根据洞见类型自动选择落点：
1. 写作原则/禁语 → `## 写作哲学`
2. 术语/缩写/核心概念 → `## 命名与术语`
3. 方法链条/评估指标 → `## 基本原理`
4. 差异化要点/对照坐标系 → `## 文献综述与创新性`
5. 评审问答口径 → `## 评审专家可能的问题及回答`

你也可以在 Prompt 中明确指定落点（见[示例 4](#示例-4指定落点位置高级用法)）。

---

### Q：如果我不知道应该放哪，怎么办？

A：技能会自动判断。如果自动判断不确定，会问你：
- "更希望作为写作哲学/技术路线/风险控制哪一类沉淀？"

你也可以参考 [guide-structure-map.md](references/guide-structure-map.md) 中的详细规则。

---

### Q：更新后如何验证指南是否正确？

A：运行验证脚本：

```bash
python3 skills/guide-updater/scripts/validate_guide.py <指南文件路径>
```

如果输出 `[OK] Guide structure looks intact.`，说明结构完整。

---

### Q：我可以手动编辑指南文件吗？

A：可以。手动编辑时请遵循：
1. 不新增 `##` 级标题
2. 新增内容写成 1 条或少量 bullet
3. 紧贴相邻条目的写法与语气
4. 涉及事实/文献时，只写可核验信息

编辑后运行验证脚本确认结构完整。

---

### Q：如果洞见内容很大，怎么处理？

A：技能会自动拆分成多个 bullet，分散落在对应小节。例如：
- 一条关于"统计分析规范"的洞见可能被拆成：
  - "必须报告检验方法、统计量、P 值" → `## 基本原理`
  - "必须报告效应量和置信区间" → `## 基本原理`
  - "多重比较校正需要说明方法" → `## 落点清单`

这样既保持了结构稳定，又确保了洞见的完整性。

---

### Q：技能会编造文献引用或具体数字吗？

A：不会。技能遵循"只写可核验信息"原则：
- 涉及事实/文献时，只写可核验信息
- 无法核验的信息会标注"待核验"
- 不会编造作者名、期刊名、页码、具体数字等详细信息

如果发现无法核验的内容，请在 Prompt 中提供准确的参考文献或数据。

---

## 更多文档

- `SKILL.md` — 技能执行指令与硬性规范
- `references/guide-structure-map.md` — 详细的结构映射与落点规则
- `config.yaml` — 技能配置参数
