---
name: nsfc-abstract
description: 当用户明确要求"写/润色 NSFC 标书摘要""生成中文摘要和英文摘要""把中文摘要翻译成英文摘要"时使用。输出中文、英文两个版本（英文必须是中文的忠实翻译版），同时输出标题建议（1个推荐标题+5个候选标题及理由）。中文摘要默认≤400字符，英文摘要默认≤4000字符。输出方式：将结果写入工作目录下的 `NSFC-ABSTRACTS.md`。⚠️ 不适用：用户只想翻译一段与标书无关的通用文本（应直接翻译）；用户只想写立项依据/研究内容/研究基础正文（应使用对应 nsfc 系列 skill）。
metadata:
  author: Bensz Conan
  short-description: NSFC 标书中英文摘要生成（中文≤400字；英文≤4000字符）
  keywords:
    - nsfc
    - 摘要
    - abstract
    - 青年基金
    - 标书写作
  triggers:
    - 标书摘要
    - NSFC 摘要
    - 中英文摘要
    - 英文摘要
config: skills/nsfc-abstract/config.yaml
---

# NSFC 中英文摘要生成器

目标：写出“评审一眼读懂”的五句式摘要，做到**重要性**、**科学问题**、**可行性证据**、**研究内容**、**科学意义**五个要素齐全；并输出与之一致的英文翻译。

## 输入（先要信息，缺啥就问啥）

优先让用户按信息表提供（见 `skills/nsfc-abstract/references/info_form.md`）。若用户只给了零散信息，先用 3-6 个问题补齐最关键缺口：
- 你希望题目更偏“机制向 / 方法向 / 转化向 / 场景向”哪一类？（不确定可不选，默认给混合候选）
- 研究对象/场景是什么？（疾病/材料/系统/任务）
- 领域痛点与未解决的科学问题是什么？（一句话）
- 你们的关键前期发现/预实验/数据点是什么？（1-2 条，可定量）
- 拟验证的科学假说/核心判断是什么？（一句话）
- 研究内容 3-4 点分别要做什么、用什么方法、得到什么可验证结果？
- 预期科学意义/应用价值是什么？（避免空话）

## 输出要求（硬约束）

- **必须同时给出中文与英文**；英文是中文的**忠实翻译**（不扩写、不新增假设、不引入新结果）。
- **必须给出标题建议**：遵循 `skills/nsfc-abstract/references/title-rules.md` 的”中标题目”结构偏好；至少包含：
  - `推荐标题：...`（中文）
  - `Recommended Title: ...`（英文，紧跟推荐标题下一行）
  - `1) ... —— 理由：... / EN: ...`（至少 5 条；数量以 `config.yaml:title.title_candidates_default` 为准；每条末尾附英文翻译）
- **中文摘要**：默认 ≤ 400 字符（含标点）；推荐 5 句（以 `config.yaml:limits.zh_recommended_sentences` 为准），每句 1 个功能。
- **英文摘要**：≤ 4000 字符（含标点）；语法正确、术语一致。
- 不使用夸大/营销式表达（如“国际领先/填补空白/首创”），除非用户提供可核验依据且明确要求保留。
- 不堆砌背景，不罗列方法学名词；每个方法名词必须服务于“要验证什么”。

## 推荐结构（五句式，默认采用）

1) **重要性/背景**：一句话说明对象的重要性与危害/瓶颈（不超过 1 句）。
2) **科学问题**：指出关键未知与当前不足（要具体到机制/指标/因果链的缺口）。
3) **可行性证据**：给出 1-2 条前期发现/预实验（尽量可定量），并顺势提出科学假说/核心判断。
4) **研究内容（3-4 点）**：用动词开头，写清“做什么→怎么做→要验证什么/得到什么判据”（点数默认以 `config.yaml:limits.content_points_min/max` 为准）。
5) **意义/价值**：总结预期贡献（科学机制 + 方法/策略/应用潜力），与第 2 句的问题形成闭环。

## 输出格式（便于粘贴与校验）

按如下格式写入 `NSFC-ABSTRACTS.md`（标题文本以 `config.yaml:output.zh_heading/en_heading` 为准）。在末尾给出长度自检（字符数计数口径：把连续空白折叠为单个空格后计数，含标点）：

```text
# 标题建议
推荐标题：...
Recommended Title: ...
1) ... —— 理由：... / EN: ...
2) ... —— 理由：... / EN: ...
3) ... —— 理由：... / EN: ...
4) ... —— 理由：... / EN: ...
5) ... —— 理由：... / EN: ...

# 中文摘要
（正文）

# English Abstract
(translation)

## 长度自检
- 中文摘要字符数：N/400
- 英文摘要字符数：M/4000
```

写入文件后，在对话中**不要重复粘贴全文**（除非用户明确要求），只需回报：
- 写入的文件路径（默认 `./NSFC-ABSTRACTS.md`）
- 标题候选数量是否满足默认要求
- 中文/英文字符数与是否超限

## 字数超限处理（闭环，最多 3 轮）

当用户明确要求“中文≤400字符/英文≤4000字符”等硬约束时，必须走闭环：**先检测，再压缩，再检测，合格后再写入**。

1) 先生成一个“可读但可能超限”的初稿（五句式要素齐全）。
2) 用确定性脚本检测（必须用 `--json`，让硬编码负责精确计数）：
   - `python3 skills/nsfc-abstract/scripts/validate_abstract.py - --json --diff --strict`
   - 输入可通过 stdin（无需先写文件），或在写入 `NSFC-ABSTRACTS.md` 后对文件校验。
3) 若超限：按“压缩优先级”执行压缩，再回到步骤 2，最多 3 轮。
4) 连续 3 轮仍超限：停止自动压缩，向用户说明当前超限数（ZH/EN exceeded），并请用户选择：
   - 允许删减某些信息（哪些可删）
   - 放宽字数上限（修改 `config.yaml`）
   - 人工给出更短的关键信息摘要（例如只保留最关键 1 条证据 + 3 点研究内容）

### 压缩优先级（从上到下）

- P0（必须保留）：研究对象/关键科学问题缺口/定量证据（若有）/核心方法名称/预期贡献闭环
- P1（优先精简）：程度副词、形容词修饰、背景铺垫、“我们将/本研究”主语、过程性描述、“通过/采用”等介词短语、并列重复表达
- P2（可删除）：空洞评价（无定量支撑的“显著/重要/领先”等）、重复句、与科学问题无关的背景

如需确定性写入/校验，可使用脚本：
- 写入：`python3 skills/nsfc-abstract/scripts/write_abstracts_md.py <input> --strict`
- 校验：`python3 skills/nsfc-abstract/scripts/validate_abstract.py NSFC-ABSTRACTS.md --json --diff --strict`
